/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BStringSubstring is a component that return substring from of a string.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStringSubstring
  extends BComponent
  implements BIStatus
{
  /*-
  
  class BStringSubstring
  {
    properties
    {
      
      out: BStatusString
        flags { transient, summary }
        default {[ new BStatusString() ]}
        
      in: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}

      beginIndex: int
        default {[ 0 ]}

      endIndex: int
        default {[ -1 ]}


    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BStringSubstring(269323894)1.0$ @*/
/* Generated Fri Apr 16 16:42:31 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#getOut
   * @see com.tridium.kitControl.util.BStringSubstring#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#out
   */
  public BStatusString getOut() { return (BStatusString)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#out
   */
  public void setOut(BStatusString v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#getIn
   * @see com.tridium.kitControl.util.BStringSubstring#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#in
   */
  public BStatusString getIn() { return (BStatusString)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#in
   */
  public void setIn(BStatusString v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "beginIndex"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>beginIndex</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#getBeginIndex
   * @see com.tridium.kitControl.util.BStringSubstring#setBeginIndex
   */
  public static final Property beginIndex = newProperty(0, 0,null);
  
  /**
   * Get the <code>beginIndex</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#beginIndex
   */
  public int getBeginIndex() { return getInt(beginIndex); }
  
  /**
   * Set the <code>beginIndex</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#beginIndex
   */
  public void setBeginIndex(int v) { setInt(beginIndex,v,null); }

////////////////////////////////////////////////////////////////
// Property "endIndex"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>endIndex</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#getEndIndex
   * @see com.tridium.kitControl.util.BStringSubstring#setEndIndex
   */
  public static final Property endIndex = newProperty(0, -1,null);
  
  /**
   * Get the <code>endIndex</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#endIndex
   */
  public int getEndIndex() { return getInt(endIndex); }
  
  /**
   * Set the <code>endIndex</code> property.
   * @see com.tridium.kitControl.util.BStringSubstring#endIndex
   */
  public void setEndIndex(int v) { setInt(endIndex,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStringSubstring.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStringSubstring()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    getOut().setValue(calculate());
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == in || p == beginIndex || p == endIndex)
    {
      getOut().setValue( calculate() );
    }
  }

  private String calculate()
  {
    try
    {
      if(!getIn().getStatus().isValid())
        return getOut().getValue();
      String input = getIn().getValue();
      int begin = getBeginIndex();
      int end = getEndIndex();
      if(end < 0)
        end = Integer.MAX_VALUE;
      if(begin < 0 || begin >= input.length()) return "";
      if( end >= input.length() )
        return input.substring(begin);
      return input.substring(begin, end);
    }
    catch(Exception e)
    {
      return "";
    }

  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  
}
