/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BStringSelect uses a numeric to switch between multiple strings.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 19$ $Date: 3/30/2004 3:43:05 PM$
 * @since     Baja 1.0
 */
public class BStringSelect
  extends BMuxSwitch
  implements BIStatus
{  

  public static final Property facets = newProperty(0, BFacets.DEFAULT);

  /*-
  
  class BStringSelect
  {
    properties
    {
      out: BStatusString
        -- The output of a BNumericPoint is a BStatusString
        flags { operator, readonly, transient, summary }
        default {[ new BStatusString() ]}
        
      inA: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
      inB: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
      inC: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
      inD: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
      inE: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
      inF: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
      inG: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
      inH: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
      inI: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
      inJ: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BStringSelect(61974211)1.0$ @*/
/* Generated Wed Aug 11 09:31:17 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * The output of a BNumericPoint is a BStatusString
   * @see com.tridium.kitControl.util.BStringSelect#getOut
   * @see com.tridium.kitControl.util.BStringSelect#setOut
   */
  public static final Property out = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#out
   */
  public BStatusString getOut() { return (BStatusString)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#out
   */
  public void setOut(BStatusString v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#getInA
   * @see com.tridium.kitControl.util.BStringSelect#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inA
   */
  public BStatusString getInA() { return (BStatusString)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inA
   */
  public void setInA(BStatusString v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#getInB
   * @see com.tridium.kitControl.util.BStringSelect#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inB
   */
  public BStatusString getInB() { return (BStatusString)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inB
   */
  public void setInB(BStatusString v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Property "inC"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#getInC
   * @see com.tridium.kitControl.util.BStringSelect#setInC
   */
  public static final Property inC = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inC
   */
  public BStatusString getInC() { return (BStatusString)get(inC); }
  
  /**
   * Set the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inC
   */
  public void setInC(BStatusString v) { set(inC,v,null); }

////////////////////////////////////////////////////////////////
// Property "inD"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#getInD
   * @see com.tridium.kitControl.util.BStringSelect#setInD
   */
  public static final Property inD = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inD
   */
  public BStatusString getInD() { return (BStatusString)get(inD); }
  
  /**
   * Set the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inD
   */
  public void setInD(BStatusString v) { set(inD,v,null); }

////////////////////////////////////////////////////////////////
// Property "inE"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#getInE
   * @see com.tridium.kitControl.util.BStringSelect#setInE
   */
  public static final Property inE = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inE
   */
  public BStatusString getInE() { return (BStatusString)get(inE); }
  
  /**
   * Set the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inE
   */
  public void setInE(BStatusString v) { set(inE,v,null); }

////////////////////////////////////////////////////////////////
// Property "inF"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#getInF
   * @see com.tridium.kitControl.util.BStringSelect#setInF
   */
  public static final Property inF = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inF
   */
  public BStatusString getInF() { return (BStatusString)get(inF); }
  
  /**
   * Set the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inF
   */
  public void setInF(BStatusString v) { set(inF,v,null); }

////////////////////////////////////////////////////////////////
// Property "inG"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#getInG
   * @see com.tridium.kitControl.util.BStringSelect#setInG
   */
  public static final Property inG = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inG
   */
  public BStatusString getInG() { return (BStatusString)get(inG); }
  
  /**
   * Set the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inG
   */
  public void setInG(BStatusString v) { set(inG,v,null); }

////////////////////////////////////////////////////////////////
// Property "inH"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#getInH
   * @see com.tridium.kitControl.util.BStringSelect#setInH
   */
  public static final Property inH = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inH
   */
  public BStatusString getInH() { return (BStatusString)get(inH); }
  
  /**
   * Set the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inH
   */
  public void setInH(BStatusString v) { set(inH,v,null); }

////////////////////////////////////////////////////////////////
// Property "inI"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#getInI
   * @see com.tridium.kitControl.util.BStringSelect#setInI
   */
  public static final Property inI = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inI
   */
  public BStatusString getInI() { return (BStatusString)get(inI); }
  
  /**
   * Set the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inI
   */
  public void setInI(BStatusString v) { set(inI,v,null); }

////////////////////////////////////////////////////////////////
// Property "inJ"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#getInJ
   * @see com.tridium.kitControl.util.BStringSelect#setInJ
   */
  public static final Property inJ = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inJ
   */
  public BStatusString getInJ() { return (BStatusString)get(inJ); }
  
  /**
   * Set the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BStringSelect#inJ
   */
  public void setInJ(BStatusString v) { set(inJ,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStringSelect.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Interfaces
////////////////////////////////////////////////////////////////

  public BStatusValue getNullInstance()
  {
    return new BStatusString();
  }
  
  public boolean isMuxSwitch()
  {
    return true;
  }

  public final BStatusValue getInStatusValue(int select)
  {
    switch(select)
    {
    case 1: return getInA();
    case 2: return getInB();
    case 3: return getInC();
    case 4: return getInD();
    case 5: return getInE();
    case 6: return getInF();
    case 7: return getInG();
    case 8: return getInH();
    case 9: return getInI();
    case 10: return getInJ();
    }
    return getNullInstance();
  }
  
  public void setOutput(BStatusValue value)
  {
    setOut((BStatusString)value );
  }
  
  public BStatus getOutStatus()
  {
    return getOut().getStatus();
  }
  
  public void setOutStatus(BStatus status)
  {
    getOut().setStatus(status);
  }
  
  public String toString(Context cx) { return getOut().toString(cx); }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  
  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");


}
