/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BStringTest is a component that converts a float to a statusNumeric.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStringIndexOf
  extends BComponent
{

  /*-
  
  class BStringIndexOf
  {
    properties
    {
      
      out: BStatusBoolean
        flags { transient, summary }
        default {[ new BStatusBoolean() ]}

      inA: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}

      inB: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
      fromIndex: int
        flags { transient }
        default {[ 0 ]}
        
      beginIndex: int
        flags { transient }
        default {[ -1 ]}
        
      afterIndex: int
        flags { transient }
        default {[ -1 ]}
    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BStringIndexOf(1192658973)1.0$ @*/
/* Generated Fri Apr 16 16:42:30 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#getOut
   * @see com.tridium.kitControl.util.BStringIndexOf#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#out
   */
  public BStatusBoolean getOut() { return (BStatusBoolean)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#out
   */
  public void setOut(BStatusBoolean v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#getInA
   * @see com.tridium.kitControl.util.BStringIndexOf#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#inA
   */
  public BStatusString getInA() { return (BStatusString)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#inA
   */
  public void setInA(BStatusString v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#getInB
   * @see com.tridium.kitControl.util.BStringIndexOf#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#inB
   */
  public BStatusString getInB() { return (BStatusString)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#inB
   */
  public void setInB(BStatusString v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Property "fromIndex"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fromIndex</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#getFromIndex
   * @see com.tridium.kitControl.util.BStringIndexOf#setFromIndex
   */
  public static final Property fromIndex = newProperty(Flags.TRANSIENT, 0,null);
  
  /**
   * Get the <code>fromIndex</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#fromIndex
   */
  public int getFromIndex() { return getInt(fromIndex); }
  
  /**
   * Set the <code>fromIndex</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#fromIndex
   */
  public void setFromIndex(int v) { setInt(fromIndex,v,null); }

////////////////////////////////////////////////////////////////
// Property "beginIndex"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>beginIndex</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#getBeginIndex
   * @see com.tridium.kitControl.util.BStringIndexOf#setBeginIndex
   */
  public static final Property beginIndex = newProperty(Flags.TRANSIENT, -1,null);
  
  /**
   * Get the <code>beginIndex</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#beginIndex
   */
  public int getBeginIndex() { return getInt(beginIndex); }
  
  /**
   * Set the <code>beginIndex</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#beginIndex
   */
  public void setBeginIndex(int v) { setInt(beginIndex,v,null); }

////////////////////////////////////////////////////////////////
// Property "afterIndex"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>afterIndex</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#getAfterIndex
   * @see com.tridium.kitControl.util.BStringIndexOf#setAfterIndex
   */
  public static final Property afterIndex = newProperty(Flags.TRANSIENT, -1,null);
  
  /**
   * Get the <code>afterIndex</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#afterIndex
   */
  public int getAfterIndex() { return getInt(afterIndex); }
  
  /**
   * Set the <code>afterIndex</code> property.
   * @see com.tridium.kitControl.util.BStringIndexOf#afterIndex
   */
  public void setAfterIndex(int v) { setInt(afterIndex,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStringIndexOf.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStringIndexOf()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    getOut().setValue( calculate() );
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == inA || p == inB || p == fromIndex)
    {
      getOut().setValue( calculate() );
    }
  }

  public boolean calculate()
  {
    if(!getInA().getStatus().isValid() || !getInB().getStatus().isValid())
      return getOut().getValue();
    String inA = getInA().getValue();
    String inB = getInB().getValue();

    int index = inA.indexOf(inB, getFromIndex());
    setBeginIndex(index);
    if(index < 0)
      setAfterIndex(index);
    else
      setAfterIndex(index + inB.length());
    return index >=0;
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }


  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  
}
