/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

import com.tridium.kitControl.*;

/**
 * BNumericMask is the base class for Numeric Bit Mask objects.
 *
 * @author    Andy Saunders
 * @creation  20 April 2004
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public abstract class BNumericMask
  extends BKitNumeric
  implements BIStatus, BINumeric
{ 

  /*-
  
  class BNumericMask
  {
    properties
    {
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.make(BFacets.makeNumeric(0), BFacets.make("radix", BInteger.make(16))) ]}
        
      out: BStatusNumeric
        -- The output of a BNumericPoint is a BStatusNumeric
        flags { operator, readonly, transient, summary }
        default {[ new BStatusNumeric() ]}
        
      in: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        slotfacets {[ BFacets.makeNumeric(0) ]}
        
      mask: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        slotfacets {[ BFacets.makeNumeric(0) ]}
        
    }

  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BNumericMask(1401076258)1.0$ @*/
/* Generated Thu Apr 22 10:20:55 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.util.BNumericMask#getFacets
   * @see com.tridium.kitControl.util.BNumericMask#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.make(BFacets.makeNumeric(0), BFacets.make("radix", BInteger.make(16))),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.util.BNumericMask#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.util.BNumericMask#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * The output of a BNumericPoint is a BStatusNumeric
   * @see com.tridium.kitControl.util.BNumericMask#getOut
   * @see com.tridium.kitControl.util.BNumericMask#setOut
   */
  public static final Property out = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BNumericMask#out
   */
  public BStatusNumeric getOut() { return (BStatusNumeric)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BNumericMask#out
   */
  public void setOut(BStatusNumeric v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.util.BNumericMask#getIn
   * @see com.tridium.kitControl.util.BNumericMask#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusNumeric(),BFacets.makeNumeric(0) );
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.util.BNumericMask#in
   */
  public BStatusNumeric getIn() { return (BStatusNumeric)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.util.BNumericMask#in
   */
  public void setIn(BStatusNumeric v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "mask"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>mask</code> property.
   * @see com.tridium.kitControl.util.BNumericMask#getMask
   * @see com.tridium.kitControl.util.BNumericMask#setMask
   */
  public static final Property mask = newProperty(Flags.SUMMARY, new BStatusNumeric(),BFacets.makeNumeric(0) );
  
  /**
   * Get the <code>mask</code> property.
   * @see com.tridium.kitControl.util.BNumericMask#mask
   */
  public BStatusNumeric getMask() { return (BStatusNumeric)get(mask); }
  
  /**
   * Set the <code>mask</code> property.
   * @see com.tridium.kitControl.util.BNumericMask#mask
   */
  public void setMask(BStatusNumeric v) { set(mask,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNumericMask.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////  

  public void started()
  {
    calculate();
  }

  public void changed(Property property, Context context) 
  {
    if(isRunning())
    {
      calculate();
      setStatus();
    }
  }

  public abstract void doCalculate();
  
  /**
   * Default implementation is to do nothing.
   */
  public void calculate()
  {
    doCalculate();
  }

  public void setStatus()
  {
    int statusBits = getIn().getStatus().getBits() | getMask().getStatus().getBits();
    getOut().setStatus(BStatus.make(statusBits & getPropagateFlags().getBits()));
  }

  public BFacets getSlotFacets(Slot slot)
  {
    //if (slot.getName().startsWith("out")) return getFacets();
    if(slot == out || slot == in || slot == mask) return getFacets();
    return super.getSlotFacets(slot);
  }

  public String toString(Context cx) { return getOut().toString(cx); }
////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BINumeric interface
////////////////////////////////////////////////////////////////

  public double getNumeric() { return getOut().getValue(); }

  public final BFacets getNumericFacets() { return getFacets(); }

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////  

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");


}
