/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BNumericBitAnd performs a bit and of the in value and mask value..
 *
 * @author    Andy Saunders
 * @creation  20 April 2004
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public class BNumericBitAnd
  extends BNumericMask
{ 

  /*-
  
  class BNumericBitAnd
  {
    properties
    {
    }

  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BNumericBitAnd(1710098332)1.0$ @*/
/* Generated Tue Apr 20 16:51:08 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNumericBitAnd.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  public void doCalculate()
  {
    if(getIn().getStatus().isValid() && getMask().getStatus().isValid())
    {
      long results = (long)(getIn().getValue()) & (long)(getMask().getValue());
      getOut().setValue((double)results);
    }
  }


////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////  

  /**
   * Get the icon.
  */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/logic/and.png");


}
