/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.log.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BMultiVibrator generates a repeating pulse train
 *
 * @author    Bill Smith
 * @creation  01 Sept 2004
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BMultiVibrator
  extends BBooleanPoint
{  

  /*-
  
  class BMultiVibrator
  {
    properties
    {
      enabled: boolean
        default{[ true ]}
        
      period: BRelTime
        -- Period is the length of time it takes to 
        -- output one complete cycle of the pulse.
        default {[ BRelTime.make(1000) ]}  
        slotfacets {[ BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE,
                                   BFacets.MIN, BRelTime.make(200)) ]}
      
      dutyCycle: int
        -- Percent of period that it is high.
        default {[ 50 ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BInteger.make(0),
                                   BFacets.MAX, BInteger.make(100)) ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BMultiVibrator(2284378471)1.0$ @*/
/* Generated Wed Oct 20 10:34:33 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "enabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>enabled</code> property.
   * @see com.tridium.kitControl.util.BMultiVibrator#getEnabled
   * @see com.tridium.kitControl.util.BMultiVibrator#setEnabled
   */
  public static final Property enabled = newProperty(0, true,null);
  
  /**
   * Get the <code>enabled</code> property.
   * @see com.tridium.kitControl.util.BMultiVibrator#enabled
   */
  public boolean getEnabled() { return getBoolean(enabled); }
  
  /**
   * Set the <code>enabled</code> property.
   * @see com.tridium.kitControl.util.BMultiVibrator#enabled
   */
  public void setEnabled(boolean v) { setBoolean(enabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "period"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>period</code> property.
   * Period is the length of time it takes to output one
   * complete cycle of the pulse.
   * @see com.tridium.kitControl.util.BMultiVibrator#getPeriod
   * @see com.tridium.kitControl.util.BMultiVibrator#setPeriod
   */
  public static final Property period = newProperty(0, BRelTime.make(1000),BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE,
                                   BFacets.MIN, BRelTime.make(200)) );
  
  /**
   * Get the <code>period</code> property.
   * @see com.tridium.kitControl.util.BMultiVibrator#period
   */
  public BRelTime getPeriod() { return (BRelTime)get(period); }
  
  /**
   * Set the <code>period</code> property.
   * @see com.tridium.kitControl.util.BMultiVibrator#period
   */
  public void setPeriod(BRelTime v) { set(period,v,null); }

////////////////////////////////////////////////////////////////
// Property "dutyCycle"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>dutyCycle</code> property.
   * Percent of period that it is high.
   * @see com.tridium.kitControl.util.BMultiVibrator#getDutyCycle
   * @see com.tridium.kitControl.util.BMultiVibrator#setDutyCycle
   */
  public static final Property dutyCycle = newProperty(0, 50,BFacets.make(BFacets.MIN, BInteger.make(0),
                                   BFacets.MAX, BInteger.make(100)) );
  
  /**
   * Get the <code>dutyCycle</code> property.
   * @see com.tridium.kitControl.util.BMultiVibrator#dutyCycle
   */
  public int getDutyCycle() { return getInt(dutyCycle); }
  
  /**
   * Set the <code>dutyCycle</code> property.
   * @see com.tridium.kitControl.util.BMultiVibrator#dutyCycle
   */
  public void setDutyCycle(int v) { setInt(dutyCycle,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BMultiVibrator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Update
////////////////////////////////////////////////////////////////
  
  public void started()
    throws Exception
  {                 
    super.started();
    initTimer();
  }
  
  private synchronized void initTimer()
  {
    int cycle = getDutyCycle();

    if (cycle <= 0)
      cycle = 0;

    if (cycle >= 100)
      cycle = 100;
      
    highTime = getPeriod().getMillis() * cycle / 100;
    lowTime = getPeriod().getMillis() * (100 - cycle) / 100;

    if (ticket != null) 
      ticket.cancel();
    
    if (getEnabled())
    {
      ticket = Clock.schedule(this, BRelTime.make(lowTime), execute, null);
    }
  }
  
  public void changed(Property prop, Context cx)
  {
    super.changed(prop, cx);
    if (prop == period || prop == dutyCycle || prop == enabled) 
    {      
      if (isRunning()) 
        initTimer();
    }    
  }
  
  public synchronized void onExecute(BStatusValue o, Context cx)
  {
    
    if (getEnabled())
    {
      if (highTime <= 0)
      {
        high = false;
      }      
      else if (lowTime <= 0)
      {
        high = true;
      }      
      else
      {
        if (high)
        {
          high = false;
          if (ticket != null) 
            ticket.cancel();
          ticket = Clock.schedule(this, BRelTime.make(lowTime), execute, null);                  
        }
        else
        {
          high = true; 
          if (ticket != null) 
            ticket.cancel();          
          ticket = Clock.schedule(this, BRelTime.make(highTime), execute, null);
        }
      }
 
      // update output
      BStatusBoolean out = (BStatusBoolean)o;
      out.setValue(high);
    }
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/sine.png");
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////  

  private Clock.Ticket ticket = null;
  static final Log log = Log.getLog("kitControl");
  private long start;
  private long highTime;
  private long lowTime;
  private boolean high = false;
}
