/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BEnumSelect uses a numeric to switch between multiple numerics.
 *
 * @author    Andy Saunders
 * @creation  April 05, 2004
 * @version   $Revision: 19$ $Date: 3/30/2004 3:43:05 PM$
 * @since     Baja 1.0
 */
public class BEnumSelect
  extends BMuxSwitch
  implements BIStatus, BIEnum
{

  public static final Property facets = newProperty(0, BFacets.makeEnum());

  /*-
  
  class BEnumSelect
  {
    properties
    {
      out: BStatusEnum
        -- The output of a BNumericPoint is a BStatusEnum
        flags { operator, readonly, transient, summary }
        default {[ new BStatusEnum() ]}
        
      inA: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
      inB: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
      inC: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
      inD: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
      inE: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
      inF: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
      inG: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
      inH: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
      inI: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
      inJ: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BEnumSelect(2624659379)1.0$ @*/
/* Generated Wed Aug 11 09:31:16 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * The output of a BNumericPoint is a BStatusEnum
   * @see com.tridium.kitControl.util.BEnumSelect#getOut
   * @see com.tridium.kitControl.util.BEnumSelect#setOut
   */
  public static final Property out = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#out
   */
  public BStatusEnum getOut() { return (BStatusEnum)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#out
   */
  public void setOut(BStatusEnum v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#getInA
   * @see com.tridium.kitControl.util.BEnumSelect#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inA
   */
  public BStatusEnum getInA() { return (BStatusEnum)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inA
   */
  public void setInA(BStatusEnum v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#getInB
   * @see com.tridium.kitControl.util.BEnumSelect#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inB
   */
  public BStatusEnum getInB() { return (BStatusEnum)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inB
   */
  public void setInB(BStatusEnum v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Property "inC"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#getInC
   * @see com.tridium.kitControl.util.BEnumSelect#setInC
   */
  public static final Property inC = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inC
   */
  public BStatusEnum getInC() { return (BStatusEnum)get(inC); }
  
  /**
   * Set the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inC
   */
  public void setInC(BStatusEnum v) { set(inC,v,null); }

////////////////////////////////////////////////////////////////
// Property "inD"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#getInD
   * @see com.tridium.kitControl.util.BEnumSelect#setInD
   */
  public static final Property inD = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inD
   */
  public BStatusEnum getInD() { return (BStatusEnum)get(inD); }
  
  /**
   * Set the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inD
   */
  public void setInD(BStatusEnum v) { set(inD,v,null); }

////////////////////////////////////////////////////////////////
// Property "inE"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#getInE
   * @see com.tridium.kitControl.util.BEnumSelect#setInE
   */
  public static final Property inE = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inE
   */
  public BStatusEnum getInE() { return (BStatusEnum)get(inE); }
  
  /**
   * Set the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inE
   */
  public void setInE(BStatusEnum v) { set(inE,v,null); }

////////////////////////////////////////////////////////////////
// Property "inF"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#getInF
   * @see com.tridium.kitControl.util.BEnumSelect#setInF
   */
  public static final Property inF = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inF
   */
  public BStatusEnum getInF() { return (BStatusEnum)get(inF); }
  
  /**
   * Set the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inF
   */
  public void setInF(BStatusEnum v) { set(inF,v,null); }

////////////////////////////////////////////////////////////////
// Property "inG"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#getInG
   * @see com.tridium.kitControl.util.BEnumSelect#setInG
   */
  public static final Property inG = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inG
   */
  public BStatusEnum getInG() { return (BStatusEnum)get(inG); }
  
  /**
   * Set the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inG
   */
  public void setInG(BStatusEnum v) { set(inG,v,null); }

////////////////////////////////////////////////////////////////
// Property "inH"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#getInH
   * @see com.tridium.kitControl.util.BEnumSelect#setInH
   */
  public static final Property inH = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inH
   */
  public BStatusEnum getInH() { return (BStatusEnum)get(inH); }
  
  /**
   * Set the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inH
   */
  public void setInH(BStatusEnum v) { set(inH,v,null); }

////////////////////////////////////////////////////////////////
// Property "inI"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#getInI
   * @see com.tridium.kitControl.util.BEnumSelect#setInI
   */
  public static final Property inI = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inI
   */
  public BStatusEnum getInI() { return (BStatusEnum)get(inI); }
  
  /**
   * Set the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inI
   */
  public void setInI(BStatusEnum v) { set(inI,v,null); }

////////////////////////////////////////////////////////////////
// Property "inJ"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#getInJ
   * @see com.tridium.kitControl.util.BEnumSelect#setInJ
   */
  public static final Property inJ = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inJ
   */
  public BStatusEnum getInJ() { return (BStatusEnum)get(inJ); }
  
  /**
   * Set the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BEnumSelect#inJ
   */
  public void setInJ(BStatusEnum v) { set(inJ,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnumSelect.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Interfaces
////////////////////////////////////////////////////////////////

  public BStatusValue getNullInstance()
  {
    return new BStatusEnum();
  }

  public final BStatusValue getInStatusValue(int select)
  {
    switch(select)
    {
    case 1: return getInA();
    case 2: return getInB();
    case 3: return getInC();
    case 4: return getInD();
    case 5: return getInE();
    case 6: return getInF();
    case 7: return getInG();
    case 8: return getInH();
    case 9: return getInI();
    case 10: return getInJ();
    }
    return getNullInstance();
  }
  
  public void setOutput(BStatusValue value)
  {
    setOut((BStatusEnum)value );
  }
  
  public BStatus getOutStatus()
  {
    return getOut().getStatus();
  }
  
  public void setOutStatus(BStatus status)
  {
    getOut().setStatus(status);
  }
  
  public String toString(Context cx) { return getOut().toString(cx); }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  
////////////////////////////////////////////////////////////////
// BIBoolean interface
////////////////////////////////////////////////////////////////

  /**
   * Return the vaule as a enum.
   */
  public final BEnum getEnum() { return getOut().getEnum(); }

  /**
   * Return getFacets().
   */
  public final BFacets getEnumFacets() { return getFacets(); }

  
  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");


}
