/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BDecaInputNumeric is the base class for 10 input numeric objects.
 *   It is a 3 to 10 position switch. 
 *
 * @author    Andy Saunders
 * @creation  20 April 2004
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public abstract class BDecaInputNumeric
  extends BComponent
{ 

  /*-
  
  class BDecaInputNumeric
  {
    properties
    {
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.DEFAULT ]}
        
      numberValues: int
        -- number of inputs
        default {[ 2 ]}
        slotfacets {[ BFacets.makeInt(null, 2, 10) ]}
        
      min: BStatusNumeric
        -- The output of a BNumericPoint is a BStatusNumeric
        flags { operator, readonly, transient, summary }
        default {[ new BStatusNumeric() ]}
        
      max: BStatusNumeric
        -- The output of a BNumericPoint is a BStatusNumeric
        flags { operator, readonly, transient, summary }
        default {[ new BStatusNumeric() ]}
        
      avg: BStatusNumeric
        -- The output of a BNumericPoint is a BStatusNumeric
        flags { operator, readonly, transient, summary }
        default {[ new BStatusNumeric() ]}
        
      inA: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inB: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inC: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inD: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inE: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inF: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inG: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inH: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inI: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inJ: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
    }

  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BDecaInputNumeric(1682198061)1.0$ @*/
/* Generated Tue Apr 20 14:56:47 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getFacets
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.DEFAULT,null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "numberValues"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>numberValues</code> property.
   * number of inputs
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getNumberValues
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setNumberValues
   */
  public static final Property numberValues = newProperty(0, 2,BFacets.makeInt(null, 2, 10) );
  
  /**
   * Get the <code>numberValues</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#numberValues
   */
  public int getNumberValues() { return getInt(numberValues); }
  
  /**
   * Set the <code>numberValues</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#numberValues
   */
  public void setNumberValues(int v) { setInt(numberValues,v,null); }

////////////////////////////////////////////////////////////////
// Property "min"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>min</code> property.
   * The output of a BNumericPoint is a BStatusNumeric
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getMin
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setMin
   */
  public static final Property min = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>min</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#min
   */
  public BStatusNumeric getMin() { return (BStatusNumeric)get(min); }
  
  /**
   * Set the <code>min</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#min
   */
  public void setMin(BStatusNumeric v) { set(min,v,null); }

////////////////////////////////////////////////////////////////
// Property "max"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>max</code> property.
   * The output of a BNumericPoint is a BStatusNumeric
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getMax
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setMax
   */
  public static final Property max = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>max</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#max
   */
  public BStatusNumeric getMax() { return (BStatusNumeric)get(max); }
  
  /**
   * Set the <code>max</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#max
   */
  public void setMax(BStatusNumeric v) { set(max,v,null); }

////////////////////////////////////////////////////////////////
// Property "avg"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>avg</code> property.
   * The output of a BNumericPoint is a BStatusNumeric
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getAvg
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setAvg
   */
  public static final Property avg = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>avg</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#avg
   */
  public BStatusNumeric getAvg() { return (BStatusNumeric)get(avg); }
  
  /**
   * Set the <code>avg</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#avg
   */
  public void setAvg(BStatusNumeric v) { set(avg,v,null); }

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getInA
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inA
   */
  public BStatusNumeric getInA() { return (BStatusNumeric)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inA
   */
  public void setInA(BStatusNumeric v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getInB
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inB
   */
  public BStatusNumeric getInB() { return (BStatusNumeric)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inB
   */
  public void setInB(BStatusNumeric v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Property "inC"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getInC
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setInC
   */
  public static final Property inC = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inC
   */
  public BStatusNumeric getInC() { return (BStatusNumeric)get(inC); }
  
  /**
   * Set the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inC
   */
  public void setInC(BStatusNumeric v) { set(inC,v,null); }

////////////////////////////////////////////////////////////////
// Property "inD"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getInD
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setInD
   */
  public static final Property inD = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inD
   */
  public BStatusNumeric getInD() { return (BStatusNumeric)get(inD); }
  
  /**
   * Set the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inD
   */
  public void setInD(BStatusNumeric v) { set(inD,v,null); }

////////////////////////////////////////////////////////////////
// Property "inE"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getInE
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setInE
   */
  public static final Property inE = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inE
   */
  public BStatusNumeric getInE() { return (BStatusNumeric)get(inE); }
  
  /**
   * Set the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inE
   */
  public void setInE(BStatusNumeric v) { set(inE,v,null); }

////////////////////////////////////////////////////////////////
// Property "inF"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getInF
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setInF
   */
  public static final Property inF = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inF
   */
  public BStatusNumeric getInF() { return (BStatusNumeric)get(inF); }
  
  /**
   * Set the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inF
   */
  public void setInF(BStatusNumeric v) { set(inF,v,null); }

////////////////////////////////////////////////////////////////
// Property "inG"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getInG
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setInG
   */
  public static final Property inG = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inG
   */
  public BStatusNumeric getInG() { return (BStatusNumeric)get(inG); }
  
  /**
   * Set the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inG
   */
  public void setInG(BStatusNumeric v) { set(inG,v,null); }

////////////////////////////////////////////////////////////////
// Property "inH"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getInH
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setInH
   */
  public static final Property inH = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inH
   */
  public BStatusNumeric getInH() { return (BStatusNumeric)get(inH); }
  
  /**
   * Set the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inH
   */
  public void setInH(BStatusNumeric v) { set(inH,v,null); }

////////////////////////////////////////////////////////////////
// Property "inI"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getInI
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setInI
   */
  public static final Property inI = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inI
   */
  public BStatusNumeric getInI() { return (BStatusNumeric)get(inI); }
  
  /**
   * Set the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inI
   */
  public void setInI(BStatusNumeric v) { set(inI,v,null); }

////////////////////////////////////////////////////////////////
// Property "inJ"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#getInJ
   * @see com.tridium.kitControl.util.BDecaInputNumeric#setInJ
   */
  public static final Property inJ = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inJ
   */
  public BStatusNumeric getInJ() { return (BStatusNumeric)get(inJ); }
  
  /**
   * Set the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BDecaInputNumeric#inJ
   */
  public void setInJ(BStatusNumeric v) { set(inJ,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDecaInputNumeric.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////  

  public void started()
  {
    initNumberValues();
    calculate();
  }

  public void changed(Property property, Context context) 
  {
    if(isRunning())
    {
      if(property == numberValues)
      {
        initNumberValues();
        calculate();
      }
      else if(property.getName().startsWith("in") )
      {
        calculate();
      }
    }
  }

  //public abstract BStatusValue getOutStatusValue();
  //public abstract BStatusValue getInStatusValue();
  //public abstract BStatusValue getNullInstance();
  //public abstract BStatusValue getInStatusValue(int select);

  //public abstract void setOutputs(BStatusValue[] values);
  //public abstract void setOutput(BStatusValue value);
  public abstract void doCalculate();
  //public abstract void initNumberValues();

  //public abstract boolean isMuxSwitch();

  /**
   * Default implementation is to do nothing.
   */
  public void calculate()
  {
    doCalculate();
  }


  public void initNumberValues()
  {
    numValues = getNumberValues();
    int setFlags;
    for(int i = 0; i < 10; i++)
    {
      if(i >= numValues)
        setFlags = Flags.HIDDEN | Flags.TRANSIENT;
      else
        setFlags = Flags.SUMMARY;
      switch(i)
      {
      case 0: try {setFlags(getSlot("inA"), setFlags, null);} catch(Exception e) {} break;
      case 1: try {setFlags(getSlot("inB"), setFlags, null);} catch(Exception e) {} break;
      case 2: try {setFlags(getSlot("inC"), setFlags, null);} catch(Exception e) {} break;
      case 3: try {setFlags(getSlot("inD"), setFlags, null);} catch(Exception e) {} break;
      case 4: try {setFlags(getSlot("inE"), setFlags, null);} catch(Exception e) {} break;
      case 5: try {setFlags(getSlot("inF"), setFlags, null);} catch(Exception e) {} break;
      case 6: try {setFlags(getSlot("inG"), setFlags, null);} catch(Exception e) {} break;
      case 7: try {setFlags(getSlot("inH"), setFlags, null);} catch(Exception e) {} break;
      case 8: try {setFlags(getSlot("inI"), setFlags, null);} catch(Exception e) {} break;
      case 9: try {setFlags(getSlot("inJ"), setFlags, null);} catch(Exception e) {} break;
      }
    }
  }

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().startsWith("out")) return getFacets();
    return super.getSlotFacets(slot);
  }

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////  

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");

  int numValues = 2;

}
