/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BBooleanSelect uses a enum value to select 1 of 10 possible boolean inputs
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 19$ $Date: 3/30/2004 3:43:05 PM$
 * @since     Baja 1.0
 */
public class BBooleanSelect
  extends BMuxSwitch
  implements BIStatus, BIBoolean
{  

  public static final Property facets = newProperty(0, BFacets.makeBoolean());

  /*-
  
  class BBooleanSelect
  {
    properties
    {
      out: BStatusBoolean
        -- This property will be set to the input value selected by the Select property.
        flags { operator, readonly, transient, summary }
        default {[ new BStatusBoolean() ]}
        
      inA: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
      inB: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
      inC: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
      inD: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
      inE: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
      inF: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
      inG: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
      inH: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
      inI: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
      inJ: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BBooleanSelect(2118589224)1.0$ @*/
/* Generated Wed Aug 11 09:31:16 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * This property will be set to the input value selected
   * by the Select property.
   * @see com.tridium.kitControl.util.BBooleanSelect#getOut
   * @see com.tridium.kitControl.util.BBooleanSelect#setOut
   */
  public static final Property out = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#out
   */
  public BStatusBoolean getOut() { return (BStatusBoolean)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#out
   */
  public void setOut(BStatusBoolean v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#getInA
   * @see com.tridium.kitControl.util.BBooleanSelect#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inA
   */
  public BStatusBoolean getInA() { return (BStatusBoolean)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inA
   */
  public void setInA(BStatusBoolean v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#getInB
   * @see com.tridium.kitControl.util.BBooleanSelect#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inB
   */
  public BStatusBoolean getInB() { return (BStatusBoolean)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inB
   */
  public void setInB(BStatusBoolean v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Property "inC"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#getInC
   * @see com.tridium.kitControl.util.BBooleanSelect#setInC
   */
  public static final Property inC = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inC
   */
  public BStatusBoolean getInC() { return (BStatusBoolean)get(inC); }
  
  /**
   * Set the <code>inC</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inC
   */
  public void setInC(BStatusBoolean v) { set(inC,v,null); }

////////////////////////////////////////////////////////////////
// Property "inD"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#getInD
   * @see com.tridium.kitControl.util.BBooleanSelect#setInD
   */
  public static final Property inD = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inD
   */
  public BStatusBoolean getInD() { return (BStatusBoolean)get(inD); }
  
  /**
   * Set the <code>inD</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inD
   */
  public void setInD(BStatusBoolean v) { set(inD,v,null); }

////////////////////////////////////////////////////////////////
// Property "inE"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#getInE
   * @see com.tridium.kitControl.util.BBooleanSelect#setInE
   */
  public static final Property inE = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inE
   */
  public BStatusBoolean getInE() { return (BStatusBoolean)get(inE); }
  
  /**
   * Set the <code>inE</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inE
   */
  public void setInE(BStatusBoolean v) { set(inE,v,null); }

////////////////////////////////////////////////////////////////
// Property "inF"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#getInF
   * @see com.tridium.kitControl.util.BBooleanSelect#setInF
   */
  public static final Property inF = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inF
   */
  public BStatusBoolean getInF() { return (BStatusBoolean)get(inF); }
  
  /**
   * Set the <code>inF</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inF
   */
  public void setInF(BStatusBoolean v) { set(inF,v,null); }

////////////////////////////////////////////////////////////////
// Property "inG"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#getInG
   * @see com.tridium.kitControl.util.BBooleanSelect#setInG
   */
  public static final Property inG = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inG
   */
  public BStatusBoolean getInG() { return (BStatusBoolean)get(inG); }
  
  /**
   * Set the <code>inG</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inG
   */
  public void setInG(BStatusBoolean v) { set(inG,v,null); }

////////////////////////////////////////////////////////////////
// Property "inH"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#getInH
   * @see com.tridium.kitControl.util.BBooleanSelect#setInH
   */
  public static final Property inH = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inH
   */
  public BStatusBoolean getInH() { return (BStatusBoolean)get(inH); }
  
  /**
   * Set the <code>inH</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inH
   */
  public void setInH(BStatusBoolean v) { set(inH,v,null); }

////////////////////////////////////////////////////////////////
// Property "inI"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#getInI
   * @see com.tridium.kitControl.util.BBooleanSelect#setInI
   */
  public static final Property inI = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inI
   */
  public BStatusBoolean getInI() { return (BStatusBoolean)get(inI); }
  
  /**
   * Set the <code>inI</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inI
   */
  public void setInI(BStatusBoolean v) { set(inI,v,null); }

////////////////////////////////////////////////////////////////
// Property "inJ"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#getInJ
   * @see com.tridium.kitControl.util.BBooleanSelect#setInJ
   */
  public static final Property inJ = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inJ
   */
  public BStatusBoolean getInJ() { return (BStatusBoolean)get(inJ); }
  
  /**
   * Set the <code>inJ</code> property.
   * @see com.tridium.kitControl.util.BBooleanSelect#inJ
   */
  public void setInJ(BStatusBoolean v) { set(inJ,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBooleanSelect.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Interfaces
////////////////////////////////////////////////////////////////

  public BStatusValue getNullInstance()
  {
    return new BStatusBoolean();
  }

  public final BStatusValue getInStatusValue(int select)
  {
    switch(select)
    {
    case 1: return getInA();
    case 2: return getInB();
    case 3: return getInC();
    case 4: return getInD();
    case 5: return getInE();
    case 6: return getInF();
    case 7: return getInG();
    case 8: return getInH();
    case 9: return getInI();
    case 10: return getInJ();
    }
    return getNullInstance();
  }

  public void setOutput(BStatusValue value)
  {
    setOut((BStatusBoolean)value );
  }
  
  public BStatus getOutStatus()
  {
    return getOut().getStatus();
  }
  
  public void setOutStatus(BStatus status)
  {
    getOut().setStatus(status);
  }


  public String toString(Context cx) { return getOut().toString(cx); }
  
////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BIBoolean interface
////////////////////////////////////////////////////////////////

  public boolean getBoolean() { return getOut().getValue(); }

  public final BFacets getBooleanFacets() { return getFacets(); }

  /**
   * Return the vaule as a enum.
   */
  public final BEnum getEnum() { return getOut().getEnum(); }

  /**
   * Return getFacets().
   */
  public final BFacets getEnumFacets() { return getFacets(); }


  
  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");


}
