/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.util;

import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BBooleanLatch is used to latch a boolean value on the rising edge of the Clock property.
 *
 * @author    Andy Saunders
 * @creation  16 April 2004
 * @version   $Revision: 19$ $Date: 3/30/2004 3:43:05 PM$
 * @since     Baja 1.0
 */
public class BBooleanLatch
  extends BLatch
{  

  public static final Property facets = newProperty(0, BFacets.makeBoolean());

  /*-
  
  class BBooleanLatch
  {
    properties
    {
      out: BStatusBoolean
        flags { operator, readonly, transient, summary }
        default {[ new BStatusBoolean() ]}
        
      in: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.util.BBooleanLatch(704805467)1.0$ @*/
/* Generated Fri Apr 16 16:44:52 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.util.BBooleanLatch#getOut
   * @see com.tridium.kitControl.util.BBooleanLatch#setOut
   */
  public static final Property out = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.util.BBooleanLatch#out
   */
  public BStatusBoolean getOut() { return (BStatusBoolean)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.util.BBooleanLatch#out
   */
  public void setOut(BStatusBoolean v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.util.BBooleanLatch#getIn
   * @see com.tridium.kitControl.util.BBooleanLatch#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.util.BBooleanLatch#in
   */
  public BStatusBoolean getIn() { return (BStatusBoolean)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.util.BBooleanLatch#in
   */
  public void setIn(BStatusBoolean v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBooleanLatch.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Interfaces
////////////////////////////////////////////////////////////////

  /**
   * Get the control output value.
   */
  public final void setOutStatusValue(BStatusValue value) 
  { 
    setOut((BStatusBoolean)value);
  }

  public final BStatusValue getInStatusValue() 
  { 
    return (BStatusValue)(getIn().newCopy());
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/booleanPoint.png");


}
