/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.timer;

import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BOneShot is a component that provides a edge triggered one-shot.
 *    A one-shot converts a boolean input signal to a timed boolean pulse.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BOneShot
  extends BComponent
  implements BIStatus, BIBoolean
{
  /*-

  class BOneShot
  {
    properties
    {

      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeBoolean() ]}

      in: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}

      time: BRelTime
        default {[ BRelTime.make(500l) ]}
        slotfacets {[ MIN=BRelTime.make(1), SHOW_MILLISECONDS = true ]}

      out: BStatusBoolean
        flags { transient, summary, defaultOnClone }
        default {[ new BStatusBoolean(false) ]}

      outNot: BStatusBoolean
        flags { transient, summary, defaultOnClone }
        default {[ new BStatusBoolean(true) ]}

    }

    actions
    {
      fire()

      timerExpired()
        flags { hidden }
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.timer.BOneShot(4059604597)1.0$ @*/
/* Generated Fri Aug 05 15:54:05 EDT 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.timer.BOneShot#getFacets
   * @see com.tridium.kitControl.timer.BOneShot#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeBoolean(),null);

  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }

  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#getIn
   * @see com.tridium.kitControl.timer.BOneShot#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);

  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#in
   */
  public BStatusBoolean getIn() { return (BStatusBoolean)get(in); }

  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#in
   */
  public void setIn(BStatusBoolean v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "time"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>time</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#getTime
   * @see com.tridium.kitControl.timer.BOneShot#setTime
   */
  public static final Property time = newProperty(0, BRelTime.make(500l),BFacets.make(BFacets.make(BFacets.MIN,BRelTime.make(1)),BFacets.make(BFacets.SHOW_MILLISECONDS,true)));

  /**
   * Get the <code>time</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#time
   */
  public BRelTime getTime() { return (BRelTime)get(time); }

  /**
   * Set the <code>time</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#time
   */
  public void setTime(BRelTime v) { set(time,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#getOut
   * @see com.tridium.kitControl.timer.BOneShot#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.SUMMARY|Flags.DEFAULT_ON_CLONE, new BStatusBoolean(false),null);

  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#out
   */
  public BStatusBoolean getOut() { return (BStatusBoolean)get(out); }

  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#out
   */
  public void setOut(BStatusBoolean v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "outNot"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>outNot</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#getOutNot
   * @see com.tridium.kitControl.timer.BOneShot#setOutNot
   */
  public static final Property outNot = newProperty(Flags.TRANSIENT|Flags.SUMMARY|Flags.DEFAULT_ON_CLONE, new BStatusBoolean(true),null);

  /**
   * Get the <code>outNot</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#outNot
   */
  public BStatusBoolean getOutNot() { return (BStatusBoolean)get(outNot); }

  /**
   * Set the <code>outNot</code> property.
   * @see com.tridium.kitControl.timer.BOneShot#outNot
   */
  public void setOutNot(BStatusBoolean v) { set(outNot,v,null); }

////////////////////////////////////////////////////////////////
// Action "fire"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>fire</code> action.
   * @see com.tridium.kitControl.timer.BOneShot#fire()
   */
  public static final Action fire = newAction(0,null);

  /**
   * Invoke the <code>fire</code> action.
   * @see com.tridium.kitControl.timer.BOneShot#fire
   */
  public void fire() { invoke(fire,null,null); }

////////////////////////////////////////////////////////////////
// Action "timerExpired"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>timerExpired</code> action.
   * @see com.tridium.kitControl.timer.BOneShot#timerExpired()
   */
  public static final Action timerExpired = newAction(Flags.HIDDEN,null);

  /**
   * Invoke the <code>timerExpired</code> action.
   * @see com.tridium.kitControl.timer.BOneShot#timerExpired
   */
  public void timerExpired() { invoke(timerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BOneShot.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BOneShot()
  {
  }

  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    //getOut().setValue(getIn().getBoolean());
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == in)
    {
      if(!getIn().getStatus().isValid())
        return;
      boolean input = getIn().getValue();
      if(input && !lastInput)
      {
        lastInput = input;
        getOut().setValue(true);
        getOutNot().setValue(false);
        updateTimer();
      }
      else
        lastInput = input;
    }
  }

  public void doFire()
  {
    getOut().setValue(true);
    getOutNot().setValue(false);
    updateTimer();
  }

  public void doTimerExpired()
  {
    getOut().setValue(false);
    getOutNot().setValue(true);
  }

  void updateTimer()
  {
    if (ticket != null) ticket.cancel();
    ticket = Clock.schedule(this, getTime(), timerExpired, null);
  }


  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BIBoolean interface
////////////////////////////////////////////////////////////////

  public boolean getBoolean() { return getOut().getValue(); }

  public final BFacets getBooleanFacets() { return getFacets(); }

  /**
   * Return the vaule as a enum.
   */
  public final BEnum getEnum() { return getOut().getEnum(); }

  /**
   * Return getFacets().
   */
  public final BFacets getEnumFacets() { return getFacets(); }



  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  boolean lastInput;
  Clock.Ticket ticket;      // Used to manage the current timer

}
