/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.timer;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BNumericDelay is a component that provides numeric delay / filtering for a numeric value.
 *
 * @author    Andy Saunders
 * @creation  14 Sept 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BNumericDelay
  extends BComponent
  implements BIStatus, BINumeric
{
  /*-
  
  class BNumericDelay
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeNumeric() ]}
        
      in: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}

      updateTime: BRelTime
        default {[ BRelTime.make(1000l) ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0)) ]}
        
      maxStepSize: double
        default {[ 0.5d ]}
      
      out: BStatusNumeric
        flags { transient, summary }
        default {[ new BStatusNumeric() ]}
 
    }

    actions
    {
      timerExpired()
        flags { hidden }
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.timer.BNumericDelay(2755624468)1.0$ @*/
/* Generated Tue Feb 10 09:46:16 EST 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.timer.BNumericDelay#getFacets
   * @see com.tridium.kitControl.timer.BNumericDelay#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeNumeric(),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#getIn
   * @see com.tridium.kitControl.timer.BNumericDelay#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#in
   */
  public BStatusNumeric getIn() { return (BStatusNumeric)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#in
   */
  public void setIn(BStatusNumeric v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "updateTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>updateTime</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#getUpdateTime
   * @see com.tridium.kitControl.timer.BNumericDelay#setUpdateTime
   */
  public static final Property updateTime = newProperty(0, BRelTime.make(1000l),BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0)));
  
  /**
   * Get the <code>updateTime</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#updateTime
   */
  public BRelTime getUpdateTime() { return (BRelTime)get(updateTime); }
  
  /**
   * Set the <code>updateTime</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#updateTime
   */
  public void setUpdateTime(BRelTime v) { set(updateTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "maxStepSize"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>maxStepSize</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#getMaxStepSize
   * @see com.tridium.kitControl.timer.BNumericDelay#setMaxStepSize
   */
  public static final Property maxStepSize = newProperty(0, 0.5d,null);
  
  /**
   * Get the <code>maxStepSize</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#maxStepSize
   */
  public double getMaxStepSize() { return getDouble(maxStepSize); }
  
  /**
   * Set the <code>maxStepSize</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#maxStepSize
   */
  public void setMaxStepSize(double v) { setDouble(maxStepSize,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#getOut
   * @see com.tridium.kitControl.timer.BNumericDelay#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#out
   */
  public BStatusNumeric getOut() { return (BStatusNumeric)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.timer.BNumericDelay#out
   */
  public void setOut(BStatusNumeric v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Action "timerExpired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timerExpired</code> action.
   * @see com.tridium.kitControl.timer.BNumericDelay#timerExpired()
   */
  public static final Action timerExpired = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>timerExpired</code> action.
   * @see com.tridium.kitControl.timer.BNumericDelay#timerExpired
   */
  public void timerExpired() { invoke(timerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNumericDelay.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BNumericDelay()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    startTimer();
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;
    if( p == updateTime )
      startTimer();
    else if (p == in)
    {
      if(ticket == null)
        calculate();
    }
  }

  public void calculate()
  {
    if(!getIn().getStatus().isValid())
      return;
    double input = getIn().getValue();
    double output = getOut().getValue();
    double delta = input - output;
    if(input != output)
    {
      if(getUpdateTime().getMillis() == 0l)
      {
        if( ticket != null) ticket.cancel();
        setOutput(input);
      }
      else
      {
        if( (float)Math.abs(delta) > getMaxStepSize() )
        {
          if(input > output)
            setOutput(output + getMaxStepSize() );
          else
            setOutput(output - getMaxStepSize() );
        }
        else
          setOutput(input);
      }
    }
  }

  private void setOutput(double value)
  {
    getOut().setValue(value);
  }

  public void doTimerExpired()
  {
    calculate();
  }


  void startTimer()
  {
    if( ticket != null) ticket.cancel();
    BRelTime time = getUpdateTime();
    if(time.getMillis() != 0l)
      ticket = Clock.schedulePeriodically(this, time, timerExpired, null);
  }    
  

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BINumeric interface
////////////////////////////////////////////////////////////////

  public double getNumeric() { return getOut().getValue(); }

  public final BFacets getNumericFacets() { return getFacets(); }


  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  Clock.Ticket ticket;      // Used to manage the current timer
  
}
