/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.math;

import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;
import javax.baja.util.*;

/**
 * BQuadMath is the superclass of all Baja math objects that
 * operate on up to four input values.
 *
 * @author    Dan Giorgis
 * @creation  8 Nov 00
 * @version   $Revision: 28$ $Date: 3/30/2004 3:42:25 PM$
 * @since     Baja 1.0
 */
public abstract class BQuadMath
  extends BMath
{
  /*-

  class BQuadMath
  {
    properties
    {
      inA: BStatusNumeric
        -- Input A
        flags { summary }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      inB: BStatusNumeric
        -- Input B
        flags { summary }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      inC: BStatusNumeric
        -- Input C
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      inD: BStatusNumeric
        -- Input D
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}

    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.math.BQuadMath(2417644536)1.0$ @*/
/* Generated Thu Feb 14 09:31:33 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * Input A
   * @see com.tridium.kitControl.math.BQuadMath#getInA
   * @see com.tridium.kitControl.math.BQuadMath#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.math.BQuadMath#inA
   */
  public BStatusNumeric getInA() { return (BStatusNumeric)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.math.BQuadMath#inA
   */
  public void setInA(BStatusNumeric v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * Input B
   * @see com.tridium.kitControl.math.BQuadMath#getInB
   * @see com.tridium.kitControl.math.BQuadMath#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.math.BQuadMath#inB
   */
  public BStatusNumeric getInB() { return (BStatusNumeric)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.math.BQuadMath#inB
   */
  public void setInB(BStatusNumeric v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Property "inC"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inC</code> property.
   * Input C
   * @see com.tridium.kitControl.math.BQuadMath#getInC
   * @see com.tridium.kitControl.math.BQuadMath#setInC
   */
  public static final Property inC = newProperty(0, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inC</code> property.
   * @see com.tridium.kitControl.math.BQuadMath#inC
   */
  public BStatusNumeric getInC() { return (BStatusNumeric)get(inC); }
  
  /**
   * Set the <code>inC</code> property.
   * @see com.tridium.kitControl.math.BQuadMath#inC
   */
  public void setInC(BStatusNumeric v) { set(inC,v,null); }

////////////////////////////////////////////////////////////////
// Property "inD"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inD</code> property.
   * Input D
   * @see com.tridium.kitControl.math.BQuadMath#getInD
   * @see com.tridium.kitControl.math.BQuadMath#setInD
   */
  public static final Property inD = newProperty(0, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inD</code> property.
   * @see com.tridium.kitControl.math.BQuadMath#inD
   */
  public BStatusNumeric getInD() { return (BStatusNumeric)get(inD); }
  
  /**
   * Set the <code>inD</code> property.
   * @see com.tridium.kitControl.math.BQuadMath#inD
   */
  public void setInD(BStatusNumeric v) { set(inD,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BQuadMath.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void onExecute(BStatusValue o, Context cx)
  {
    BStatusNumeric inA = getInA();
    BStatusNumeric inB = getInB();
    BStatusNumeric inC = getInC();
    BStatusNumeric inD = getInD();

    BStatus aStatus = inA.getStatus();
    BStatus bStatus = inB.getStatus();
    BStatus cStatus = inC.getStatus();
    BStatus dStatus = inD.getStatus();

    int a = 0; int b = 0; int c = 0; int d = 0;
    a = aStatus.getBits();
    b = bStatus.getBits();
    c = cStatus.getBits();
    d = dStatus.getBits();

    //  Check for less than the minimum number
    //  of non-null inputs.  If null bit
    //  is set, ignore
    int nonNullCount = 0;
    boolean forceNull = false;


    if (aStatus.isValid())
      {  nonNullCount++; }

    if (bStatus.isValid())
      {  nonNullCount++; }

    if (cStatus.isValid())
      {  nonNullCount++; }

    if (dStatus.isValid())
      {  nonNullCount++; }

    if (nonNullCount < minInputs())
      forceNull = true;

    BStatusNumeric out = (BStatusNumeric)o;
    if (forceNull)
    {
      out.setValue(Double.NaN);
      out.setStatus(BStatus.nullStatus);
    }
    else
    {
      out.setValue(calculate(inA,inB,inC,inD));
      out.setStatus(propagate(BStatus.make(a | b | c | d)));
    }
  }


  /**
   * Calculation method.  Only valid elements should be used
   * in the calculation.  If there are not enough valid elements,
   * Double.NaN should be returned
   */
  abstract protected double calculate(BStatusNumeric a,
                                      BStatusNumeric b,
                                      BStatusNumeric c,
                                      BStatusNumeric d);


  /**
   * Return the minimum number of valid inputs needed to
   * generate a valid output
   */
  abstract public int minInputs();

}
