/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.math;

import javax.baja.sys.*;

/**
 * BExponential performs the operation out = e ^ inA 
 * (e raised in the inA power)
 *
 * @author    Dan Giorgis
 * @creation  29 Aug 2001
 * @version   $Revision: 9$ $Date: 3/30/2004 3:41:49 PM$
 * @since     Baja 1.0
 */
public class BExponential
  extends BUnaryMath
{ 
  
  /*-  
  class BExponential
  {
  }  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.math.BExponential(1573372164)1.0$ @*/
/* Generated Fri Jun 04 08:12:09 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BExponential.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  

  protected double calculate(double a)
  {
    return Math.exp(a);
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/math/exponential.png");

}