/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.math;

import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;


/**
 * BBinaryMath is the superclass of all Baja math objects that
 * operate on a pair of input values.  BBinaryMath objects always
 * require two valid inputs.  If either input is null, the output
 * will be Double.NaN and null status.  If either input is invalid
 * but not null, the output will Double.NaN and the logical OR of 
 * the status bits 
 *
 * @author    Dan Giorgis
 * @creation  8 Nov 00
 * @version   $Revision: 27$ $Date: 3/30/2004 3:41:35 PM$
 * @since     Baja 1.0
 */
public abstract class BBinaryMath
  extends BMath
{ 
  /*-
  
  class BBinaryMath
  {
    properties
    {
      inA: BStatusNumeric
        -- Input A
        flags { summary }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}        
      inB: BStatusNumeric
        -- Input B
        flags { summary }
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}

    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.math.BBinaryMath(3170895046)1.0$ @*/
/* Generated Tue May 17 08:39:59 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * Input A
   * @see com.tridium.kitControl.math.BBinaryMath#getInA
   * @see com.tridium.kitControl.math.BBinaryMath#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.math.BBinaryMath#inA
   */
  public BStatusNumeric getInA() { return (BStatusNumeric)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.math.BBinaryMath#inA
   */
  public void setInA(BStatusNumeric v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * Input B
   * @see com.tridium.kitControl.math.BBinaryMath#getInB
   * @see com.tridium.kitControl.math.BBinaryMath#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.math.BBinaryMath#inB
   */
  public BStatusNumeric getInB() { return (BStatusNumeric)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.math.BBinaryMath#inB
   */
  public void setInB(BStatusNumeric v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBinaryMath.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void onExecute(BStatusValue o, Context cx)
  {
    BStatusNumeric inA = getInA();
    BStatusNumeric inB = getInB();

    BStatus sa = inA.getStatus();
    BStatus sb = inB.getStatus();
    
    BStatusNumeric out = (BStatusNumeric)o;

    //  If either input is null, force the output
    //  to null
    if (sa.isNull() || sb.isNull())
    { 
      out.setStatus(BStatus.nullStatus);
      out.setValue(Double.NaN);
    }
    else
    {
      out.setStatus(propagate(BStatus.make(sa.getBits() | sb.getBits())));
  
      //  If either input is invalid, force the output
      //  to NaN
      if (!sa.isValid() || !sb.isValid())        
        out.setValue(Double.NaN);
      else
        out.setValue(calculate(inA.getValue(), inB.getValue()));   
    }
  }  

  abstract protected double calculate(double a, double b);
}
