/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.logic;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;

/**
 * BXor performs a logical XOR on all valid inputs and writes
 * the result to the out property.
 *
 * @author    Dan Giorgis
 * @creation  29 Aug 2001
 * @version   $Revision: 7$ $Date: 3/12/2003 11:45:06 AM$
 * @since     Baja 1.0
 */
public class BXor
  extends BQuadLogic
{ 

  /*-
   class BXor
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.logic.BXor(3992187792)1.0$ @*/
/* Generated Fri Jun 04 08:12:09 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BXor.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/





  protected boolean calculate(BStatusBoolean a, BStatusBoolean b, BStatusBoolean c, BStatusBoolean d)
  {
    boolean result = false;        
    boolean aa,bb,cc,dd;  

    //  Use only valid values.  If an input is invalid, use
    //  false (identity operation for XOR)
    aa = bb = cc = dd = false;    
    if (a.getStatus().isValid()) { aa = a.getValue(); }
    if (b.getStatus().isValid()) { bb = b.getValue(); }
    if (c.getStatus().isValid()) { cc = c.getValue(); }
    if (d.getStatus().isValid()) { dd = d.getValue(); }

    return (aa ^ bb ^ cc ^ dd);
  }

  /**
   * Return the minimum number of valid inputs needed to
   * generate a valid output, which is 2 for an BXor object.
   */
  public int minInputs() { return 2; }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/logic/xor.png");

}
