/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.logic;

import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;

/**
 * BQuad is the superclass of all Baja logic objects that
 * operate on up to four input values. 
 *
 * @author    Dan Giorgis
 * @creation  8 Nov 00
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:18 PM$
 * @since     Baja 1.0
 */
public abstract class BQuadLogic
  extends BLogic
{ 
  /*-
  
  class BQuadLogic
  {
    properties
    {
      inA: BStatusBoolean
        -- Input A
        flags { summary }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      inB: BStatusBoolean
        -- Input B
        flags { summary }
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      inC: BStatusBoolean
        -- Input C
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}
      inD: BStatusBoolean
        -- Input D
        default {[ new BStatusBoolean(false, BStatus.nullStatus) ]}      
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.logic.BQuadLogic(3250278910)1.0$ @*/
/* Generated Fri Jun 04 08:12:09 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "inA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inA</code> property.
   * Input A
   * @see com.tridium.kitControl.logic.BQuadLogic#getInA
   * @see com.tridium.kitControl.logic.BQuadLogic#setInA
   */
  public static final Property inA = newProperty(Flags.SUMMARY, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inA</code> property.
   * @see com.tridium.kitControl.logic.BQuadLogic#inA
   */
  public BStatusBoolean getInA() { return (BStatusBoolean)get(inA); }
  
  /**
   * Set the <code>inA</code> property.
   * @see com.tridium.kitControl.logic.BQuadLogic#inA
   */
  public void setInA(BStatusBoolean v) { set(inA,v,null); }

////////////////////////////////////////////////////////////////
// Property "inB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inB</code> property.
   * Input B
   * @see com.tridium.kitControl.logic.BQuadLogic#getInB
   * @see com.tridium.kitControl.logic.BQuadLogic#setInB
   */
  public static final Property inB = newProperty(Flags.SUMMARY, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inB</code> property.
   * @see com.tridium.kitControl.logic.BQuadLogic#inB
   */
  public BStatusBoolean getInB() { return (BStatusBoolean)get(inB); }
  
  /**
   * Set the <code>inB</code> property.
   * @see com.tridium.kitControl.logic.BQuadLogic#inB
   */
  public void setInB(BStatusBoolean v) { set(inB,v,null); }

////////////////////////////////////////////////////////////////
// Property "inC"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inC</code> property.
   * Input C
   * @see com.tridium.kitControl.logic.BQuadLogic#getInC
   * @see com.tridium.kitControl.logic.BQuadLogic#setInC
   */
  public static final Property inC = newProperty(0, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inC</code> property.
   * @see com.tridium.kitControl.logic.BQuadLogic#inC
   */
  public BStatusBoolean getInC() { return (BStatusBoolean)get(inC); }
  
  /**
   * Set the <code>inC</code> property.
   * @see com.tridium.kitControl.logic.BQuadLogic#inC
   */
  public void setInC(BStatusBoolean v) { set(inC,v,null); }

////////////////////////////////////////////////////////////////
// Property "inD"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inD</code> property.
   * Input D
   * @see com.tridium.kitControl.logic.BQuadLogic#getInD
   * @see com.tridium.kitControl.logic.BQuadLogic#setInD
   */
  public static final Property inD = newProperty(0, new BStatusBoolean(false, BStatus.nullStatus),null);
  
  /**
   * Get the <code>inD</code> property.
   * @see com.tridium.kitControl.logic.BQuadLogic#inD
   */
  public BStatusBoolean getInD() { return (BStatusBoolean)get(inD); }
  
  /**
   * Set the <code>inD</code> property.
   * @see com.tridium.kitControl.logic.BQuadLogic#inD
   */
  public void setInD(BStatusBoolean v) { set(inD,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BQuadLogic.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void onExecute(BStatusValue o, Context cx)
  {
    BStatusBoolean inA = getInA();
    BStatusBoolean inB = getInB();
    BStatusBoolean inC = getInC();
    BStatusBoolean inD = getInD();

    BStatus aStatus = inA.getStatus();
    BStatus bStatus = inB.getStatus();
    BStatus cStatus = inC.getStatus();
    BStatus dStatus = inD.getStatus();

    //  Check for less than the minimum number
    //  of non-null inputs.  If null bit 
    //  is set, ignore 
    int nonNullCount = 0;
    boolean forceNull = false;

    int a = 0; int b = 0; int c = 0; int d = 0;

    if (!aStatus.isNull())
      { a = aStatus.getBits(); nonNullCount++; }

    if (!bStatus.isNull())
      { b = bStatus.getBits(); nonNullCount++; }

    if (!cStatus.isNull())
      { c = cStatus.getBits(); nonNullCount++; }

    if (!dStatus.isNull())
      { d = dStatus.getBits(); nonNullCount++; }

    if (nonNullCount < minInputs())
      forceNull = true; 

    BStatusBoolean out = (BStatusBoolean)o;
    if (forceNull)
    {
      out.setValue(false);
      out.setStatus(BStatus.nullStatus);
    }
    else
    {
      out.setValue(calculate(inA,inB,inC,inD));   
      out.setStatus(propagate(BStatus.make(a | b | c | d)));        
      if(getNullOnInactive() && !(out.getValue()) )
        out.setStatusNull(true);
    }
  }


  /**
   *  Calculation method.  Only valid elements should be used
   * in the calculation.  If there are not enough valid elements,
   * false should be returned
   */
  abstract protected boolean calculate(BStatusBoolean a, 
                                       BStatusBoolean b, 
                                       BStatusBoolean c, 
                                       BStatusBoolean d);

  
  /**
   * Return the minimum number of valid inputs needed to
   * generate a valid output
   */
  abstract public int minInputs();

}
