/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.logic;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;

/**
 * BLogic is the superclass of all Baja objects that
 * perform logical operations on a set of input
 * values.  The result is written to the out element. 
 * <p>
 * By convention, input values with invalid status 
 * (down, fault or null) bit set are ignored (not 
 * used in the logic operation).  However, the 
 * status bits set on the output are the logical 
 * OR of the status bits set on the input, with
 * one exception. If the null bit is set, any
 * other bits (status, in_alarm, etc) are ignored.
 * <p>
 * By default, all 'in' property slots have the null 
 * bit set, therefore unlinked values are ignored. 
 * If all inputs have the null bit set, the output
 * will have the null bit set.  
 * <p>
 * Each logic object requires a minimum number of 
 * inputs. If less than the minimum number of inputs 
 * are non-null, the output will be false and the
 * null bit set.
 * 
 * @author    Dan Giorgis
 * @creation  5 Nov 00
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public abstract class BLogic
  extends BBooleanPoint
{ 
  /*-
  
  class BLogic
  {
    properties
    {
      nullOnInactive: boolean
        -- When set to true, the points out property will be set to null
        -- when result of the logic point is inactive.
        default {[ false ]}
        
      propagateFlags: BStatus
      -- defines which input status flags will be propagated from
      -- input to output.
        default{[ BStatus.ok ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.logic.BLogic(1122450818)1.0$ @*/
/* Generated Tue Aug 03 13:05:13 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "nullOnInactive"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>nullOnInactive</code> property.
   * When set to true, the points out property will be set to null when result of the logic point is inactive.
   * @see com.tridium.kitControl.logic.BLogic#getNullOnInactive
   * @see com.tridium.kitControl.logic.BLogic#setNullOnInactive
   */
  public static final Property nullOnInactive = newProperty(0, false,null);
  
  /**
   * Get the <code>nullOnInactive</code> property.
   * @see com.tridium.kitControl.logic.BLogic#nullOnInactive
   */
  public boolean getNullOnInactive() { return getBoolean(nullOnInactive); }
  
  /**
   * Set the <code>nullOnInactive</code> property.
   * @see com.tridium.kitControl.logic.BLogic#nullOnInactive
   */
  public void setNullOnInactive(boolean v) { setBoolean(nullOnInactive,v,null); }

////////////////////////////////////////////////////////////////
// Property "propagateFlags"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>propagateFlags</code> property.
   * defines which input status flags will be propagated
   * from input to output.
   * @see com.tridium.kitControl.logic.BLogic#getPropagateFlags
   * @see com.tridium.kitControl.logic.BLogic#setPropagateFlags
   */
  public static final Property propagateFlags = newProperty(0, BStatus.ok,null);
  
  /**
   * Get the <code>propagateFlags</code> property.
   * @see com.tridium.kitControl.logic.BLogic#propagateFlags
   */
  public BStatus getPropagateFlags() { return (BStatus)get(propagateFlags); }
  
  /**
   * Set the <code>propagateFlags</code> property.
   * @see com.tridium.kitControl.logic.BLogic#propagateFlags
   */
  public void setPropagateFlags(BStatus v) { set(propagateFlags,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLogic.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  private static final BFacets PROPAGATE_FACETS = 
    BFacets.make(BFacets.FIELD_EDITOR, BString.make("kitControl:PropagateFlagsFE"), BFacets.UX_FIELD_EDITOR, BString.make("kitControl:PropagateFlagsEditor"));

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().equals("propagateFlags"))
    {
      return PROPAGATE_FACETS;
    }
    else return super.getSlotFacets(slot);
  }

  /**
   * Create a new status by masking out only the standard
   * flags which should be propagated from inputs to outputs.
   * See PROPOGATE_MASK for the flags which are propagated.
   *
   * @return <code>make(s.getBits() & PROPOGATE_MASK)</code>
   */
  public BStatus propagate(BStatus s)
  {
    return BStatus.make(s.getBits() & getPropagateFlags().getBits());
  }

}