/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.logic;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;

/**
 * BAnd performs a logical AND on all inputs and writes
 * the result to the out property.
 *
 * @author    Dan Giorgis
 * @creation  6 Nov 00
 * @version   $Revision: 17$ $Date: 3/12/2003 11:44:45 AM$
 * @since     Baja 1.0
 */
public class BAnd
  extends BQuadLogic
{ 

  /*-
   class BAnd
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.logic.BAnd(1407464476)1.0$ @*/
/* Generated Fri Jun 04 08:12:09 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAnd.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/




  protected boolean calculate(BStatusBoolean a, BStatusBoolean b, BStatusBoolean c, BStatusBoolean d)
  {
    boolean result = true;        
    boolean allInvalid = true;
  
    //  Use only valid values
    if (a.getStatus().isValid()) { result &= a.getValue(); allInvalid = false; }
    if (b.getStatus().isValid()) { result &= b.getValue(); allInvalid = false; }
    if (c.getStatus().isValid()) { result &= c.getValue(); allInvalid = false; }
    if (d.getStatus().isValid()) { result &= d.getValue(); allInvalid = false; }

    if (allInvalid)
      return false;
    else
      return result;
  }

  /**
   * Return the minimum number of valid inputs needed to
   * generate a valid output, which is 1 for an BAdd object.
   */
  public int minInputs() { return 1; }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/logic/and.png");

}
