/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.hvac;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;
import com.tridium.kitControl.logic.*;
import com.tridium.kitControl.enums.*;


/**
 * BTstat models a two position thermostat
 * with setpoint and differential inputs. 
 *
 * @author    Andy Saunders
 * @creation  14 Sept 2004
  * @version   $Revision: 29$ $Date: 3/30/2004 3:40:36 PM$
 * @since     Baja 1.0
 */
public class BTstat
  extends BLogic
{ 

  /*-
  
  class BTstat
  {
    properties
    {
      cv: BStatusNumeric
        -- Input Control Variable
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
      sp: BStatusNumeric
        -- Input Setpoint
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
        
      diff: BStatusNumeric
        -- Input Differential
        default {[ new BStatusNumeric(0, BStatus.nullStatus) ]}
        
      action: BLoopAction
        default {[ BLoopAction.direct ]}
      
      nullOnInControl: boolean
        -- Output set to null when in control
        default {[ true ]} 
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.hvac.BTstat(2055813694)1.0$ @*/
/* Generated Fri Nov 30 11:09:42 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "cv"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>cv</code> property.
   * Input Control Variable
   * @see com.tridium.kitControl.hvac.BTstat#getCv
   * @see com.tridium.kitControl.hvac.BTstat#setCv
   */
  public static final Property cv = newProperty(0, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>cv</code> property.
   * @see com.tridium.kitControl.hvac.BTstat#cv
   */
  public BStatusNumeric getCv() { return (BStatusNumeric)get(cv); }
  
  /**
   * Set the <code>cv</code> property.
   * @see com.tridium.kitControl.hvac.BTstat#cv
   */
  public void setCv(BStatusNumeric v) { set(cv,v,null); }

////////////////////////////////////////////////////////////////
// Property "sp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>sp</code> property.
   * Input Setpoint
   * @see com.tridium.kitControl.hvac.BTstat#getSp
   * @see com.tridium.kitControl.hvac.BTstat#setSp
   */
  public static final Property sp = newProperty(0, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>sp</code> property.
   * @see com.tridium.kitControl.hvac.BTstat#sp
   */
  public BStatusNumeric getSp() { return (BStatusNumeric)get(sp); }
  
  /**
   * Set the <code>sp</code> property.
   * @see com.tridium.kitControl.hvac.BTstat#sp
   */
  public void setSp(BStatusNumeric v) { set(sp,v,null); }

////////////////////////////////////////////////////////////////
// Property "diff"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>diff</code> property.
   * Input Differential
   * @see com.tridium.kitControl.hvac.BTstat#getDiff
   * @see com.tridium.kitControl.hvac.BTstat#setDiff
   */
  public static final Property diff = newProperty(0, new BStatusNumeric(0, BStatus.nullStatus),null);
  
  /**
   * Get the <code>diff</code> property.
   * @see com.tridium.kitControl.hvac.BTstat#diff
   */
  public BStatusNumeric getDiff() { return (BStatusNumeric)get(diff); }
  
  /**
   * Set the <code>diff</code> property.
   * @see com.tridium.kitControl.hvac.BTstat#diff
   */
  public void setDiff(BStatusNumeric v) { set(diff,v,null); }

////////////////////////////////////////////////////////////////
// Property "action"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>action</code> property.
   * @see com.tridium.kitControl.hvac.BTstat#getAction
   * @see com.tridium.kitControl.hvac.BTstat#setAction
   */
  public static final Property action = newProperty(0, BLoopAction.direct,null);
  
  /**
   * Get the <code>action</code> property.
   * @see com.tridium.kitControl.hvac.BTstat#action
   */
  public BLoopAction getAction() { return (BLoopAction)get(action); }
  
  /**
   * Set the <code>action</code> property.
   * @see com.tridium.kitControl.hvac.BTstat#action
   */
  public void setAction(BLoopAction v) { set(action,v,null); }

////////////////////////////////////////////////////////////////
// Property "nullOnInControl"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>nullOnInControl</code> property.
   * Output set to null when in control
   * @see com.tridium.kitControl.hvac.BTstat#getNullOnInControl
   * @see com.tridium.kitControl.hvac.BTstat#setNullOnInControl
   */
  public static final Property nullOnInControl = newProperty(0, true,null);
  
  /**
   * Get the <code>nullOnInControl</code> property.
   * @see com.tridium.kitControl.hvac.BTstat#nullOnInControl
   */
  public boolean getNullOnInControl() { return getBoolean(nullOnInControl); }
  
  /**
   * Set the <code>nullOnInControl</code> property.
   * @see com.tridium.kitControl.hvac.BTstat#nullOnInControl
   */
  public void setNullOnInControl(boolean v) { setBoolean(nullOnInControl,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTstat.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public void onExecute(BStatusValue o, Context cx)
  {
    BStatusNumeric controlVariable = getCv();
    BStatusNumeric setpoint = getSp();
    BStatusBoolean out = (BStatusBoolean)o;

    BStatus sa = controlVariable.getStatus();
    BStatus sb = setpoint.getStatus();

    //  If either input is null, force the output
    //  to null
    if (sa.isNull() || sb.isNull())
    { 
      out.setValue(false);
      out.setStatus(BStatus.nullStatus);            
    }
    else
    {
      out.setStatus(propagate(BStatus.make(sa.getBits() | sb.getBits())));
  
      //  If either input is invalid, force the output
      //  to false
      if (!sa.isValid() || !sb.isValid())        
        out.setValue(false);
      else
        out.setValue(calculate());         
      if(getNullOnInactive() && !(out.getValue()) )
        out.setStatusNull(true);
      else if(getNullOnInControl() && inControl)
    	out.setStatusNull(true);
    }    
  }

  protected boolean calculate()
  {
    double halfDiff = (getDiff().getValue()/2.0d);
    double highValue = getSp().getValue() + halfDiff;
    double lowValue = getSp().getValue() - halfDiff;
    boolean returnValue = getOut().getValue();
    if (getAction() != BLoopAction.direct)
      returnValue = !returnValue;
    double currentValue = getCv().getValue();
    if(currentValue >= highValue)
      returnValue = true;
    else if (currentValue <= lowValue) 
      returnValue = false;

    if (getAction() != BLoopAction.direct)
      returnValue = !returnValue;
    inControl = currentValue > lowValue && currentValue < highValue;
    return returnValue;
  }

  boolean inControl = false;
}
