/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.hvac;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;


/**
 * BSequenceBinary is a component that 2 - 10 load binary sequence function.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BSequenceBinary
  extends BSequence
{
  // override delay default value to 0
  public static final Property delay = newProperty(0, BRelTime.make(0l),null);
  /*-
  
  class BSequenceBinary
  {
    properties
    {
      
    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.hvac.BSequenceBinary(2153350133)1.0$ @*/
/* Generated Wed Apr 21 16:37:11 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSequenceBinary.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BSequenceBinary()
  {
  }
  
  public void calculate()
  {
    double maxStages = (int)(Math.pow((double)2, (double)getNumberOutputs())) - 1;
    double maxInValue = getInMaximum();
    double minInValue = getInMinimum();
    double range = maxInValue - minInValue;
    double spDelta = range /  maxStages;
    double cv = getIn().getValue();
    if(cv > maxInValue)
      cv = maxInValue;
    else if( cv < minInValue)
      cv = minInValue;
    int currentStagesOn = numStagesOn;
    if(getIn().getStatus().isValid())
    {
      numStagesOn = (int)((cv-getInMinimum())/spDelta);
      //if(numStagesOn == (int)maxStages)
      //  numStagesOn--;
      if( cv > getInMinimum() && currentStagesOn > numStagesOn )
        numStagesOn++;
    }


    setOutputs(); 
  }

  public void setOutputs()
  {
    if(numStagesOn < 0)
      numStagesOn = 0;
    setDesiredStagesOn(numStagesOn);
    if(numStagesOn == curStagesOn) return;  // don't do anything
    if(numStagesOn > curStagesOn && isDelayProgrammed())
    {
      if(getOnDelayActive() || getOffDelayActive()) // is timer active
        return;          // yes don't do any thing
      curStagesOn++;
      startOnDelayTimer();
    }
    else if(numStagesOn < curStagesOn && isDelayProgrammed())
    {
      if(getOffDelayActive() || getOnDelayActive()) // is timer active
        return;          // yes don't do any thing
      curStagesOn--;
      startOffDelayTimer();
    }
    else
    {
      curStagesOn = numStagesOn;
    }
    getOutA().setValue((curStagesOn &  1) != 0);
    getOutB().setValue((curStagesOn &  2) != 0);
    getOutC().setValue((curStagesOn &  4) != 0);
    getOutD().setValue((curStagesOn &  8) != 0);
    getOutE().setValue((curStagesOn & 16) != 0);
    getOutF().setValue((curStagesOn & 32) != 0);
    getOutG().setValue((curStagesOn & 64) != 0);
    getOutH().setValue((curStagesOn & 128) != 0);
    getOutI().setValue((curStagesOn & 256) != 0);
    getOutJ().setValue((curStagesOn & 512) != 0);
  
    setCurrentStagesOn(curStagesOn);
  
  }


////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
}
