/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.hvac;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;


// this is a work in progress  
/**
 * BSequence is a component that 2 - 10 load sequence function.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public abstract class BSequence
  extends BComponent
{
  /*-
  
  class BSequence
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeBoolean() ]}
        
      in: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      inMinimum: double
        default {[ 0.0d ]}
        
      inMaximum: double
        default {[ 100.0d ]}
        
      numberOutputs: int
        default {[ 3 ]}
        slotfacets {[ BFacets.makeInt(null, 2, 10) ]}   
      
      outA: BStatusBoolean
        flags { transient, summary }
        default {[ new BStatusBoolean() ]}

      outB: BStatusBoolean
        flags { transient, summary }
        default {[ new BStatusBoolean() ]}

      outC: BStatusBoolean
        flags { transient, summary }
        default {[ new BStatusBoolean() ]}

      outD: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}

      outE: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}

      outF: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}

      outG: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}

      outH: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}

      outI: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}

      outJ: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}

      delay: BRelTime
        default {[ BRelTime.make(1000l) ]}
      
      onDelayActive: boolean
        flags { transient, readonly }
        default {[ false ]}
      
      offDelayActive: boolean
        flags { transient, readonly }
        default {[ false ]}
      
      desiredStagesOn: int
        flags { transient, readonly }
        default {[ 0 ]}

      currentStagesOn: int
        flags { transient, readonly }
        default {[ 0 ]}

      nextStageOn: int
        flags { transient, readonly }
        default {[ 0 ]}

      nextStageOff: int
        flags { transient, readonly }
        default {[ 0 ]}
        

    }

    actions
    {
      onDelayTimerExpired()
        flags { hidden, async }
        
      offDelayTimerExpired()
        flags { hidden, async }
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.hvac.BSequence(2830400810)1.0$ @*/
/* Generated Wed Oct 10 13:41:04 EDT 2012 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.hvac.BSequence#getFacets
   * @see com.tridium.kitControl.hvac.BSequence#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeBoolean(),null);
  
  /**
   * Get the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.hvac.BSequence#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.hvac.BSequence#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getIn
   * @see com.tridium.kitControl.hvac.BSequence#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#in
   */
  public BStatusNumeric getIn() { return (BStatusNumeric)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#in
   */
  public void setIn(BStatusNumeric v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "inMinimum"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inMinimum</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getInMinimum
   * @see com.tridium.kitControl.hvac.BSequence#setInMinimum
   */
  public static final Property inMinimum = newProperty(0, 0.0d,null);
  
  /**
   * Get the <code>inMinimum</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#inMinimum
   */
  public double getInMinimum() { return getDouble(inMinimum); }
  
  /**
   * Set the <code>inMinimum</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#inMinimum
   */
  public void setInMinimum(double v) { setDouble(inMinimum,v,null); }

////////////////////////////////////////////////////////////////
// Property "inMaximum"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inMaximum</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getInMaximum
   * @see com.tridium.kitControl.hvac.BSequence#setInMaximum
   */
  public static final Property inMaximum = newProperty(0, 100.0d,null);
  
  /**
   * Get the <code>inMaximum</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#inMaximum
   */
  public double getInMaximum() { return getDouble(inMaximum); }
  
  /**
   * Set the <code>inMaximum</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#inMaximum
   */
  public void setInMaximum(double v) { setDouble(inMaximum,v,null); }

////////////////////////////////////////////////////////////////
// Property "numberOutputs"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>numberOutputs</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getNumberOutputs
   * @see com.tridium.kitControl.hvac.BSequence#setNumberOutputs
   */
  public static final Property numberOutputs = newProperty(0, 3,BFacets.makeInt(null, 2, 10));
  
  /**
   * Get the <code>numberOutputs</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#numberOutputs
   */
  public int getNumberOutputs() { return getInt(numberOutputs); }
  
  /**
   * Set the <code>numberOutputs</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#numberOutputs
   */
  public void setNumberOutputs(int v) { setInt(numberOutputs,v,null); }

////////////////////////////////////////////////////////////////
// Property "outA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outA</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOutA
   * @see com.tridium.kitControl.hvac.BSequence#setOutA
   */
  public static final Property outA = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outA</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outA
   */
  public BStatusBoolean getOutA() { return (BStatusBoolean)get(outA); }
  
  /**
   * Set the <code>outA</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outA
   */
  public void setOutA(BStatusBoolean v) { set(outA,v,null); }

////////////////////////////////////////////////////////////////
// Property "outB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outB</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOutB
   * @see com.tridium.kitControl.hvac.BSequence#setOutB
   */
  public static final Property outB = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outB</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outB
   */
  public BStatusBoolean getOutB() { return (BStatusBoolean)get(outB); }
  
  /**
   * Set the <code>outB</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outB
   */
  public void setOutB(BStatusBoolean v) { set(outB,v,null); }

////////////////////////////////////////////////////////////////
// Property "outC"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outC</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOutC
   * @see com.tridium.kitControl.hvac.BSequence#setOutC
   */
  public static final Property outC = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outC</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outC
   */
  public BStatusBoolean getOutC() { return (BStatusBoolean)get(outC); }
  
  /**
   * Set the <code>outC</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outC
   */
  public void setOutC(BStatusBoolean v) { set(outC,v,null); }

////////////////////////////////////////////////////////////////
// Property "outD"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outD</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOutD
   * @see com.tridium.kitControl.hvac.BSequence#setOutD
   */
  public static final Property outD = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outD</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outD
   */
  public BStatusBoolean getOutD() { return (BStatusBoolean)get(outD); }
  
  /**
   * Set the <code>outD</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outD
   */
  public void setOutD(BStatusBoolean v) { set(outD,v,null); }

////////////////////////////////////////////////////////////////
// Property "outE"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outE</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOutE
   * @see com.tridium.kitControl.hvac.BSequence#setOutE
   */
  public static final Property outE = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outE</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outE
   */
  public BStatusBoolean getOutE() { return (BStatusBoolean)get(outE); }
  
  /**
   * Set the <code>outE</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outE
   */
  public void setOutE(BStatusBoolean v) { set(outE,v,null); }

////////////////////////////////////////////////////////////////
// Property "outF"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outF</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOutF
   * @see com.tridium.kitControl.hvac.BSequence#setOutF
   */
  public static final Property outF = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outF</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outF
   */
  public BStatusBoolean getOutF() { return (BStatusBoolean)get(outF); }
  
  /**
   * Set the <code>outF</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outF
   */
  public void setOutF(BStatusBoolean v) { set(outF,v,null); }

////////////////////////////////////////////////////////////////
// Property "outG"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outG</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOutG
   * @see com.tridium.kitControl.hvac.BSequence#setOutG
   */
  public static final Property outG = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outG</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outG
   */
  public BStatusBoolean getOutG() { return (BStatusBoolean)get(outG); }
  
  /**
   * Set the <code>outG</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outG
   */
  public void setOutG(BStatusBoolean v) { set(outG,v,null); }

////////////////////////////////////////////////////////////////
// Property "outH"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outH</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOutH
   * @see com.tridium.kitControl.hvac.BSequence#setOutH
   */
  public static final Property outH = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outH</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outH
   */
  public BStatusBoolean getOutH() { return (BStatusBoolean)get(outH); }
  
  /**
   * Set the <code>outH</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outH
   */
  public void setOutH(BStatusBoolean v) { set(outH,v,null); }

////////////////////////////////////////////////////////////////
// Property "outI"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outI</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOutI
   * @see com.tridium.kitControl.hvac.BSequence#setOutI
   */
  public static final Property outI = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outI</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outI
   */
  public BStatusBoolean getOutI() { return (BStatusBoolean)get(outI); }
  
  /**
   * Set the <code>outI</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outI
   */
  public void setOutI(BStatusBoolean v) { set(outI,v,null); }

////////////////////////////////////////////////////////////////
// Property "outJ"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outJ</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOutJ
   * @see com.tridium.kitControl.hvac.BSequence#setOutJ
   */
  public static final Property outJ = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outJ</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outJ
   */
  public BStatusBoolean getOutJ() { return (BStatusBoolean)get(outJ); }
  
  /**
   * Set the <code>outJ</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#outJ
   */
  public void setOutJ(BStatusBoolean v) { set(outJ,v,null); }

////////////////////////////////////////////////////////////////
// Property "delay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>delay</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getDelay
   * @see com.tridium.kitControl.hvac.BSequence#setDelay
   */
  public static final Property delay = newProperty(0, BRelTime.make(1000l),null);
  
  /**
   * Get the <code>delay</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#delay
   */
  public BRelTime getDelay() { return (BRelTime)get(delay); }
  
  /**
   * Set the <code>delay</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#delay
   */
  public void setDelay(BRelTime v) { set(delay,v,null); }

////////////////////////////////////////////////////////////////
// Property "onDelayActive"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onDelayActive</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOnDelayActive
   * @see com.tridium.kitControl.hvac.BSequence#setOnDelayActive
   */
  public static final Property onDelayActive = newProperty(Flags.TRANSIENT|Flags.READONLY, false,null);
  
  /**
   * Get the <code>onDelayActive</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#onDelayActive
   */
  public boolean getOnDelayActive() { return getBoolean(onDelayActive); }
  
  /**
   * Set the <code>onDelayActive</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#onDelayActive
   */
  public void setOnDelayActive(boolean v) { setBoolean(onDelayActive,v,null); }

////////////////////////////////////////////////////////////////
// Property "offDelayActive"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>offDelayActive</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getOffDelayActive
   * @see com.tridium.kitControl.hvac.BSequence#setOffDelayActive
   */
  public static final Property offDelayActive = newProperty(Flags.TRANSIENT|Flags.READONLY, false,null);
  
  /**
   * Get the <code>offDelayActive</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#offDelayActive
   */
  public boolean getOffDelayActive() { return getBoolean(offDelayActive); }
  
  /**
   * Set the <code>offDelayActive</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#offDelayActive
   */
  public void setOffDelayActive(boolean v) { setBoolean(offDelayActive,v,null); }

////////////////////////////////////////////////////////////////
// Property "desiredStagesOn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>desiredStagesOn</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getDesiredStagesOn
   * @see com.tridium.kitControl.hvac.BSequence#setDesiredStagesOn
   */
  public static final Property desiredStagesOn = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>desiredStagesOn</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#desiredStagesOn
   */
  public int getDesiredStagesOn() { return getInt(desiredStagesOn); }
  
  /**
   * Set the <code>desiredStagesOn</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#desiredStagesOn
   */
  public void setDesiredStagesOn(int v) { setInt(desiredStagesOn,v,null); }

////////////////////////////////////////////////////////////////
// Property "currentStagesOn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>currentStagesOn</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getCurrentStagesOn
   * @see com.tridium.kitControl.hvac.BSequence#setCurrentStagesOn
   */
  public static final Property currentStagesOn = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>currentStagesOn</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#currentStagesOn
   */
  public int getCurrentStagesOn() { return getInt(currentStagesOn); }
  
  /**
   * Set the <code>currentStagesOn</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#currentStagesOn
   */
  public void setCurrentStagesOn(int v) { setInt(currentStagesOn,v,null); }

////////////////////////////////////////////////////////////////
// Property "nextStageOn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>nextStageOn</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getNextStageOn
   * @see com.tridium.kitControl.hvac.BSequence#setNextStageOn
   */
  public static final Property nextStageOn = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>nextStageOn</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#nextStageOn
   */
  public int getNextStageOn() { return getInt(nextStageOn); }
  
  /**
   * Set the <code>nextStageOn</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#nextStageOn
   */
  public void setNextStageOn(int v) { setInt(nextStageOn,v,null); }

////////////////////////////////////////////////////////////////
// Property "nextStageOff"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>nextStageOff</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#getNextStageOff
   * @see com.tridium.kitControl.hvac.BSequence#setNextStageOff
   */
  public static final Property nextStageOff = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>nextStageOff</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#nextStageOff
   */
  public int getNextStageOff() { return getInt(nextStageOff); }
  
  /**
   * Set the <code>nextStageOff</code> property.
   * @see com.tridium.kitControl.hvac.BSequence#nextStageOff
   */
  public void setNextStageOff(int v) { setInt(nextStageOff,v,null); }

////////////////////////////////////////////////////////////////
// Action "onDelayTimerExpired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onDelayTimerExpired</code> action.
   * @see com.tridium.kitControl.hvac.BSequence#onDelayTimerExpired()
   */
  public static final Action onDelayTimerExpired = newAction(Flags.HIDDEN|Flags.ASYNC,null);
  
  /**
   * Invoke the <code>onDelayTimerExpired</code> action.
   * @see com.tridium.kitControl.hvac.BSequence#onDelayTimerExpired
   */
  public void onDelayTimerExpired() { invoke(onDelayTimerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Action "offDelayTimerExpired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>offDelayTimerExpired</code> action.
   * @see com.tridium.kitControl.hvac.BSequence#offDelayTimerExpired()
   */
  public static final Action offDelayTimerExpired = newAction(Flags.HIDDEN|Flags.ASYNC,null);
  
  /**
   * Invoke the <code>offDelayTimerExpired</code> action.
   * @see com.tridium.kitControl.hvac.BSequence#offDelayTimerExpired
   */
  public void offDelayTimerExpired() { invoke(offDelayTimerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSequence.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BSequence()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    initNumberOutputs();
    numStagesOn = 0;
    curStagesOn = 0;
    setDesiredStagesOn(0);
    setCurrentStagesOn(0);
    nxtStageOn = 1;
    nxtStageOff = 0;
    setNextStageOn(1);
    setNextStageOff(0);
    setOutputsOff();
    calculate();
    setOutputs();
  }

  public void reinitialize()
  {
    if (offTicket != null) offTicket.cancel();
    if (onTicket != null) onTicket.cancel();
    setOnDelayActive(false);
    setOffDelayActive(false);
    started();

  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if(p == numberOutputs)
    {
      initNumberOutputs();
    }
    else if(p == in /*|| p == offDelayActive || p == onDelayActive */ )
    {
      calculate();
      setOutputs(); 
    }
  }

  public void initNumberOutputs()
  {
    numOutputs = getNumberOutputs();
    int setFlags;
    for(int i = 0; i < 10; i++)
    {
      if(i >= numOutputs)
        setFlags = Flags.HIDDEN | Flags.TRANSIENT;
      else
        setFlags = Flags.SUMMARY | Flags.TRANSIENT;
      switch(i)
      {
      case 0: initSlot("outA", setFlags | Flags.READONLY); break;
      case 1: initSlot("outB", setFlags | Flags.READONLY); break;
      case 2: initSlot("outC", setFlags | Flags.READONLY); break;
      case 3: initSlot("outD", setFlags | Flags.READONLY); break;
      case 4: initSlot("outE", setFlags | Flags.READONLY); break;
      case 5: initSlot("outF", setFlags | Flags.READONLY); break;
      case 6: initSlot("outG", setFlags | Flags.READONLY); break;
      case 7: initSlot("outH", setFlags | Flags.READONLY); break;
      case 8: initSlot("outI", setFlags | Flags.READONLY); break;
      case 9: initSlot("outJ", setFlags | Flags.READONLY); break;
      }
    }
  }

  void initSlot(String slot, int flags)
  {
      try { setFlags(getSlot(slot), flags, null);} catch(Exception e) {};
  }


  public void doOnDelayTimerExpired()
  {
    //setOutput(true);
    setOnDelayActive(false);
    calculate();
    setOutputs();
  }

  public void doOffDelayTimerExpired()
  {
    //setOutput(false);
    setOffDelayActive(false);
    calculate();
    setOutputs();
  }

  public abstract void calculate();
  
  public abstract void setOutputs();
  
  public BStatusBoolean getStatusOutput(int index)
  {
    if(index < 1) return getOutA();
    switch(index)
    {
    case 1: return getOutA();
    case 2: return getOutB();
    case 3: return getOutC();
    case 4: return getOutD();
    case 5: return getOutE();
    case 6: return getOutF();
    case 7: return getOutG();
    case 8: return getOutH();
    case 9: return getOutI();
    case 10: return getOutJ();
    }
    return getOutJ();
  }

  public void setOutputsOff()
  {
    for(int i = 1; i<= getNumberOutputs(); i++)
    {
      try {getStatusOutput(i).setValue(false);} catch(Exception e){}
    }
  }

  public boolean isDelayProgrammed()
  {
    return(getDelay().getMillis() != 0);
  }
  
  public void startOnDelayTimer()
  {            
    if(offTicket != null)
    {
      offTicket.cancel();
      setOffDelayActive(false);
    }
    if (onTicket != null)
    {  
      onTicket.cancel();
    }
    onTicket = Clock.schedule(this, getDelay(), onDelayTimerExpired, null);
    setOnDelayActive(true);
  }    
  
  public void startOffDelayTimer()
  {
    if(onTicket != null)
    {
      onTicket.cancel();
      setOnDelayActive(false);
    }
    if (offTicket != null)
    {
      offTicket.cancel();
    }
    offTicket = Clock.schedule(this, getDelay(), offDelayTimerExpired, null);
    setOffDelayActive(true);
  }    
  

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().startsWith("out")) return getFacets();
    return super.getSlotFacets(slot);
  }


  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  int numStagesOn;
  int curStagesOn;
  int nxtStageOn = 1;
  int nxtStageOff = 0;
  int numOutputs;
  int startStage = 1;
  boolean wasEqual = false;

  Clock.Ticket onTicket;    // Used to manage the on delay timer
  Clock.Ticket offTicket;   // Used to manage the off delay timer
  

}
