/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.hvac;

import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 * BLeadLagRuntime is a component that can provide lead/lag control of 2 - 10 loads 
 * to balance start cycles.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BLeadLagRuntime
  extends BComponent
{
  /*-
  
  class BLeadLagRuntime
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeBoolean() ]}
        
      in: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
      numberOutputs: int
        default {[ 2 ]}
        slotfacets {[ BFacets.makeInt(null, 2, 10) ]}   
      
      maxRuntime: BRelTime
        default {[ BRelTime.make(360000l) ]}
      
      feedback: BStatusBoolean
        flags { transient, summary }
        default {[ new BStatusBoolean() ]}
      
      feedbackDelay: BRelTime
        default {[ BRelTime.make(5000l) ]}

      clearAlarmTime: BRelTime
        default {[ BRelTime.makeHours(1) ]}

      outA: BStatusBoolean
        flags { transient, summary }
        default {[ new BStatusBoolean() ]}

      outB: BStatusBoolean
        flags { transient, summary }
        default {[ new BStatusBoolean() ]}

      outC: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}
    
      outD: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}
    
      outE: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}
    
      outF: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}
    
      outG: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}
    
      outH: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}
    
      outI: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}
    
      outJ: BStatusBoolean
        flags { transient }
        default {[ new BStatusBoolean() ]}
    
      runtimeA: BRelTime
        flags { transient, summary }
        default {[ BRelTime.make(0) ]}

      runtimeB: BRelTime
        flags { transient, summary }
        default {[ BRelTime.make(0) ]}

      runtimeC: BRelTime
        flags { transient }
        default {[ BRelTime.make(0) ]}

      runtimeD: BRelTime
        flags { transient }
        default {[ BRelTime.make(0) ]}

      runtimeE: BRelTime
        flags { transient }
        default {[ BRelTime.make(0) ]}

      runtimeF: BRelTime
        flags { transient }
        default {[ BRelTime.make(0) ]}

      runtimeG: BRelTime
        flags { transient }
        default {[ BRelTime.make(0) ]}

      runtimeH: BRelTime
        flags { transient }
        default {[ BRelTime.make(0) ]}

      runtimeI: BRelTime
        flags { transient }
        default {[ BRelTime.make(0) ]}

      runtimeJ: BRelTime
        flags { transient }
        default {[ BRelTime.make(0) ]}

    }

    actions
    {
      rotateTimerExpired()
        flags { hidden }
      
      feedbackTimerExpired()
        flags { hidden }
        
      clearAlarmState()
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.hvac.BLeadLagRuntime(1953040836)1.0$ @*/
/* Generated Mon May 12 14:55:46 EDT 2014 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getFacets
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeBoolean(),null);
  
  /**
   * Get the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getIn
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setIn
   */
  public static final Property in = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#in
   */
  public BStatusBoolean getIn() { return (BStatusBoolean)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#in
   */
  public void setIn(BStatusBoolean v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "numberOutputs"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>numberOutputs</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getNumberOutputs
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setNumberOutputs
   */
  public static final Property numberOutputs = newProperty(0, 2,BFacets.makeInt(null, 2, 10));
  
  /**
   * Get the <code>numberOutputs</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#numberOutputs
   */
  public int getNumberOutputs() { return getInt(numberOutputs); }
  
  /**
   * Set the <code>numberOutputs</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#numberOutputs
   */
  public void setNumberOutputs(int v) { setInt(numberOutputs,v,null); }

////////////////////////////////////////////////////////////////
// Property "maxRuntime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>maxRuntime</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getMaxRuntime
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setMaxRuntime
   */
  public static final Property maxRuntime = newProperty(0, BRelTime.make(360000l),null);
  
  /**
   * Get the <code>maxRuntime</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#maxRuntime
   */
  public BRelTime getMaxRuntime() { return (BRelTime)get(maxRuntime); }
  
  /**
   * Set the <code>maxRuntime</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#maxRuntime
   */
  public void setMaxRuntime(BRelTime v) { set(maxRuntime,v,null); }

////////////////////////////////////////////////////////////////
// Property "feedback"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>feedback</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getFeedback
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setFeedback
   */
  public static final Property feedback = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>feedback</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#feedback
   */
  public BStatusBoolean getFeedback() { return (BStatusBoolean)get(feedback); }
  
  /**
   * Set the <code>feedback</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#feedback
   */
  public void setFeedback(BStatusBoolean v) { set(feedback,v,null); }

////////////////////////////////////////////////////////////////
// Property "feedbackDelay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>feedbackDelay</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getFeedbackDelay
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setFeedbackDelay
   */
  public static final Property feedbackDelay = newProperty(0, BRelTime.make(5000l),null);
  
  /**
   * Get the <code>feedbackDelay</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#feedbackDelay
   */
  public BRelTime getFeedbackDelay() { return (BRelTime)get(feedbackDelay); }
  
  /**
   * Set the <code>feedbackDelay</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#feedbackDelay
   */
  public void setFeedbackDelay(BRelTime v) { set(feedbackDelay,v,null); }

////////////////////////////////////////////////////////////////
// Property "clearAlarmTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>clearAlarmTime</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getClearAlarmTime
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setClearAlarmTime
   */
  public static final Property clearAlarmTime = newProperty(0, BRelTime.makeHours(1),null);
  
  /**
   * Get the <code>clearAlarmTime</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#clearAlarmTime
   */
  public BRelTime getClearAlarmTime() { return (BRelTime)get(clearAlarmTime); }
  
  /**
   * Set the <code>clearAlarmTime</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#clearAlarmTime
   */
  public void setClearAlarmTime(BRelTime v) { set(clearAlarmTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "outA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outA</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getOutA
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setOutA
   */
  public static final Property outA = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outA</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outA
   */
  public BStatusBoolean getOutA() { return (BStatusBoolean)get(outA); }
  
  /**
   * Set the <code>outA</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outA
   */
  public void setOutA(BStatusBoolean v) { set(outA,v,null); }

////////////////////////////////////////////////////////////////
// Property "outB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outB</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getOutB
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setOutB
   */
  public static final Property outB = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outB</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outB
   */
  public BStatusBoolean getOutB() { return (BStatusBoolean)get(outB); }
  
  /**
   * Set the <code>outB</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outB
   */
  public void setOutB(BStatusBoolean v) { set(outB,v,null); }

////////////////////////////////////////////////////////////////
// Property "outC"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outC</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getOutC
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setOutC
   */
  public static final Property outC = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outC</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outC
   */
  public BStatusBoolean getOutC() { return (BStatusBoolean)get(outC); }
  
  /**
   * Set the <code>outC</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outC
   */
  public void setOutC(BStatusBoolean v) { set(outC,v,null); }

////////////////////////////////////////////////////////////////
// Property "outD"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outD</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getOutD
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setOutD
   */
  public static final Property outD = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outD</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outD
   */
  public BStatusBoolean getOutD() { return (BStatusBoolean)get(outD); }
  
  /**
   * Set the <code>outD</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outD
   */
  public void setOutD(BStatusBoolean v) { set(outD,v,null); }

////////////////////////////////////////////////////////////////
// Property "outE"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outE</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getOutE
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setOutE
   */
  public static final Property outE = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outE</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outE
   */
  public BStatusBoolean getOutE() { return (BStatusBoolean)get(outE); }
  
  /**
   * Set the <code>outE</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outE
   */
  public void setOutE(BStatusBoolean v) { set(outE,v,null); }

////////////////////////////////////////////////////////////////
// Property "outF"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outF</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getOutF
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setOutF
   */
  public static final Property outF = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outF</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outF
   */
  public BStatusBoolean getOutF() { return (BStatusBoolean)get(outF); }
  
  /**
   * Set the <code>outF</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outF
   */
  public void setOutF(BStatusBoolean v) { set(outF,v,null); }

////////////////////////////////////////////////////////////////
// Property "outG"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outG</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getOutG
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setOutG
   */
  public static final Property outG = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outG</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outG
   */
  public BStatusBoolean getOutG() { return (BStatusBoolean)get(outG); }
  
  /**
   * Set the <code>outG</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outG
   */
  public void setOutG(BStatusBoolean v) { set(outG,v,null); }

////////////////////////////////////////////////////////////////
// Property "outH"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outH</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getOutH
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setOutH
   */
  public static final Property outH = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outH</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outH
   */
  public BStatusBoolean getOutH() { return (BStatusBoolean)get(outH); }
  
  /**
   * Set the <code>outH</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outH
   */
  public void setOutH(BStatusBoolean v) { set(outH,v,null); }

////////////////////////////////////////////////////////////////
// Property "outI"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outI</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getOutI
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setOutI
   */
  public static final Property outI = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outI</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outI
   */
  public BStatusBoolean getOutI() { return (BStatusBoolean)get(outI); }
  
  /**
   * Set the <code>outI</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outI
   */
  public void setOutI(BStatusBoolean v) { set(outI,v,null); }

////////////////////////////////////////////////////////////////
// Property "outJ"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outJ</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getOutJ
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setOutJ
   */
  public static final Property outJ = newProperty(Flags.TRANSIENT, new BStatusBoolean(),null);
  
  /**
   * Get the <code>outJ</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outJ
   */
  public BStatusBoolean getOutJ() { return (BStatusBoolean)get(outJ); }
  
  /**
   * Set the <code>outJ</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#outJ
   */
  public void setOutJ(BStatusBoolean v) { set(outJ,v,null); }

////////////////////////////////////////////////////////////////
// Property "runtimeA"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>runtimeA</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getRuntimeA
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setRuntimeA
   */
  public static final Property runtimeA = newProperty(Flags.TRANSIENT|Flags.SUMMARY, BRelTime.make(0),null);
  
  /**
   * Get the <code>runtimeA</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeA
   */
  public BRelTime getRuntimeA() { return (BRelTime)get(runtimeA); }
  
  /**
   * Set the <code>runtimeA</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeA
   */
  public void setRuntimeA(BRelTime v) { set(runtimeA,v,null); }

////////////////////////////////////////////////////////////////
// Property "runtimeB"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>runtimeB</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getRuntimeB
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setRuntimeB
   */
  public static final Property runtimeB = newProperty(Flags.TRANSIENT|Flags.SUMMARY, BRelTime.make(0),null);
  
  /**
   * Get the <code>runtimeB</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeB
   */
  public BRelTime getRuntimeB() { return (BRelTime)get(runtimeB); }
  
  /**
   * Set the <code>runtimeB</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeB
   */
  public void setRuntimeB(BRelTime v) { set(runtimeB,v,null); }

////////////////////////////////////////////////////////////////
// Property "runtimeC"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>runtimeC</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getRuntimeC
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setRuntimeC
   */
  public static final Property runtimeC = newProperty(Flags.TRANSIENT, BRelTime.make(0),null);
  
  /**
   * Get the <code>runtimeC</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeC
   */
  public BRelTime getRuntimeC() { return (BRelTime)get(runtimeC); }
  
  /**
   * Set the <code>runtimeC</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeC
   */
  public void setRuntimeC(BRelTime v) { set(runtimeC,v,null); }

////////////////////////////////////////////////////////////////
// Property "runtimeD"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>runtimeD</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getRuntimeD
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setRuntimeD
   */
  public static final Property runtimeD = newProperty(Flags.TRANSIENT, BRelTime.make(0),null);
  
  /**
   * Get the <code>runtimeD</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeD
   */
  public BRelTime getRuntimeD() { return (BRelTime)get(runtimeD); }
  
  /**
   * Set the <code>runtimeD</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeD
   */
  public void setRuntimeD(BRelTime v) { set(runtimeD,v,null); }

////////////////////////////////////////////////////////////////
// Property "runtimeE"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>runtimeE</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getRuntimeE
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setRuntimeE
   */
  public static final Property runtimeE = newProperty(Flags.TRANSIENT, BRelTime.make(0),null);
  
  /**
   * Get the <code>runtimeE</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeE
   */
  public BRelTime getRuntimeE() { return (BRelTime)get(runtimeE); }
  
  /**
   * Set the <code>runtimeE</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeE
   */
  public void setRuntimeE(BRelTime v) { set(runtimeE,v,null); }

////////////////////////////////////////////////////////////////
// Property "runtimeF"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>runtimeF</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getRuntimeF
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setRuntimeF
   */
  public static final Property runtimeF = newProperty(Flags.TRANSIENT, BRelTime.make(0),null);
  
  /**
   * Get the <code>runtimeF</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeF
   */
  public BRelTime getRuntimeF() { return (BRelTime)get(runtimeF); }
  
  /**
   * Set the <code>runtimeF</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeF
   */
  public void setRuntimeF(BRelTime v) { set(runtimeF,v,null); }

////////////////////////////////////////////////////////////////
// Property "runtimeG"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>runtimeG</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getRuntimeG
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setRuntimeG
   */
  public static final Property runtimeG = newProperty(Flags.TRANSIENT, BRelTime.make(0),null);
  
  /**
   * Get the <code>runtimeG</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeG
   */
  public BRelTime getRuntimeG() { return (BRelTime)get(runtimeG); }
  
  /**
   * Set the <code>runtimeG</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeG
   */
  public void setRuntimeG(BRelTime v) { set(runtimeG,v,null); }

////////////////////////////////////////////////////////////////
// Property "runtimeH"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>runtimeH</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getRuntimeH
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setRuntimeH
   */
  public static final Property runtimeH = newProperty(Flags.TRANSIENT, BRelTime.make(0),null);
  
  /**
   * Get the <code>runtimeH</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeH
   */
  public BRelTime getRuntimeH() { return (BRelTime)get(runtimeH); }
  
  /**
   * Set the <code>runtimeH</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeH
   */
  public void setRuntimeH(BRelTime v) { set(runtimeH,v,null); }

////////////////////////////////////////////////////////////////
// Property "runtimeI"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>runtimeI</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getRuntimeI
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setRuntimeI
   */
  public static final Property runtimeI = newProperty(Flags.TRANSIENT, BRelTime.make(0),null);
  
  /**
   * Get the <code>runtimeI</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeI
   */
  public BRelTime getRuntimeI() { return (BRelTime)get(runtimeI); }
  
  /**
   * Set the <code>runtimeI</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeI
   */
  public void setRuntimeI(BRelTime v) { set(runtimeI,v,null); }

////////////////////////////////////////////////////////////////
// Property "runtimeJ"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>runtimeJ</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#getRuntimeJ
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#setRuntimeJ
   */
  public static final Property runtimeJ = newProperty(Flags.TRANSIENT, BRelTime.make(0),null);
  
  /**
   * Get the <code>runtimeJ</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeJ
   */
  public BRelTime getRuntimeJ() { return (BRelTime)get(runtimeJ); }
  
  /**
   * Set the <code>runtimeJ</code> property.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#runtimeJ
   */
  public void setRuntimeJ(BRelTime v) { set(runtimeJ,v,null); }

////////////////////////////////////////////////////////////////
// Action "rotateTimerExpired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>rotateTimerExpired</code> action.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#rotateTimerExpired()
   */
  public static final Action rotateTimerExpired = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>rotateTimerExpired</code> action.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#rotateTimerExpired
   */
  public void rotateTimerExpired() { invoke(rotateTimerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Action "feedbackTimerExpired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>feedbackTimerExpired</code> action.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#feedbackTimerExpired()
   */
  public static final Action feedbackTimerExpired = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>feedbackTimerExpired</code> action.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#feedbackTimerExpired
   */
  public void feedbackTimerExpired() { invoke(feedbackTimerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Action "clearAlarmState"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>clearAlarmState</code> action.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#clearAlarmState()
   */
  public static final Action clearAlarmState = newAction(0,null);
  
  /**
   * Invoke the <code>clearAlarmState</code> action.
   * @see com.tridium.kitControl.hvac.BLeadLagRuntime#clearAlarmState
   */
  public void clearAlarmState() { invoke(clearAlarmState,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLeadLagRuntime.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BLeadLagRuntime()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    initNumberOutputs();
  }
  
  public void atSteadyState()
  {
    currentIn = getIn().getValue();
    calculate();
  }
/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if(p == numberOutputs)
    {
      initNumberOutputs();
    }

    if (!isRunning()) return;

    if(p == in) 
    {
      currentIn = getIn().getValue();
      calculate();
    }
    else if(p == feedback)
    {
      if(!currentIn) return;
      if(getFeedback().getValue()) return;
      if(feedbackTimerActive) return;
      setCurrentOutputAlarm(true);
      getRuntimes();  // load current cycle counts.
      startOutput();
    }
  }

  public void initNumberOutputs()
  {
    numOutputs = getNumberOutputs();
    int setFlags;
    for(int i = 0; i < 10; i++)
    {
      if(i >= numOutputs)
        setFlags = Flags.HIDDEN | Flags.TRANSIENT;
      else
        setFlags = Flags.SUMMARY | Flags.TRANSIENT;
      switch(i)
      {
      case 0: initSlot("outA", setFlags | Flags.READONLY); initSlot("runtimeA", setFlags); break;
      case 1: initSlot("outB", setFlags | Flags.READONLY); initSlot("runtimeB", setFlags); break;
      case 2: initSlot("outC", setFlags | Flags.READONLY); initSlot("runtimeC", setFlags); break;
      case 3: initSlot("outD", setFlags | Flags.READONLY); initSlot("runtimeD", setFlags); break;
      case 4: initSlot("outE", setFlags | Flags.READONLY); initSlot("runtimeE", setFlags); break;
      case 5: initSlot("outF", setFlags | Flags.READONLY); initSlot("runtimeF", setFlags); break;
      case 6: initSlot("outG", setFlags | Flags.READONLY); initSlot("runtimeG", setFlags); break;
      case 7: initSlot("outH", setFlags | Flags.READONLY); initSlot("runtimeH", setFlags); break;
      case 8: initSlot("outI", setFlags | Flags.READONLY); initSlot("runtimeI", setFlags); break;
      case 9: initSlot("outJ", setFlags | Flags.READONLY); initSlot("runtimeJ", setFlags); break;
      }
    }
  }

  void initSlot(String slot, int flags)
  {
      try { setFlags(getSlot(slot), flags, null);} catch(Exception e) {};
  }


  public void doClearAlarmState()
  {
    if(this.alarmClearTicket != null)
    {
      alarmClearTicket.cancel();
      alarmClearTicket = null;
    }
    for( int i = 0; i < numOutputs; i++)
    {
      getStatusOutput(i).setStatusInAlarm(false);
    }
  }

  public void doRotateTimerExpired()
  {
    if(!currentIn) return;
    getRuntimes();  // load current cycle counts.
    startOutput();
//    startRotateTimer();     // start rotate timer
  }

  public void doFeedbackTimerExpired()
  {
    feedbackTimerActive = false;
    if(!currentIn) return;
    if(getFeedback().getValue()) return;
    setCurrentOutputAlarm(true);
    getRuntimes();  // load current cycle counts.
    startOutput();
  }


  void calculate()
  { 
    getRuntimes();  // load current cycle counts.
    
    if(currentIn)  // if controlIn is active
    {
      if(!wasOn)   // and was not active on last execute
      {
        startOutput();          // start lowest runtime output
//        startRotateTimer();     // start rotate timer
        wasOn = true;           // set was on flag.
      }
    }
    else  // control in is not active
    {
      if(wasOn)  // if was active on last execute
      {
        if(rotateTicket != null) rotateTicket.cancel();
        if(feedbackTicket != null) feedbackTicket.cancel();
        wasOn = false;             // clear was on flag.
      }
      stopOutput();              // stop all outputs
      
    }
  }

  // read linked runtimes into array
  // set unlinked runtimes to -1
  void getRuntimes()
  {
    for(int i = 0; i < numOutputs; i++)
    {
      if( isRuntimeLinked(i) && !getOutValue(i) )
        runtimes[i] = getRuntime(i);
      else
        runtimes[i] = Long.MAX_VALUE;
    }
  }

  long getRuntime(int index)
  {
    switch(index)
    {
    case 0: return getRuntimeA().getMillis();
    case 1: return getRuntimeB().getMillis();
    case 2: return getRuntimeC().getMillis();
    case 3: return getRuntimeD().getMillis();
    case 4: return getRuntimeE().getMillis();
    case 5: return getRuntimeF().getMillis();
    case 6: return getRuntimeG().getMillis();
    case 7: return getRuntimeH().getMillis();
    case 8: return getRuntimeI().getMillis();
    case 9: return getRuntimeJ().getMillis();
    }
    return Long.MAX_VALUE; 
  }

  boolean getOutValue(int index)
  {
    switch(index)
    {
    case 0: return getOutA().getValue();
    case 1: return getOutB().getValue();
    case 2: return getOutC().getValue();
    case 3: return getOutD().getValue();
    case 4: return getOutE().getValue();
    case 5: return getOutF().getValue();
    case 6: return getOutG().getValue();
    case 7: return getOutH().getValue();
    case 8: return getOutI().getValue();
    case 9: return getOutJ().getValue();
    }
    return false; 
  }
  
  // Test to see if cycle count slot is linked
  boolean isRuntimeLinked(int index)
  {
    BLink[] links = null;
    switch(index)
    {
    case 0: links = getLinks(runtimeA); break;
    case 1: links = getLinks(runtimeB); break;
    case 2: links = getLinks(runtimeC); break;
    case 3: links = getLinks(runtimeD); break;
    case 4: links = getLinks(runtimeE); break;
    case 5: links = getLinks(runtimeF); break;
    case 6: links = getLinks(runtimeG); break;
    case 7: links = getLinks(runtimeH); break;
    case 8: links = getLinks(runtimeI); break;
    case 9: links = getLinks(runtimeJ); break;
    }
    if(links == null)
      return false;
    return (links.length != 0);
  }
  
  // This method will start the output with the lowest runtime.
  // It will turn off all other outputs.
  void startOutput()
  {
    long minRuntime = Long.MAX_VALUE;
    int index = 0;
    for( int i = 0; i < numOutputs; i++)
    {
      if(getStatusOutput(i).getStatus().isAlarm())
        continue;
      if(runtimes[i] < minRuntime)
      {
        minRuntime = runtimes[i];
        index = i;
      }
    }
//    getStatusOutput(index).setStatusInAlarm(false);
    for(int i = 0; i < numOutputs; i++)
    {
      getStatusOutput(i).setValue(index == i);
    }
    startRotateTimer();
    startFeedbackTimer();
  }


  BStatusBoolean getStatusOutput(int index)
  {
    switch(index)
    {
    case 0: return getOutA();
    case 1: return getOutB();
    case 2: return getOutC();
    case 3: return getOutD();
    case 4: return getOutE();
    case 5: return getOutF();
    case 6: return getOutG();
    case 7: return getOutH();
    case 8: return getOutI();
    case 9: return getOutJ();
    }
    if(index < 0) return getOutA();
    return getOutJ();
  }

  
  void setCurrentOutputAlarm(boolean alarm)
  {
    if(alarm)
    {
      startAlarmClearTimer();
    }
    BStatusBoolean currentOut;
    for(int i = 0; i < numOutputs; i++)
    {
      currentOut = getStatusOutput(i);
      if(currentOut.getValue())
        currentOut.setStatusInAlarm(alarm);
    }
  }

  // Turn off all outputs
  void stopOutput()
  {
    for(int i = 0; i < numOutputs; i++)
      getStatusOutput(i).setValue(false);
  }
  
  // start alarm clear timer. It will call back clearAlarmState when it expires.
  void startAlarmClearTimer()
  {
    BRelTime clearTime = getClearAlarmTime();
    if (clearTime.getMillis() == 0 || alarmClearTicket != null) return;
    alarmClearTicket = Clock.schedule(this, clearTime, clearAlarmState, null);
  }    
  
  // start rotate timer. It will call back execute when it expires.
  void startRotateTimer()
  {            
    if (rotateTicket != null) rotateTicket.cancel();
    rotateTicket = Clock.schedule(this, getMaxRuntime(), rotateTimerExpired, null);
  }    
  
  // start feedback timer. It will call back execute when it expires.
  void startFeedbackTimer()
  {            
    if (feedbackTicket != null) feedbackTicket.cancel();
    feedbackTimerActive = true;
    feedbackTicket = Clock.schedule(this, getFeedbackDelay(), feedbackTimerExpired, null);
  }    
  
  

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().startsWith("out")) return getFacets();
    return super.getSlotFacets(slot);
  }


  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  int numOutputs;
  int lastNumberOutputs;
  boolean feedbackTimerActive = false;
  boolean currentIn;
  boolean wasOn = false;
  long[] runtimes = new long[10];

  // rotate timer ticket.
  Clock.Ticket rotateTicket;    // Used to manage the on delay timer
  Clock.Ticket feedbackTicket;    // Used to manage the on delay timer
  Clock.Ticket alarmClearTicket;    // Used to manage the on delay timer
  
}
