/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.enums;

import javax.baja.sys.*;

/**
 * BOffOn is an BEnum that represents valid Baja OffOn
 * values
 *
 * @author    Danny Wahlquist
 * @creation  25 Oct 04
 * @version   $Revision: 11$ $Date: 03-Jun-04 1:11:35 PM$
 * @since     Baja 1.0
 */
public final class BOffOn
  extends BFrozenEnum
{

  /*-
  enum BOffOn
  {
    range
    {
      off,
      on     
    }
  }
    
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.enums.BOffOn(2273591958)1.0$ @*/
/* Generated Tue Jul 03 12:48:08 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for off. */
  public static final int OFF = 0;
  /** Ordinal value for on. */
  public static final int ON = 1;
  
  /** BOffOn constant for off. */
  public static final BOffOn off = new BOffOn(OFF);
  /** BOffOn constant for on. */
  public static final BOffOn on = new BOffOn(ON);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BOffOn.class);
  
  /** Factory method with ordinal. */
  public static BOffOn make(int ordinal)
  {
    return (BOffOn)off.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BOffOn make(String tag)
  {
    return (BOffOn)off.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BOffOn(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BOffOn DEFAULT = BOffOn.off;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  /*********************************************
  *  Convenience method.  Returns true if and only
  *  if the current value of the enumeration
  *  is NOT equal to NO_FAULT_DETECTED.
  **********************************************/
  public final boolean isFault()
  {
    return (this != off);
  }
      
}

