/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.enums;

import javax.baja.sys.*;

/**
 * BOccupied is an BEnum that represents valid Baja Occupied
 * values
 *
 * @author    Danny Wahlquist
 * @creation  25 Oct 04
 * @version   $Revision: 11$ $Date: 03-Jun-04 1:11:35 PM$
 * @since     Baja 1.0
 */
public final class BOccupied
  extends BFrozenEnum
{

  /*-
  enum BOccupied
  {
    range
    {
      unoccupied,
      occupied     
    }
  }
    
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.enums.BOccupied(3085583283)1.0$ @*/
/* Generated Tue Jul 03 12:48:08 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for unoccupied. */
  public static final int UNOCCUPIED = 0;
  /** Ordinal value for occupied. */
  public static final int OCCUPIED = 1;
  
  /** BOccupied constant for unoccupied. */
  public static final BOccupied unoccupied = new BOccupied(UNOCCUPIED);
  /** BOccupied constant for occupied. */
  public static final BOccupied occupied = new BOccupied(OCCUPIED);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BOccupied.class);
  
  /** Factory method with ordinal. */
  public static BOccupied make(int ordinal)
  {
    return (BOccupied)unoccupied.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BOccupied make(String tag)
  {
    return (BOccupied)unoccupied.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BOccupied(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BOccupied DEFAULT = BOccupied.unoccupied;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  /*********************************************
  *  Convenience method.  Returns true if and only
  *  if the current value of the enumeration
  *  is NOT equal to NO_FAULT_DETECTED.
  **********************************************/
  public final boolean isFault()
  {
    return (this != unoccupied);
  }
      
}

