/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.enums;

import javax.baja.sys.*;

/**
 * BLoopAction is a BEnum containing values for direct (direct) 
 * and reverse action PID loop logic
 *
 * @author    Dan Giorgis
 * @creation   9 Nov 00
 * @version   $Revision: 10$ $Date: 03-Jun-04 1:11:25 PM$
 * @since     Baja 1.0
 */
public final class BLoopAction
  extends BFrozenEnum
{

  /*-
    enum BLoopAction
  {
    range
    {
      direct,    
      reverse
    }
  }
    
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.enums.BLoopAction(3702207270)1.0$ @*/
/* Generated Tue Jul 03 12:48:08 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for direct. */
  public static final int DIRECT = 0;
  /** Ordinal value for reverse. */
  public static final int REVERSE = 1;
  
  /** BLoopAction constant for direct. */
  public static final BLoopAction direct = new BLoopAction(DIRECT);
  /** BLoopAction constant for reverse. */
  public static final BLoopAction reverse = new BLoopAction(REVERSE);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLoopAction.class);
  
  /** Factory method with ordinal. */
  public static BLoopAction make(int ordinal)
  {
    return (BLoopAction)direct.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BLoopAction make(String tag)
  {
    return (BLoopAction)direct.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BLoopAction(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BLoopAction DEFAULT = BLoopAction.direct;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/



}

