/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.enums;

import javax.baja.sys.*;

/**
 * BEnglishMetric is an BEnum that represents valid Baja Secure
 * values
 *
 * @author    Andy Saunders
 * @creation  18 Sept 06
 * @version   $Revision: 11$ $Date: 03-Jun-04 1:11:35 PM$
 * @since     Baja 1.0
 */
public final class BEnglishMetric
  extends BFrozenEnum
{

  /*-
  enum BEnglishMetric
  {
    range
    {
      english,
      metric     
    }
  }
    
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.enums.BEnglishMetric(2881138612)1.0$ @*/
/* Generated Tue Jul 03 12:48:08 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for english. */
  public static final int ENGLISH = 0;
  /** Ordinal value for metric. */
  public static final int METRIC = 1;
  
  /** BEnglishMetric constant for english. */
  public static final BEnglishMetric english = new BEnglishMetric(ENGLISH);
  /** BEnglishMetric constant for metric. */
  public static final BEnglishMetric metric = new BEnglishMetric(METRIC);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnglishMetric.class);
  
  /** Factory method with ordinal. */
  public static BEnglishMetric make(int ordinal)
  {
    return (BEnglishMetric)english.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BEnglishMetric make(String tag)
  {
    return (BEnglishMetric)english.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BEnglishMetric(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BEnglishMetric DEFAULT = BEnglishMetric.english;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

      
}

