/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.energy;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.units.*;

import com.tridium.kitControl.enums.*;

 /* Sliding Window Demand Calculation
 *
 * KW = ( KWHperPulse * PulsesPerScan * K * 3600.0 ) + ( (1-Scantime* K) * KW );
 * where
 *   K = 0.00751  for  5 Minute Interval
 *   K = 0.002535 for 15 Minute Interval
 *   K = 0.001278 for 30 Minute Interval
 *
 * @author    Andy Saunders
 * @creation  16 May 2005
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public class BSlidingWindowDemandCalc
  extends BComponent
{ 
  /*-
  
  class BSlidingWindowDemandCalc
  {
    properties
    {
      consumptionFacets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeNumeric(UnitDatabase.getUnit("kilowatt hour"), 1) ]}

      demandFacets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeNumeric(UnitDatabase.getUnit("kilowatt"), 1) ]}

      kwhPerPulseFacets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeNumeric(UnitDatabase.getUnit("kilowatt hour"), 3) ]}

      currentPulseCount: BStatusNumeric
        --Pulse count input - continous pulses
        flags{ transient }
        default{[ new BStatusNumeric() ]}
        
      timeOfReset:   BAbsTime 
        --Reset Time.  Time of last reset
        flags{ readonly }
        default {[ BAbsTime.NULL ]}
        
      demand5:     BStatusNumeric  
        -- 5 minute Demand KW value
        flags{ readonly }
        default {[ new BStatusNumeric() ]}
        
      demand15:    BStatusNumeric  //15 minute Demand KW value
        -- 15 minute Demand KW value
        flags{ readonly }
        default {[ new BStatusNumeric() ]}

      demand30:    BStatusNumeric  //30 minute Demand KW value
        -- 30 minute Demand KW value
        flags{ readonly }
        default {[ new BStatusNumeric() ]}

      kwh:         BStatusNumeric  //Running KWH value since last reset
        -- Running KWH value since last reset
        flags{ readonly }
        default {[ new BStatusNumeric() ]}
        
      kwhHourly:   BStatusNumeric  
        --Running KWH value since last hourly reset
        flags{ readonly }
        default {[ new BStatusNumeric() ]}
      
      kwhLastHour: BStatusNumeric  
        --KWH value for last hour
        flags{ readonly }
        default {[ new BStatusNumeric() ]}

      kwhDaily:    BStatusNumeric  
        --Running KWH value since last daily reset
        flags{ readonly }
        default {[ new BStatusNumeric() ]}

      kwhLastDay:  BStatusNumeric  
        --KWH value for last day
        flags{ readonly }
        default {[ new BStatusNumeric() ]}
        
        
      kwhPerPulse: double	
        --KWH value per pulse
        default{[ 1.0 ]}
        
      enableReset: boolean 
        --Flag to enable recurring automatic reset
        default{[ true ]}
        
      resetDayOfMonth:  int		
        --Day of month for recurring automatic reset
        default{[ 1 ]}
        slotfacets{[ BFacets.makeInt(1, 31) ]}
        
      resetDayOfWeek:   BWeekday 
        --Day of week for recurring automatic reset
        default{[ BWeekday.sunday ]}
        
      resetTime:        BTime		
        --Time of day for recurring automatic reset
        default{[ BTime.make(0,0,0) ]}
        
      meterRollover: long
        -- maximum pulse count from device
        default{[65535l]}    
      


    }
    
    actions
    {
    
      calculate()
        flags{ hidden }
        
      hourUpdate()
        flags{ hidden }
        
      dayUpdate()
        flags{ hidden }
      
      resetMonthly()
      
      resetData()
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.energy.BSlidingWindowDemandCalc(205521959)1.0$ @*/
/* Generated Thu Dec 09 11:24:09 EST 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "consumptionFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>consumptionFacets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getConsumptionFacets
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setConsumptionFacets
   */
  public static final Property consumptionFacets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("kilowatt hour"), 1),null);
  
  /**
   * Get the <code>consumptionFacets</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#consumptionFacets
   */
  public BFacets getConsumptionFacets() { return (BFacets)get(consumptionFacets); }
  
  /**
   * Set the <code>consumptionFacets</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#consumptionFacets
   */
  public void setConsumptionFacets(BFacets v) { set(consumptionFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "demandFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demandFacets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getDemandFacets
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setDemandFacets
   */
  public static final Property demandFacets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("kilowatt"), 1),null);
  
  /**
   * Get the <code>demandFacets</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#demandFacets
   */
  public BFacets getDemandFacets() { return (BFacets)get(demandFacets); }
  
  /**
   * Set the <code>demandFacets</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#demandFacets
   */
  public void setDemandFacets(BFacets v) { set(demandFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "kwhPerPulseFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>kwhPerPulseFacets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getKwhPerPulseFacets
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setKwhPerPulseFacets
   */
  public static final Property kwhPerPulseFacets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("kilowatt hour"), 3),null);
  
  /**
   * Get the <code>kwhPerPulseFacets</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhPerPulseFacets
   */
  public BFacets getKwhPerPulseFacets() { return (BFacets)get(kwhPerPulseFacets); }
  
  /**
   * Set the <code>kwhPerPulseFacets</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhPerPulseFacets
   */
  public void setKwhPerPulseFacets(BFacets v) { set(kwhPerPulseFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "currentPulseCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>currentPulseCount</code> property.
   * Pulse count input - continous pulses
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getCurrentPulseCount
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setCurrentPulseCount
   */
  public static final Property currentPulseCount = newProperty(Flags.TRANSIENT, new BStatusNumeric(),null);
  
  /**
   * Get the <code>currentPulseCount</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#currentPulseCount
   */
  public BStatusNumeric getCurrentPulseCount() { return (BStatusNumeric)get(currentPulseCount); }
  
  /**
   * Set the <code>currentPulseCount</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#currentPulseCount
   */
  public void setCurrentPulseCount(BStatusNumeric v) { set(currentPulseCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "timeOfReset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timeOfReset</code> property.
   * Reset Time.  Time of last reset
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getTimeOfReset
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setTimeOfReset
   */
  public static final Property timeOfReset = newProperty(Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>timeOfReset</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#timeOfReset
   */
  public BAbsTime getTimeOfReset() { return (BAbsTime)get(timeOfReset); }
  
  /**
   * Set the <code>timeOfReset</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#timeOfReset
   */
  public void setTimeOfReset(BAbsTime v) { set(timeOfReset,v,null); }

////////////////////////////////////////////////////////////////
// Property "demand5"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demand5</code> property.
   * 5 minute Demand KW value
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getDemand5
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setDemand5
   */
  public static final Property demand5 = newProperty(Flags.READONLY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>demand5</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#demand5
   */
  public BStatusNumeric getDemand5() { return (BStatusNumeric)get(demand5); }
  
  /**
   * Set the <code>demand5</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#demand5
   */
  public void setDemand5(BStatusNumeric v) { set(demand5,v,null); }

////////////////////////////////////////////////////////////////
// Property "demand15"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demand15</code> property.
   * 15 minute Demand KW value
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getDemand15
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setDemand15
   */
  public static final Property demand15 = newProperty(Flags.READONLY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>demand15</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#demand15
   */
  public BStatusNumeric getDemand15() { return (BStatusNumeric)get(demand15); }
  
  /**
   * Set the <code>demand15</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#demand15
   */
  public void setDemand15(BStatusNumeric v) { set(demand15,v,null); }

////////////////////////////////////////////////////////////////
// Property "demand30"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demand30</code> property.
   * 30 minute Demand KW value
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getDemand30
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setDemand30
   */
  public static final Property demand30 = newProperty(Flags.READONLY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>demand30</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#demand30
   */
  public BStatusNumeric getDemand30() { return (BStatusNumeric)get(demand30); }
  
  /**
   * Set the <code>demand30</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#demand30
   */
  public void setDemand30(BStatusNumeric v) { set(demand30,v,null); }

////////////////////////////////////////////////////////////////
// Property "kwh"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>kwh</code> property.
   * Running KWH value since last reset
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getKwh
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setKwh
   */
  public static final Property kwh = newProperty(Flags.READONLY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>kwh</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwh
   */
  public BStatusNumeric getKwh() { return (BStatusNumeric)get(kwh); }
  
  /**
   * Set the <code>kwh</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwh
   */
  public void setKwh(BStatusNumeric v) { set(kwh,v,null); }

////////////////////////////////////////////////////////////////
// Property "kwhHourly"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>kwhHourly</code> property.
   * Running KWH value since last hourly reset
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getKwhHourly
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setKwhHourly
   */
  public static final Property kwhHourly = newProperty(Flags.READONLY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>kwhHourly</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhHourly
   */
  public BStatusNumeric getKwhHourly() { return (BStatusNumeric)get(kwhHourly); }
  
  /**
   * Set the <code>kwhHourly</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhHourly
   */
  public void setKwhHourly(BStatusNumeric v) { set(kwhHourly,v,null); }

////////////////////////////////////////////////////////////////
// Property "kwhLastHour"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>kwhLastHour</code> property.
   * KWH value for last hour
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getKwhLastHour
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setKwhLastHour
   */
  public static final Property kwhLastHour = newProperty(Flags.READONLY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>kwhLastHour</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhLastHour
   */
  public BStatusNumeric getKwhLastHour() { return (BStatusNumeric)get(kwhLastHour); }
  
  /**
   * Set the <code>kwhLastHour</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhLastHour
   */
  public void setKwhLastHour(BStatusNumeric v) { set(kwhLastHour,v,null); }

////////////////////////////////////////////////////////////////
// Property "kwhDaily"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>kwhDaily</code> property.
   * Running KWH value since last daily reset
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getKwhDaily
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setKwhDaily
   */
  public static final Property kwhDaily = newProperty(Flags.READONLY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>kwhDaily</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhDaily
   */
  public BStatusNumeric getKwhDaily() { return (BStatusNumeric)get(kwhDaily); }
  
  /**
   * Set the <code>kwhDaily</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhDaily
   */
  public void setKwhDaily(BStatusNumeric v) { set(kwhDaily,v,null); }

////////////////////////////////////////////////////////////////
// Property "kwhLastDay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>kwhLastDay</code> property.
   * KWH value for last day
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getKwhLastDay
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setKwhLastDay
   */
  public static final Property kwhLastDay = newProperty(Flags.READONLY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>kwhLastDay</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhLastDay
   */
  public BStatusNumeric getKwhLastDay() { return (BStatusNumeric)get(kwhLastDay); }
  
  /**
   * Set the <code>kwhLastDay</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhLastDay
   */
  public void setKwhLastDay(BStatusNumeric v) { set(kwhLastDay,v,null); }

////////////////////////////////////////////////////////////////
// Property "kwhPerPulse"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>kwhPerPulse</code> property.
   * KWH value per pulse
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getKwhPerPulse
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setKwhPerPulse
   */
  public static final Property kwhPerPulse = newProperty(0, 1.0,null);
  
  /**
   * Get the <code>kwhPerPulse</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhPerPulse
   */
  public double getKwhPerPulse() { return getDouble(kwhPerPulse); }
  
  /**
   * Set the <code>kwhPerPulse</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#kwhPerPulse
   */
  public void setKwhPerPulse(double v) { setDouble(kwhPerPulse,v,null); }

////////////////////////////////////////////////////////////////
// Property "enableReset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>enableReset</code> property.
   * Flag to enable recurring automatic reset
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getEnableReset
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setEnableReset
   */
  public static final Property enableReset = newProperty(0, true,null);
  
  /**
   * Get the <code>enableReset</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#enableReset
   */
  public boolean getEnableReset() { return getBoolean(enableReset); }
  
  /**
   * Set the <code>enableReset</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#enableReset
   */
  public void setEnableReset(boolean v) { setBoolean(enableReset,v,null); }

////////////////////////////////////////////////////////////////
// Property "resetDayOfMonth"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>resetDayOfMonth</code> property.
   * Day of month for recurring automatic reset
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getResetDayOfMonth
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setResetDayOfMonth
   */
  public static final Property resetDayOfMonth = newProperty(0, 1,BFacets.makeInt(1, 31));
  
  /**
   * Get the <code>resetDayOfMonth</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#resetDayOfMonth
   */
  public int getResetDayOfMonth() { return getInt(resetDayOfMonth); }
  
  /**
   * Set the <code>resetDayOfMonth</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#resetDayOfMonth
   */
  public void setResetDayOfMonth(int v) { setInt(resetDayOfMonth,v,null); }

////////////////////////////////////////////////////////////////
// Property "resetDayOfWeek"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>resetDayOfWeek</code> property.
   * Day of week for recurring automatic reset
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getResetDayOfWeek
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setResetDayOfWeek
   */
  public static final Property resetDayOfWeek = newProperty(0, BWeekday.sunday,null);
  
  /**
   * Get the <code>resetDayOfWeek</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#resetDayOfWeek
   */
  public BWeekday getResetDayOfWeek() { return (BWeekday)get(resetDayOfWeek); }
  
  /**
   * Set the <code>resetDayOfWeek</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#resetDayOfWeek
   */
  public void setResetDayOfWeek(BWeekday v) { set(resetDayOfWeek,v,null); }

////////////////////////////////////////////////////////////////
// Property "resetTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>resetTime</code> property.
   * Time of day for recurring automatic reset
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getResetTime
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setResetTime
   */
  public static final Property resetTime = newProperty(0, BTime.make(0,0,0),null);
  
  /**
   * Get the <code>resetTime</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#resetTime
   */
  public BTime getResetTime() { return (BTime)get(resetTime); }
  
  /**
   * Set the <code>resetTime</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#resetTime
   */
  public void setResetTime(BTime v) { set(resetTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "meterRollover"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>meterRollover</code> property.
   * maximum pulse count from device
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#getMeterRollover
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#setMeterRollover
   */
  public static final Property meterRollover = newProperty(0, 65535l,null);
  
  /**
   * Get the <code>meterRollover</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#meterRollover
   */
  public long getMeterRollover() { return getLong(meterRollover); }
  
  /**
   * Set the <code>meterRollover</code> property.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#meterRollover
   */
  public void setMeterRollover(long v) { setLong(meterRollover,v,null); }

////////////////////////////////////////////////////////////////
// Action "calculate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#calculate()
   */
  public static final Action calculate = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#calculate
   */
  public void calculate() { invoke(calculate,null,null); }

////////////////////////////////////////////////////////////////
// Action "hourUpdate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>hourUpdate</code> action.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#hourUpdate()
   */
  public static final Action hourUpdate = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>hourUpdate</code> action.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#hourUpdate
   */
  public void hourUpdate() { invoke(hourUpdate,null,null); }

////////////////////////////////////////////////////////////////
// Action "dayUpdate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>dayUpdate</code> action.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#dayUpdate()
   */
  public static final Action dayUpdate = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>dayUpdate</code> action.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#dayUpdate
   */
  public void dayUpdate() { invoke(dayUpdate,null,null); }

////////////////////////////////////////////////////////////////
// Action "resetMonthly"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>resetMonthly</code> action.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#resetMonthly()
   */
  public static final Action resetMonthly = newAction(0,null);
  
  /**
   * Invoke the <code>resetMonthly</code> action.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#resetMonthly
   */
  public void resetMonthly() { invoke(resetMonthly,null,null); }

////////////////////////////////////////////////////////////////
// Action "resetData"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>resetData</code> action.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#resetData()
   */
  public static final Action resetData = newAction(0,null);
  
  /**
   * Invoke the <code>resetData</code> action.
   * @see com.tridium.kitControl.energy.BSlidingWindowDemandCalc#resetData
   */
  public void resetData() { invoke(resetData,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSlidingWindowDemandCalc.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Initialization  /  Cleanup
////////////////////////////////////////////////////////////////

  public void started()
    throws Exception
  {

    if(ticket != null)
      ticket.cancel();
    ticket = Clock.schedulePeriodically(this, BRelTime.makeMinutes(1), calculate, null);
    super.started();
  }

  public void stopped()
    throws Exception
  {
    if(ticket != null)
      ticket.cancel();
    super.stopped();
  }


  public void changed(Property property, Context context) 
  {
  	super.changed(property, context);
//    if( !Sys.atSteadyState() || !isRunning() )
//	    return;
    
  }

  public BFacets getSlotFacets(Slot slot)
  {
    if( slot.equals(kwh)         ||
        slot.equals(kwhDaily)    ||
        slot.equals(kwhHourly)   ||
        slot.equals(kwhLastDay)  ||
        slot.equals(kwhLastHour)    )
      return getConsumptionFacets();
    else if( slot.equals(demand5)  ||
             slot.equals(demand15) ||
             slot.equals(demand30)    )
      return getDemandFacets();
    else if(slot.equals(kwhPerPulse))
    {
      return getKwhPerPulseFacets();
    }
    return super.getSlotFacets(slot);
  }

  public void doHourUpdate() {}
  
  public void doDayUpdate(){}
  
  public void doResetData()
  {
    // return if calculate has never run.
    if(now == null)
      return;
    getKwh().setValue( 0.0);
    getKwhHourly().setValue(0.0);
    getKwhLastHour().setValue( 0.0 );
    getKwhDaily().setValue( 0.0 );
    getKwhLastDay().setValue(0.0);
    getDemand5().setValue(0.0);
    getDemand15().setValue(0.0);
    getDemand30().setValue(0.0);
    previousTime = now;
    lastHour = now.getHour();
    lastDay = now.getDay();
    resetFlag = true;
    setTimeOfReset( Clock.time() );
  }

  public void setDataFaultStatus(boolean fault)
  {
    getKwh().setStatusFault(fault);
    getKwhHourly().setStatusFault(fault);
    getKwhLastHour().setStatusFault(fault);
    getKwhDaily().setStatusFault(fault);
    getKwhLastDay().setStatusFault(fault);
    getDemand5().setStatusFault(fault);
    getDemand15().setStatusFault(fault);
    getDemand30().setStatusFault(fault);
  }

  public void doResetMonthly()
  {
    // return if calculate has never run.
    if(now == null)
      return;
    getKwh().setValue( 0.0);
    getKwhHourly().setValue(0.0);
    getKwhLastHour().setValue( 0.0 );
    getKwhDaily().setValue( 0.0 );
    getKwhLastDay().setValue(0.0);
    previousTime = now;
    lastHour = now.getHour();
    lastDay = now.getDay();
    resetFlag = true;
    setTimeOfReset( Clock.time() );
  }

  public void doPulseCalculate()
  {
    // do nothing unless pulse count actually changes
    if ( getCurrentPulseCount().getValue() == lastPulseCount )
      return;
    // don't process if current input is invalid.
    if ( ! getCurrentPulseCount().getStatus().isValid()  || Double.isNaN(getCurrentPulseCount().getValue()) )
      return;
    long thisCountChangeTicks = Clock.millis();
    countChangePeriod = thisCountChangeTicks - lastCountChangeTicks;
    if( (countChangePeriod) < FIFTY_SECONDS )
    {
      isSlowRate = false;
      lastCountChangeTicks = thisCountChangeTicks;
      doCalculate();
    }
    else
    {
      isSlowRate = true;
      lastCountChangeTicks = thisCountChangeTicks;
    }
      
  }
  
  public void doCalculate()
  {
//   if(ticket != null)
//      ticket.cancel();
//    ticket = Clock.schedule(this, BRelTime.makeMinutes(1), calculate, null);
    now = Clock.time();
    
    if ( firstTime == true )	//Initialize values when run for the first time
    {
      lastPulseCount = getCurrentPulseCount().getValue();
      // don't process if current input is invalid.
      if ( ! getCurrentPulseCount().getStatus().isValid()  || Double.isNaN(getCurrentPulseCount().getValue()) )
      {
        setDataFaultStatus(true);
        return;
      }
      setDataFaultStatus(false);
      lastCountChangeTicks = now.getMillis();
      previousTime = now;
      setTimeOfReset(now);
      lastHour = now.getHour();
      lastDay = now.getDay();
      firstTime = false;
      return;
    }
    
    if ( reset == false )		//Reset logic for recurring automatic reset
    {
      int today = now.getDay();
      int resetDayOfMonth = getResetDayOfMonth();
      if ( (today >= resetDayOfMonth) && (resetDayOfMonth < resetDayOfMonth + 7) )
      {
        if ( now.getWeekday().equals(getResetDayOfWeek() ) )
        {
          if ( now.getTimeOfDayMillis() >= getResetTime().getTimeOfDayMillis() )
          {
            reset = true;
            setTimeOfReset( Clock.time() );
          }
        }
      }
    }
    
    if ( reset )
    {
      if ( !( now.getWeekday().equals(getResetDayOfWeek()) ) )
        reset = false;
    }
      
    if ( ( getEnableReset() == true ) && ( reset == true ) && ( resetFlag == false ) )	//Reset values when recurring automatic reset occurs
    {
      getKwh().setValue( 0.0);
      getKwhHourly().setValue(0.0);
      getKwhLastHour().setValue( 0.0 );
      getKwhDaily().setValue( 0.0 );
      getKwhLastDay().setValue(0.0);
      previousTime = now;
      lastHour = now.getHour();
      lastDay = now.getDay();
      resetFlag = true;
    }
    
    if ( reset == false )
      resetFlag = false;
    
    diffSec= ((double)previousTime.delta(now).getMillis())/1000.0;
    //System.out.println("   diffSec = " + diffSec);
    previousTime=now;
    maxPulseDiff = (int)(diffSec * 10.0);  //Ensures that no more than 10 pulses/second are considered valid
    
    double currentCount =  getCurrentPulseCount().getValue();
    // don't process if current input is invalid.
    if ( ! getCurrentPulseCount().getStatus().isValid()  || Double.isNaN(getCurrentPulseCount().getValue()) )
    {
      setDataFaultStatus(true);
      return;
    }
    setDataFaultStatus(false);
    //System.out.println(" currentCount   = " + currentCount);
    //System.out.println(" lastPulseCount = " + lastPulseCount);
    if ( currentCount >= lastPulseCount )
      pulseCountDiff = currentCount - lastPulseCount;
    else
      pulseCountDiff = (double)getMeterRollover() + 1.0  + currentCount - lastPulseCount;  
    
    // To insure pulseCountDiff is not an invalid number due to power outage, etc. of the pulseCounter
    //System.out.println(" pulseCountDiff =  " + pulseCountDiff);
    //System.out.println(" maxPulseDiff   =  " + maxPulseDiff);
    if ( pulseCountDiff > maxPulseDiff  || pulseCountDiff < 0 )
    {
      lastPulseCount = currentCount;
      
      return;
    }
    
    if(pulseCountDiff > 0 && isSlowRate)
      diffSec = ((double)countChangePeriod)/1000.0;
    //System.out.println("  actual diffSec = " + diffSec);
    // Running KWH
    kwhNew = pulseCountDiff * getKwhPerPulse();
    getKwh().setValue( getKwh().getValue() + kwhNew );
    lastPulseCount = currentCount;
    
    // Hourly KWH
    if ( lastHour != now.getHour() )
    {
      lastHour = now.getHour();
      getKwhLastHour().setValue( getKwhHourly().getValue() ); 
      hourUpdate();		//Trigger for hourly Log
      getKwhHourly().setValue( kwhNew );
    }
    else
      getKwhHourly().setValue( getKwhHourly().getValue() + kwhNew );
    
    // Daily KWH
    if ( lastDay != now.getDay() )
    {
      lastDay = now.getDay();
      getKwhLastDay().setValue( getKwhDaily().getValue() );
      dayUpdate();		//Trigger for daily Log
      getKwhDaily().setValue(kwhNew);
    }
    else
      getKwhDaily().setValue( getKwhDaily().getValue()+ kwhNew );
    
    
    double x;
    // 5 Minute Demand Calculation
    x =  ( 1.0 - ( diffSec * 0.00751 ) ) * getDemand5().getValue();
    getDemand5().setValue( ( pulseCountDiff * getKwhPerPulse() * 0.00751 * 3600.0 ) + x );
    
    // 15 Minute Demand Calculation
    x =  ( 1.0 - ( diffSec * 0.002535 ) ) * getDemand15().getValue();
    getDemand15().setValue( ( pulseCountDiff * getKwhPerPulse() * 0.002535 * 3600.0 ) + x );
    
    // 30 Minute Demand Calculation
    x =  ( 1.0 - ( diffSec * 0.001278 ) ) * getDemand30().getValue();
    getDemand30().setValue( ( pulseCountDiff * getKwhPerPulse() * 0.001278 * 3600.0 ) + x );
    
    
    
  }
////////////////////////////////////////////////////////////////
// local variables
////////////////////////////////////////////////////////////////

  Clock.Ticket ticket = null;

  private static int FIFTY_SECONDS = 50000;
  
  BAbsTime now;
  BAbsTime previousTime;
  boolean reset = false;           //Reset Flag.  If true resets all power values
  boolean resetFlag = false;
  double diffSec;
  double kwhNew;
  int lastHour;
  int lastDay;
  boolean firstTime = true;
  int maxPulseDiff;
  double lastPulseCount;
  double pulseCountDiff;
  long lastCountChangeTicks = 0;
  long countChangePeriod = 0;
  boolean isSlowRate = false;

}