/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.energy;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.units.*;

import com.tridium.kitControl.enums.*;

/** Degree Day Calculation object
 *
 * 
 * @author    Andy Saunders
 * @creation  11 Jan 2005
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public class BSetpointOffset
  extends BComponent
{ 
  /*-
  
  class BSetpointOffset
  {
    properties
    {
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1) ]}

      shedLevelHighLimit: int
       --Shed level for maximum offset
       default {[ 32 ]} 
        slotfacets {[ BFacets.makeInt(2, 32) ]}
    
      shedLevelLowLimit: int			
        --Shed level at which offset begins
        default {[ 1 ]}
        slotfacets {[ BFacets.makeInt(1, 31) ]}
    
      -- inputs
      shedInhibit: BStatusBoolean
        -- 'false' input causes setpoint to be adjusted by offset
        flags { summary }
        default {[ new BStatusBoolean() ]}
      
      setpointIn: BStatusNumeric
        --Setpoint input that will be adjusted by this object
        flags { summary }
        default {[ new BStatusNumeric() ]}
      
      htgOffset:  BStatusNumeric 
        --Maximum setpoint offset (signed + or -) if active and in heating mode
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      clgOffset: BStatusNumeric
      	--Maximum setpoint offset (signed + or -) if active and in cooling mode
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
      modeIn: BStatusEnum 
        flags { summary }
        default {[ new BStatusEnum() ]}
        slotfacets {[ BFacets.makeEnum( BEnumRange.make(BOffHeatCool.TYPE) ) ]}
        
      shedLevel: BStatusNumeric
      	--Shed level in effect
        flags { summary }
        default {[ new BStatusNumeric() ]}
        slotfacets {[ BFacets.makeNumeric(0) ]}

      -- Outputs
      offsetInEffect: BStatusBoolean
       --Output to indicate if setpointOutStatus has been adjusted
       flags { summary }
       default {[ new BStatusBoolean() ]}
       
      setpointOut: BStatusNumeric
        --Adjusted setpoint if active otherwise passes through original setpoint
        flags { summary }
        default {[ new BStatusNumeric() ]}
        

    }
    
    actions
    {
      calculate()
        flags{ hidden }
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.energy.BSetpointOffset(2190826252)1.0$ @*/
/* Generated Fri Jan 28 15:52:48 EST 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#getFacets
   * @see com.tridium.kitControl.energy.BSetpointOffset#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "shedLevelHighLimit"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>shedLevelHighLimit</code> property.
   * Shed level for maximum offset
   * @see com.tridium.kitControl.energy.BSetpointOffset#getShedLevelHighLimit
   * @see com.tridium.kitControl.energy.BSetpointOffset#setShedLevelHighLimit
   */
  public static final Property shedLevelHighLimit = newProperty(0, 32,BFacets.makeInt(2, 32) );
  
  /**
   * Get the <code>shedLevelHighLimit</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#shedLevelHighLimit
   */
  public int getShedLevelHighLimit() { return getInt(shedLevelHighLimit); }
  
  /**
   * Set the <code>shedLevelHighLimit</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#shedLevelHighLimit
   */
  public void setShedLevelHighLimit(int v) { setInt(shedLevelHighLimit,v,null); }

////////////////////////////////////////////////////////////////
// Property "shedLevelLowLimit"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>shedLevelLowLimit</code> property.
   * Shed level at which offset begins
   * @see com.tridium.kitControl.energy.BSetpointOffset#getShedLevelLowLimit
   * @see com.tridium.kitControl.energy.BSetpointOffset#setShedLevelLowLimit
   */
  public static final Property shedLevelLowLimit = newProperty(0, 1,BFacets.makeInt(1, 31) );
  
  /**
   * Get the <code>shedLevelLowLimit</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#shedLevelLowLimit
   */
  public int getShedLevelLowLimit() { return getInt(shedLevelLowLimit); }
  
  /**
   * Set the <code>shedLevelLowLimit</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#shedLevelLowLimit
   */
  public void setShedLevelLowLimit(int v) { setInt(shedLevelLowLimit,v,null); }

////////////////////////////////////////////////////////////////
// Property "shedInhibit"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>shedInhibit</code> property.
   * 'false' input causes setpoint to be adjusted by offset
   * @see com.tridium.kitControl.energy.BSetpointOffset#getShedInhibit
   * @see com.tridium.kitControl.energy.BSetpointOffset#setShedInhibit
   */
  public static final Property shedInhibit = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>shedInhibit</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#shedInhibit
   */
  public BStatusBoolean getShedInhibit() { return (BStatusBoolean)get(shedInhibit); }
  
  /**
   * Set the <code>shedInhibit</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#shedInhibit
   */
  public void setShedInhibit(BStatusBoolean v) { set(shedInhibit,v,null); }

////////////////////////////////////////////////////////////////
// Property "setpointIn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>setpointIn</code> property.
   * Setpoint input that will be adjusted by this object
   * @see com.tridium.kitControl.energy.BSetpointOffset#getSetpointIn
   * @see com.tridium.kitControl.energy.BSetpointOffset#setSetpointIn
   */
  public static final Property setpointIn = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>setpointIn</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#setpointIn
   */
  public BStatusNumeric getSetpointIn() { return (BStatusNumeric)get(setpointIn); }
  
  /**
   * Set the <code>setpointIn</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#setpointIn
   */
  public void setSetpointIn(BStatusNumeric v) { set(setpointIn,v,null); }

////////////////////////////////////////////////////////////////
// Property "htgOffset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>htgOffset</code> property.
   * Maximum setpoint offset (signed + or -) if active and in heating mode
   * @see com.tridium.kitControl.energy.BSetpointOffset#getHtgOffset
   * @see com.tridium.kitControl.energy.BSetpointOffset#setHtgOffset
   */
  public static final Property htgOffset = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>htgOffset</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#htgOffset
   */
  public BStatusNumeric getHtgOffset() { return (BStatusNumeric)get(htgOffset); }
  
  /**
   * Set the <code>htgOffset</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#htgOffset
   */
  public void setHtgOffset(BStatusNumeric v) { set(htgOffset,v,null); }

////////////////////////////////////////////////////////////////
// Property "clgOffset"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>clgOffset</code> property.
   * Maximum setpoint offset (signed + or -) if active and in cooling mode
   * @see com.tridium.kitControl.energy.BSetpointOffset#getClgOffset
   * @see com.tridium.kitControl.energy.BSetpointOffset#setClgOffset
   */
  public static final Property clgOffset = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>clgOffset</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#clgOffset
   */
  public BStatusNumeric getClgOffset() { return (BStatusNumeric)get(clgOffset); }
  
  /**
   * Set the <code>clgOffset</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#clgOffset
   */
  public void setClgOffset(BStatusNumeric v) { set(clgOffset,v,null); }

////////////////////////////////////////////////////////////////
// Property "modeIn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>modeIn</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#getModeIn
   * @see com.tridium.kitControl.energy.BSetpointOffset#setModeIn
   */
  public static final Property modeIn = newProperty(Flags.SUMMARY, new BStatusEnum(),BFacets.makeEnum( BEnumRange.make(BOffHeatCool.TYPE) ) );
  
  /**
   * Get the <code>modeIn</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#modeIn
   */
  public BStatusEnum getModeIn() { return (BStatusEnum)get(modeIn); }
  
  /**
   * Set the <code>modeIn</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#modeIn
   */
  public void setModeIn(BStatusEnum v) { set(modeIn,v,null); }

////////////////////////////////////////////////////////////////
// Property "shedLevel"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>shedLevel</code> property.
   * Shed level in effect
   * @see com.tridium.kitControl.energy.BSetpointOffset#getShedLevel
   * @see com.tridium.kitControl.energy.BSetpointOffset#setShedLevel
   */
  public static final Property shedLevel = newProperty(Flags.SUMMARY, new BStatusNumeric(),BFacets.makeNumeric(0) );
  
  /**
   * Get the <code>shedLevel</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#shedLevel
   */
  public BStatusNumeric getShedLevel() { return (BStatusNumeric)get(shedLevel); }
  
  /**
   * Set the <code>shedLevel</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#shedLevel
   */
  public void setShedLevel(BStatusNumeric v) { set(shedLevel,v,null); }

////////////////////////////////////////////////////////////////
// Property "offsetInEffect"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>offsetInEffect</code> property.
   * Output to indicate if setpointOutStatus has been adjusted
   * @see com.tridium.kitControl.energy.BSetpointOffset#getOffsetInEffect
   * @see com.tridium.kitControl.energy.BSetpointOffset#setOffsetInEffect
   */
  public static final Property offsetInEffect = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>offsetInEffect</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#offsetInEffect
   */
  public BStatusBoolean getOffsetInEffect() { return (BStatusBoolean)get(offsetInEffect); }
  
  /**
   * Set the <code>offsetInEffect</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#offsetInEffect
   */
  public void setOffsetInEffect(BStatusBoolean v) { set(offsetInEffect,v,null); }

////////////////////////////////////////////////////////////////
// Property "setpointOut"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>setpointOut</code> property.
   * Adjusted setpoint if active otherwise passes through
   * original setpoint
   * @see com.tridium.kitControl.energy.BSetpointOffset#getSetpointOut
   * @see com.tridium.kitControl.energy.BSetpointOffset#setSetpointOut
   */
  public static final Property setpointOut = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>setpointOut</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#setpointOut
   */
  public BStatusNumeric getSetpointOut() { return (BStatusNumeric)get(setpointOut); }
  
  /**
   * Set the <code>setpointOut</code> property.
   * @see com.tridium.kitControl.energy.BSetpointOffset#setpointOut
   */
  public void setSetpointOut(BStatusNumeric v) { set(setpointOut,v,null); }

////////////////////////////////////////////////////////////////
// Action "calculate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BSetpointOffset#calculate()
   */
  public static final Action calculate = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BSetpointOffset#calculate
   */
  public void calculate() { invoke(calculate,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSetpointOffset.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Initialization  /  Cleanup
////////////////////////////////////////////////////////////////

  public void started()
    throws Exception
  {

    if(ticket != null)
      ticket.cancel();
    ticket = Clock.schedule(this, BRelTime.makeMinutes(1), calculate, null);

    super.started();
	  if( !Sys.atSteadyState() )
		  return;


  }

  public void stopped()
    throws Exception
  {
    if(ticket != null)
      ticket.cancel();
    super.stopped();
  }


  public void changed(Property property, Context context) 
  {
  	super.changed(property, context);
    if( !Sys.atSteadyState() || !isRunning() )
	    return;
    if(property.equals(shedLevelHighLimit))
    {
      if (getShedLevelHighLimit() <= getShedLevelLowLimit() ) 
      {
        setShedLevelHighLimit(getShedLevelLowLimit()+1);
      }
    }
    if(property.equals(shedLevelLowLimit))
    {
      if (getShedLevelLowLimit() >= getShedLevelHighLimit() ) 
      {
        setShedLevelLowLimit(getShedLevelHighLimit()-1);
      }
    }
    if(property.equals(setpointIn        ) ||
       property.equals(modeIn            ) ||
       property.equals(shedInhibit       ) ||
       property.equals(shedLevel         ) ||
       property.equals(clgOffset         ) ||
       property.equals(htgOffset         ) ||
       property.equals(shedLevelHighLimit) ||
       property.equals(shedLevelLowLimit )    )
      doCalculate();
  }

  public BFacets getSlotFacets(Slot slot)
  {
    if( slot.equals(setpointIn)  ||
        slot.equals(htgOffset)   ||
        slot.equals(clgOffset)   ||
        slot.equals(setpointOut)    )
      return getFacets();
    return super.getSlotFacets(slot);
  }

  public void doCalculate()
  {
    if(ticket != null)
      ticket.cancel();
    ticket = Clock.schedule(this, BRelTime.makeMinutes(1), calculate, null);
    
    int lowLimit = getShedLevelLowLimit();
    int highLimit = getShedLevelHighLimit();
    boolean localOffsetInEffect = false;
    double setpointOffset = 0.0;
    
    //Offset only applies when shedLevel > 0 and shedInhibit is 'commanded' to false
    if ( getShedLevel().getValue() > 0  &&  getShedInhibit().getValue() == false  && getModeIn().getValue().getOrdinal() != BOffHeatCool.OFF ) 
    {
    
    // validate limits
      if ( getShedLevelLowLimit() >= getShedLevelHighLimit())
      {
        setShedLevelLowLimit(1);
        lowLimit = 1;
      }
      else
      {
        if ( getShedLevelLowLimit() < 1  || getShedLevelLowLimit() > 32 )
          lowLimit = 1;
        if ( getShedLevelHighLimit() < 1 || getShedLevelHighLimit() > 32 )
          highLimit = 32;
      }
      if ( getShedLevel().getValue() >= lowLimit )
      {
        localOffsetInEffect = true;
        if ( getModeIn().getValue().getOrdinal() == BOffHeatCool.COOL )   			//Cooling Mode
          setpointOffset = getClgOffset().getValue();
        else if ( getModeIn().getValue().getOrdinal() == BOffHeatCool.HEAT )		//Heating Mode
          setpointOffset = getHtgOffset().getValue();
        if ( getShedLevel().getValue() < highLimit ) 
          setpointOffset = ( setpointOffset * ( getShedLevel().getValue() - lowLimit + 1 ) ) / ( highLimit - lowLimit + 1 );
      }
    }
    getOffsetInEffect().setValue(localOffsetInEffect);
    getSetpointOut().setValue( getSetpointIn().getValue() + setpointOffset);

    
  }

////////////////////////////////////////////////////////////////
// local variables
////////////////////////////////////////////////////////////////

  Clock.Ticket ticket = null;

}