/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.energy;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.units.*;

import com.tridium.kitControl.enums.*;
import com.tridium.kitControl.hvac.*;

/** BPsychrometric Component
 *
 * 
 * @author    Andy Saunders
 * @creation  20 April 2005
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public class BPsychrometric
  extends BComponent
{ 
  /*-
  
  class BPsychrometric
  {
    properties
    {
      unitSelect: BEnglishMetric
        default{[ BEnglishMetric.english ]}
      temperatureFacets: BFacets
        default{[ BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1) ]}
    
      humidityFacets: BFacets
        default{[ BFacets.makeNumeric(UnitDatabase.getUnit("percent relative humidity"), 1) ]}
        
      inTemp: BStatusNumeric
        flags{ summary }
        default {[ new BStatusNumeric() ]}
        
      inHumidity: BStatusNumeric
        flags{ summary }
        default {[ new BStatusNumeric() ]}

      outDewPoint: BStatusNumeric
        flags { summary, transient }
        default {[ new BStatusNumeric() ]}
    
      outEnthalpy: BStatusNumeric
        flags { summary, transient }
        default {[ new BStatusNumeric() ]}
        slotfacets {[ BFacets.makeNumeric(UnitDatabase.getUnit("btu per pound"), 2) ]}
    
      outSatPress: BStatusNumeric
        flags { summary, transient }
        default {[ new BStatusNumeric() ]}
        slotfacets {[ BFacets.makeNumeric(UnitDatabase.getUnit("pounds per square inch"), 3) ]}
      
      outVaporPress: BStatusNumeric
        flags { summary, transient }
        default {[ new BStatusNumeric() ]}
        slotfacets {[ BFacets.makeNumeric(UnitDatabase.getUnit("pounds per square inch"), 3) ]}

      outWetBulbTemp: BStatusNumeric
        flags { summary, transient }
        default {[ new BStatusNumeric() ]}

    }
    
    actions
    {
      calculate()
        flags{ hidden }
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.energy.BPsychrometric(191382564)1.0$ @*/
/* Generated Mon Sep 18 12:41:44 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "unitSelect"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>unitSelect</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#getUnitSelect
   * @see com.tridium.kitControl.energy.BPsychrometric#setUnitSelect
   */
  public static final Property unitSelect = newProperty(0, BEnglishMetric.english,null);
  
  /**
   * Get the <code>unitSelect</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#unitSelect
   */
  public BEnglishMetric getUnitSelect() { return (BEnglishMetric)get(unitSelect); }
  
  /**
   * Set the <code>unitSelect</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#unitSelect
   */
  public void setUnitSelect(BEnglishMetric v) { set(unitSelect,v,null); }

////////////////////////////////////////////////////////////////
// Property "temperatureFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#getTemperatureFacets
   * @see com.tridium.kitControl.energy.BPsychrometric#setTemperatureFacets
   */
  public static final Property temperatureFacets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1),null);
  
  /**
   * Get the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#temperatureFacets
   */
  public BFacets getTemperatureFacets() { return (BFacets)get(temperatureFacets); }
  
  /**
   * Set the <code>temperatureFacets</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#temperatureFacets
   */
  public void setTemperatureFacets(BFacets v) { set(temperatureFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "humidityFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>humidityFacets</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#getHumidityFacets
   * @see com.tridium.kitControl.energy.BPsychrometric#setHumidityFacets
   */
  public static final Property humidityFacets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("percent relative humidity"), 1),null);
  
  /**
   * Get the <code>humidityFacets</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#humidityFacets
   */
  public BFacets getHumidityFacets() { return (BFacets)get(humidityFacets); }
  
  /**
   * Set the <code>humidityFacets</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#humidityFacets
   */
  public void setHumidityFacets(BFacets v) { set(humidityFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "inTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inTemp</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#getInTemp
   * @see com.tridium.kitControl.energy.BPsychrometric#setInTemp
   */
  public static final Property inTemp = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inTemp</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#inTemp
   */
  public BStatusNumeric getInTemp() { return (BStatusNumeric)get(inTemp); }
  
  /**
   * Set the <code>inTemp</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#inTemp
   */
  public void setInTemp(BStatusNumeric v) { set(inTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "inHumidity"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inHumidity</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#getInHumidity
   * @see com.tridium.kitControl.energy.BPsychrometric#setInHumidity
   */
  public static final Property inHumidity = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>inHumidity</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#inHumidity
   */
  public BStatusNumeric getInHumidity() { return (BStatusNumeric)get(inHumidity); }
  
  /**
   * Set the <code>inHumidity</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#inHumidity
   */
  public void setInHumidity(BStatusNumeric v) { set(inHumidity,v,null); }

////////////////////////////////////////////////////////////////
// Property "outDewPoint"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outDewPoint</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#getOutDewPoint
   * @see com.tridium.kitControl.energy.BPsychrometric#setOutDewPoint
   */
  public static final Property outDewPoint = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusNumeric(),null);
  
  /**
   * Get the <code>outDewPoint</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#outDewPoint
   */
  public BStatusNumeric getOutDewPoint() { return (BStatusNumeric)get(outDewPoint); }
  
  /**
   * Set the <code>outDewPoint</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#outDewPoint
   */
  public void setOutDewPoint(BStatusNumeric v) { set(outDewPoint,v,null); }

////////////////////////////////////////////////////////////////
// Property "outEnthalpy"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#getOutEnthalpy
   * @see com.tridium.kitControl.energy.BPsychrometric#setOutEnthalpy
   */
  public static final Property outEnthalpy = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusNumeric(),BFacets.makeNumeric(UnitDatabase.getUnit("btu per pound"), 2) );
  
  /**
   * Get the <code>outEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#outEnthalpy
   */
  public BStatusNumeric getOutEnthalpy() { return (BStatusNumeric)get(outEnthalpy); }
  
  /**
   * Set the <code>outEnthalpy</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#outEnthalpy
   */
  public void setOutEnthalpy(BStatusNumeric v) { set(outEnthalpy,v,null); }

////////////////////////////////////////////////////////////////
// Property "outSatPress"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outSatPress</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#getOutSatPress
   * @see com.tridium.kitControl.energy.BPsychrometric#setOutSatPress
   */
  public static final Property outSatPress = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusNumeric(),BFacets.makeNumeric(UnitDatabase.getUnit("pounds per square inch"), 3) );
  
  /**
   * Get the <code>outSatPress</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#outSatPress
   */
  public BStatusNumeric getOutSatPress() { return (BStatusNumeric)get(outSatPress); }
  
  /**
   * Set the <code>outSatPress</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#outSatPress
   */
  public void setOutSatPress(BStatusNumeric v) { set(outSatPress,v,null); }

////////////////////////////////////////////////////////////////
// Property "outVaporPress"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outVaporPress</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#getOutVaporPress
   * @see com.tridium.kitControl.energy.BPsychrometric#setOutVaporPress
   */
  public static final Property outVaporPress = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusNumeric(),BFacets.makeNumeric(UnitDatabase.getUnit("pounds per square inch"), 3) );
  
  /**
   * Get the <code>outVaporPress</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#outVaporPress
   */
  public BStatusNumeric getOutVaporPress() { return (BStatusNumeric)get(outVaporPress); }
  
  /**
   * Set the <code>outVaporPress</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#outVaporPress
   */
  public void setOutVaporPress(BStatusNumeric v) { set(outVaporPress,v,null); }

////////////////////////////////////////////////////////////////
// Property "outWetBulbTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outWetBulbTemp</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#getOutWetBulbTemp
   * @see com.tridium.kitControl.energy.BPsychrometric#setOutWetBulbTemp
   */
  public static final Property outWetBulbTemp = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusNumeric(),null);
  
  /**
   * Get the <code>outWetBulbTemp</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#outWetBulbTemp
   */
  public BStatusNumeric getOutWetBulbTemp() { return (BStatusNumeric)get(outWetBulbTemp); }
  
  /**
   * Set the <code>outWetBulbTemp</code> property.
   * @see com.tridium.kitControl.energy.BPsychrometric#outWetBulbTemp
   */
  public void setOutWetBulbTemp(BStatusNumeric v) { set(outWetBulbTemp,v,null); }

////////////////////////////////////////////////////////////////
// Action "calculate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BPsychrometric#calculate()
   */
  public static final Action calculate = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BPsychrometric#calculate
   */
  public void calculate() { invoke(calculate,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPsychrometric.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Initialization  /  Cleanup
////////////////////////////////////////////////////////////////

  public void started()
    throws Exception
  {

    if(ticket != null)
      ticket.cancel();
    ticket = Clock.schedule(this, BRelTime.makeMinutes(1), calculate, null);

    super.started();
	  if( !Sys.atSteadyState() )
		  return;


  }

  public void stopped()
    throws Exception
  {
    if(ticket != null)
      ticket.cancel();
    super.stopped();
  }


  public void changed(Property property, Context context) 
  {
  	super.changed(property, context);
    if( !Sys.atSteadyState() || !isRunning() )
	    return;
    if( property.getName().startsWith("in") ||
        property.equals(unitSelect)            )
     doCalculate();
    if( property.equals(unitSelect))
    {
      isEnglish = getUnitSelect().equals(BEnglishMetric.english);
      int precision = getTemperatureFacets().geti(BFacets.PRECISION, 1);
      if(isEnglish)
        setTemperatureFacets(BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), precision));
      else
        setTemperatureFacets(BFacets.makeNumeric(UnitDatabase.getUnit("celsius"), precision));
    }

  }

  public BFacets getSlotFacets(Slot slot)
  {
    isEnglish = getUnitSelect().equals(BEnglishMetric.english);
    if(slot.equals(inTemp) ||
       slot.equals(outDewPoint) ||
       slot.equals(outWetBulbTemp)  )
    {
      return getTemperatureFacets();
    }
    
    else if(slot.equals(inHumidity) )
      return getHumidityFacets();
    else if(slot.equals(outEnthalpy))
    {
      if(isEnglish)
        return enthalpyEnglishFacets;
      else
        return enthalpyMetricFacets;
    }
    else if(slot.equals(outSatPress) ||
            slot.equals(outVaporPress)  )
    {
      if(isEnglish)
        return pressureEnglishFacets;
      else
        return pressureMetricFacets;
    }
    return super.getSlotFacets(slot);
  }

  public void atSteadyState()
  {
    doCalculate();
  }

  public void doCalculate()
  {
    isEnglish = getUnitSelect().equals(BEnglishMetric.english);
    float temp = getInTempEnglish();
    float RH   = (float)getInHumidity().getValue();
    BStatusNumeric dewPointValue    = new BStatusNumeric();
    BStatusNumeric enthalpyValue    = new BStatusNumeric();
    BStatusNumeric vaporPressValue  = new BStatusNumeric();
    BStatusNumeric wetBulbTempValue = new BStatusNumeric();
    BStatusNumeric satPressValue    = new BStatusNumeric();
    boolean tempAndRhValid = isTempValid() && isRHValid();
    if(tempAndRhValid)
    {
      dewPointValue   .setValue((double)Psychrometric.dewpointTemperature( temp, RH ));
      enthalpyValue   .setValue((double)Psychrometric.enthalpy( temp, RH ));
      vaporPressValue .setValue((double)Psychrometric.vaporPressure( temp, RH ));
      wetBulbTempValue.setValue((double)Psychrometric.wetbulbTemperature( temp, RH ));
    }
    else
    {
      dewPointValue   .setValue(Double.NaN);
      enthalpyValue   .setValue(Double.NaN);
      vaporPressValue .setValue(Double.NaN);
      wetBulbTempValue.setValue(Double.NaN);
    }
    dewPointValue   .setStatus(BStatus.makeFault(getOutDewPoint()   .getStatus(), !tempAndRhValid));
    enthalpyValue   .setStatus(BStatus.makeFault(getOutEnthalpy()   .getStatus(), !tempAndRhValid));
    vaporPressValue .setStatus(BStatus.makeFault(getOutVaporPress() .getStatus(), !tempAndRhValid));
    wetBulbTempValue.setStatus(BStatus.makeFault(getOutWetBulbTemp().getStatus(), !tempAndRhValid));


    // calculate saturation pressure from temperature
    if(isTempValid())
    {
      satPressValue.setValue((double)Psychrometric.saturationPressure( temp ));
    }
    else
    {
      satPressValue.setValue(Double.NaN);
    }
    satPressValue.setStatus(BStatus.makeFault(getOutSatPress().getStatus(), !isTempValid()));

    if(!isEnglish)  // then convert to metric
    {
      dewPointValue   .setValue( convertTemp    (dewPointValue   .getValue()) );
      enthalpyValue   .setValue( convertEnthalpy(enthalpyValue   .getValue()) );
      vaporPressValue .setValue( convertPress   (vaporPressValue .getValue()) );
      wetBulbTempValue.setValue( convertTemp    (wetBulbTempValue.getValue()) );
      satPressValue   .setValue( convertPress   (satPressValue   .getValue()) );

    }

    setOutDewPoint   (dewPointValue   );
    setOutEnthalpy   (enthalpyValue   );
    setOutVaporPress (vaporPressValue );
    setOutWetBulbTemp(wetBulbTempValue);
    setOutSatPress   (satPressValue   );
    //
  }


	private boolean isTempValid()
  {
    return getInTemp().getStatus().isValid() && Psychrometric.isTempValid(getInTempEnglish());
  }
  
	private boolean isRHValid()
  {
    return getInHumidity().getStatus().isValid() && Psychrometric.isRHValid((float)getInHumidity().getValue());
  }
  
  private float getInTempEnglish()
  {
    float inTempValue = (float)getInTemp().getValue();
    if(isEnglish)
      return inTempValue;
    return 1.8f * inTempValue +32;
  }

  private double convertTemp(double value)
  {
    if(Double.isNaN(value))
      return value;
    return (value - 32.0) * fiveNineths;
  }

  // 1 BTU/lb = 2.32600 kilojoules per kilogram
  // kJ/kg = (btu/lb - 7.68.152) * 2.326;
  private double convertEnthalpy(double value)
  {
    if(Double.isNaN(value))
      return value;
    return (value - 7.68152) * 2.32600;
  }

  // 1 psi = 0.00689475729 kPa 
  private double convertPress(double value)
  {
    if(Double.isNaN(value))
      return value;
    return value * 6.89475729 ;
  }

  private static double fiveNineths = 5.0/9.0;
  private static BFacets pressureEnglishFacets = BFacets.makeNumeric(UnitDatabase.getUnit("pounds per square inch"), 3);
  private static BFacets pressureMetricFacets  = BFacets.makeNumeric(UnitDatabase.getUnit("kilopascal")            , 3);
  private static BFacets enthalpyEnglishFacets = BFacets.makeNumeric(UnitDatabase.getUnit("btu per pound"      ), 3);
  private static BFacets enthalpyMetricFacets  = BFacets.makeNumeric(UnitDatabase.getUnit("kilojoule per kilogram"), 3);
////////////////////////////////////////////////////////////////
// local variables
////////////////////////////////////////////////////////////////

  Clock.Ticket ticket = null;
  private boolean isEnglish = true;

}