/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.energy;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.util.Lexicon;


/** Electrictial Demand limit object
 *   On each new minute, this object predicts a demand average of a sliding window
 *   interval (the length of which is user defined) by combining projected usage
 *   with historical samplings and averaging over the interval. The user controls
 *  the assumed position (in percentage) within the sliding window. The user may
 *  divide the day into three sections, each with its own demand limit. The projected
 *   demand is compared to the limit for the current time-of-day to decide whether
 *  "shedding" or "reloading" loads is appropriate in a fixed priority . The time,
 *  date and value of new demand limits are save for both this month and the previous
 *  month.
 *
 *  This object provides an output that can be linked to the Shed Control object which
 *  actually performs the equipment control.
 *
 *  A message is output with each calculation to provide an indication of the object's
 *  calculated result or recommendation.
 *
 *  Execution of this object can be enabled or disabled (default) either automatically
 *  or manually (via right click).
 *
 * 
 * @author    Andy Saunders
 * @creation  11 Jan 2005
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public class BElectricalDemandLimit
  extends BComponent
{ 
  /*-
  
  class BElectricalDemandLimit
  {
    properties
    { 
      //
      // Inputs
      //
      
      predictionEnabled: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean(true) ]}
        
      powerInput: BStatusNumeric
        flags { transient, summary }
        default {[ new BStatusNumeric(0.0) ]}
        
      //
      // Outputs
      //
      message: String 		// operator notification message
        flags { transient }
        default {[ new String("") ]}
        slotfacets{[BFacets.make(BFacets.MULTI_LINE, true)]}
        
      shedOut: BStatusNumeric		// number of levels shed
        flags { transient, summary }
        default {[ new BStatusNumeric() ]}
        
      //
      // Properties
      //

      billingStartDay: int		// This month's peak values are moved to previous month's values at 12:00 on this day of the month
        default {[ 1 ]}
        
      demandInterval: int		// length of demand interval (default is 15 minutes)
        default {[ 15 ]}
        
      percentIntervalElapsed: int	// percent of demand period that is assumed to have elapsed for calculating demandAverage (default is 75%)
        default {[ 75 ]}
        
      rotateLevel: int		// identifies the first rotating priority level
        default {[ 0 ]}

      demandLimitingDeadband: float	// deadband used in determining whether loads can be restored
        default {[ 0.0f ]}

      demandLimitPeriod1: float	// limit for first demand period determined by demandPeriod1Start
        default {[ 0.0f ]}
        
      demandLimitPeriod2: float 	// limit for second demand period determined by demandPeriod2Start
        default {[ 0.0f ]}
        
      demandLimitPeriod3: float	// limit for third demand period determined by demandPeriod3Start
        default {[ 0.0f ]}

      demandPeriod1Start: BRelTime	// beginning of first demand period
        default {[ BRelTime.make(0l) ]}
        
      demandPeriod2Start: BRelTime	// beginning of first demand period
        default {[ BRelTime.make(0l) ]}
    
      demandPeriod3Start: BRelTime	// beginning of first demand period
        default {[ BRelTime.make(0l) ]}
    
      powerShedLevel1: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel2: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
    
      powerShedLevel3: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
    
      powerShedLevel4: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
    
      powerShedLevel5: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
    
      powerShedLevel6: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
    
      powerShedLevel7: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
    
      powerShedLevel8: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
    
      powerShedLevel9: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
    
      powerShedLevel10: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
    
      powerShedLevel11: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
    
      powerShedLevel12: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
    
      powerShedLevel13: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel14: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel15: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel16: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel17: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel18: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel19: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel20: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel21: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel22: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel23: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel24: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel25: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel26: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel27: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel28: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel29: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel30: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel31: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      powerShedLevel32: float		// Beginning of table for power to be shed/reloaded at each level
        default {[ 0.0f ]}
      
      thisMonthDemandPeriod1Peak: float			// this month's peak demand for demand period 1
        flags { readonly }
        default {[ 0.0f ]}
        
      thisMonthDemandPeriod1PeakTime: BAbsTime		// date and time of this month's peak demand for demand period 1
        flags { readonly }
        default {[ BAbsTime.NULL ]}
        
      thisMonthDemandPeriod2Peak: float			// this month's peak demand for demand period 1
        flags { readonly }
        default {[ 0.0f ]}
        
      thisMonthDemandPeriod2PeakTime: BAbsTime		// date and time of this month's peak demand for demand period 1
        flags { readonly }
        default {[ BAbsTime.NULL ]}
        
      thisMonthDemandPeriod3Peak: float			// this month's peak demand for demand period 1
        flags { readonly }
        default {[ 0.0f ]}
        
      thisMonthDemandPeriod3PeakTime: BAbsTime		// date and time of this month's peak demand for demand period 1
        flags { readonly }
        default {[ BAbsTime.NULL ]}
        
      previousMonthDemandPeriod1Peak: float			// this month's peak demand for demand period 1
        flags { readonly }
        default {[ 0.0f ]}
        
      previousMonthDemandPeriod1PeakTime: BAbsTime		// date and time of this month's peak demand for demand period 1
        flags { readonly }
        default {[ BAbsTime.NULL ]}
        
      previousMonthDemandPeriod2Peak: float			// this month's peak demand for demand period 1
        flags { readonly }
        default {[ 0.0f ]}
        
      previousMonthDemandPeriod2PeakTime: BAbsTime		// date and time of this month's peak demand for demand period 1
        flags { readonly }
        default {[ BAbsTime.NULL ]}
        
      previousMonthDemandPeriod3Peak: float			// this month's peak demand for demand period 1
        flags { readonly }
        default {[ 0.0f ]}
        
      previousMonthDemandPeriod3PeakTime: BAbsTime		// date and time of this month's peak demand for demand period 1
        flags { readonly }
        default {[ BAbsTime.NULL ]}
        
      //
      // Transient properties
      //
      projectedDemandAverage: float		// projected demandAverage
        flags { transient, readonly }
        default {[ 0.0f ]}
        
      maxShedLevel: int 	// maximum demand level (default is 32)
        flags { transient, readonly }
        default {[ 32 ]}
      
    }
    
    actions
    {
      calculate()
        flags{ hidden }
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.energy.BElectricalDemandLimit(2511119903)1.0$ @*/
/* Generated Wed Jan 14 11:28:36 EST 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "predictionEnabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>predictionEnabled</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPredictionEnabled
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPredictionEnabled
   */
  public static final Property predictionEnabled = newProperty(Flags.SUMMARY, new BStatusBoolean(true),null);
  
  /**
   * Get the <code>predictionEnabled</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#predictionEnabled
   */
  public BStatusBoolean getPredictionEnabled() { return (BStatusBoolean)get(predictionEnabled); }
  
  /**
   * Set the <code>predictionEnabled</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#predictionEnabled
   */
  public void setPredictionEnabled(BStatusBoolean v) { set(predictionEnabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerInput"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerInput</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerInput
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerInput
   */
  public static final Property powerInput = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(0.0),null);
  
  /**
   * Get the <code>powerInput</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerInput
   */
  public BStatusNumeric getPowerInput() { return (BStatusNumeric)get(powerInput); }
  
  /**
   * Set the <code>powerInput</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerInput
   */
  public void setPowerInput(BStatusNumeric v) { set(powerInput,v,null); }

////////////////////////////////////////////////////////////////
// Property "message"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>message</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getMessage
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setMessage
   */
  public static final Property message = newProperty(Flags.TRANSIENT, new String(""),BFacets.make(BFacets.MULTI_LINE, true));
  
  /**
   * Get the <code>message</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#message
   */
  public String getMessage() { return getString(message); }
  
  /**
   * Set the <code>message</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#message
   */
  public void setMessage(String v) { setString(message,v,null); }

////////////////////////////////////////////////////////////////
// Property "shedOut"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>shedOut</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getShedOut
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setShedOut
   */
  public static final Property shedOut = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>shedOut</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#shedOut
   */
  public BStatusNumeric getShedOut() { return (BStatusNumeric)get(shedOut); }
  
  /**
   * Set the <code>shedOut</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#shedOut
   */
  public void setShedOut(BStatusNumeric v) { set(shedOut,v,null); }

////////////////////////////////////////////////////////////////
// Property "billingStartDay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>billingStartDay</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getBillingStartDay
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setBillingStartDay
   */
  public static final Property billingStartDay = newProperty(0, 1,null);
  
  /**
   * Get the <code>billingStartDay</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#billingStartDay
   */
  public int getBillingStartDay() { return getInt(billingStartDay); }
  
  /**
   * Set the <code>billingStartDay</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#billingStartDay
   */
  public void setBillingStartDay(int v) { setInt(billingStartDay,v,null); }

////////////////////////////////////////////////////////////////
// Property "demandInterval"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demandInterval</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getDemandInterval
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setDemandInterval
   */
  public static final Property demandInterval = newProperty(0, 15,null);
  
  /**
   * Get the <code>demandInterval</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandInterval
   */
  public int getDemandInterval() { return getInt(demandInterval); }
  
  /**
   * Set the <code>demandInterval</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandInterval
   */
  public void setDemandInterval(int v) { setInt(demandInterval,v,null); }

////////////////////////////////////////////////////////////////
// Property "percentIntervalElapsed"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>percentIntervalElapsed</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPercentIntervalElapsed
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPercentIntervalElapsed
   */
  public static final Property percentIntervalElapsed = newProperty(0, 75,null);
  
  /**
   * Get the <code>percentIntervalElapsed</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#percentIntervalElapsed
   */
  public int getPercentIntervalElapsed() { return getInt(percentIntervalElapsed); }
  
  /**
   * Set the <code>percentIntervalElapsed</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#percentIntervalElapsed
   */
  public void setPercentIntervalElapsed(int v) { setInt(percentIntervalElapsed,v,null); }

////////////////////////////////////////////////////////////////
// Property "rotateLevel"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>rotateLevel</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getRotateLevel
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setRotateLevel
   */
  public static final Property rotateLevel = newProperty(0, 0,null);
  
  /**
   * Get the <code>rotateLevel</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#rotateLevel
   */
  public int getRotateLevel() { return getInt(rotateLevel); }
  
  /**
   * Set the <code>rotateLevel</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#rotateLevel
   */
  public void setRotateLevel(int v) { setInt(rotateLevel,v,null); }

////////////////////////////////////////////////////////////////
// Property "demandLimitingDeadband"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demandLimitingDeadband</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getDemandLimitingDeadband
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setDemandLimitingDeadband
   */
  public static final Property demandLimitingDeadband = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>demandLimitingDeadband</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandLimitingDeadband
   */
  public float getDemandLimitingDeadband() { return getFloat(demandLimitingDeadband); }
  
  /**
   * Set the <code>demandLimitingDeadband</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandLimitingDeadband
   */
  public void setDemandLimitingDeadband(float v) { setFloat(demandLimitingDeadband,v,null); }

////////////////////////////////////////////////////////////////
// Property "demandLimitPeriod1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demandLimitPeriod1</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getDemandLimitPeriod1
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setDemandLimitPeriod1
   */
  public static final Property demandLimitPeriod1 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>demandLimitPeriod1</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandLimitPeriod1
   */
  public float getDemandLimitPeriod1() { return getFloat(demandLimitPeriod1); }
  
  /**
   * Set the <code>demandLimitPeriod1</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandLimitPeriod1
   */
  public void setDemandLimitPeriod1(float v) { setFloat(demandLimitPeriod1,v,null); }

////////////////////////////////////////////////////////////////
// Property "demandLimitPeriod2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demandLimitPeriod2</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getDemandLimitPeriod2
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setDemandLimitPeriod2
   */
  public static final Property demandLimitPeriod2 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>demandLimitPeriod2</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandLimitPeriod2
   */
  public float getDemandLimitPeriod2() { return getFloat(demandLimitPeriod2); }
  
  /**
   * Set the <code>demandLimitPeriod2</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandLimitPeriod2
   */
  public void setDemandLimitPeriod2(float v) { setFloat(demandLimitPeriod2,v,null); }

////////////////////////////////////////////////////////////////
// Property "demandLimitPeriod3"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demandLimitPeriod3</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getDemandLimitPeriod3
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setDemandLimitPeriod3
   */
  public static final Property demandLimitPeriod3 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>demandLimitPeriod3</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandLimitPeriod3
   */
  public float getDemandLimitPeriod3() { return getFloat(demandLimitPeriod3); }
  
  /**
   * Set the <code>demandLimitPeriod3</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandLimitPeriod3
   */
  public void setDemandLimitPeriod3(float v) { setFloat(demandLimitPeriod3,v,null); }

////////////////////////////////////////////////////////////////
// Property "demandPeriod1Start"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demandPeriod1Start</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getDemandPeriod1Start
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setDemandPeriod1Start
   */
  public static final Property demandPeriod1Start = newProperty(0, BRelTime.make(0l),null);
  
  /**
   * Get the <code>demandPeriod1Start</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandPeriod1Start
   */
  public BRelTime getDemandPeriod1Start() { return (BRelTime)get(demandPeriod1Start); }
  
  /**
   * Set the <code>demandPeriod1Start</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandPeriod1Start
   */
  public void setDemandPeriod1Start(BRelTime v) { set(demandPeriod1Start,v,null); }

////////////////////////////////////////////////////////////////
// Property "demandPeriod2Start"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demandPeriod2Start</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getDemandPeriod2Start
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setDemandPeriod2Start
   */
  public static final Property demandPeriod2Start = newProperty(0, BRelTime.make(0l),null);
  
  /**
   * Get the <code>demandPeriod2Start</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandPeriod2Start
   */
  public BRelTime getDemandPeriod2Start() { return (BRelTime)get(demandPeriod2Start); }
  
  /**
   * Set the <code>demandPeriod2Start</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandPeriod2Start
   */
  public void setDemandPeriod2Start(BRelTime v) { set(demandPeriod2Start,v,null); }

////////////////////////////////////////////////////////////////
// Property "demandPeriod3Start"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>demandPeriod3Start</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getDemandPeriod3Start
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setDemandPeriod3Start
   */
  public static final Property demandPeriod3Start = newProperty(0, BRelTime.make(0l),null);
  
  /**
   * Get the <code>demandPeriod3Start</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandPeriod3Start
   */
  public BRelTime getDemandPeriod3Start() { return (BRelTime)get(demandPeriod3Start); }
  
  /**
   * Set the <code>demandPeriod3Start</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#demandPeriod3Start
   */
  public void setDemandPeriod3Start(BRelTime v) { set(demandPeriod3Start,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel1"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel1</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel1
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel1
   */
  public static final Property powerShedLevel1 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel1</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel1
   */
  public float getPowerShedLevel1() { return getFloat(powerShedLevel1); }
  
  /**
   * Set the <code>powerShedLevel1</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel1
   */
  public void setPowerShedLevel1(float v) { setFloat(powerShedLevel1,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel2"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel2</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel2
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel2
   */
  public static final Property powerShedLevel2 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel2</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel2
   */
  public float getPowerShedLevel2() { return getFloat(powerShedLevel2); }
  
  /**
   * Set the <code>powerShedLevel2</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel2
   */
  public void setPowerShedLevel2(float v) { setFloat(powerShedLevel2,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel3"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel3</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel3
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel3
   */
  public static final Property powerShedLevel3 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel3</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel3
   */
  public float getPowerShedLevel3() { return getFloat(powerShedLevel3); }
  
  /**
   * Set the <code>powerShedLevel3</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel3
   */
  public void setPowerShedLevel3(float v) { setFloat(powerShedLevel3,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel4"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel4</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel4
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel4
   */
  public static final Property powerShedLevel4 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel4</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel4
   */
  public float getPowerShedLevel4() { return getFloat(powerShedLevel4); }
  
  /**
   * Set the <code>powerShedLevel4</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel4
   */
  public void setPowerShedLevel4(float v) { setFloat(powerShedLevel4,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel5"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel5</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel5
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel5
   */
  public static final Property powerShedLevel5 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel5</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel5
   */
  public float getPowerShedLevel5() { return getFloat(powerShedLevel5); }
  
  /**
   * Set the <code>powerShedLevel5</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel5
   */
  public void setPowerShedLevel5(float v) { setFloat(powerShedLevel5,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel6"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel6</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel6
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel6
   */
  public static final Property powerShedLevel6 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel6</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel6
   */
  public float getPowerShedLevel6() { return getFloat(powerShedLevel6); }
  
  /**
   * Set the <code>powerShedLevel6</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel6
   */
  public void setPowerShedLevel6(float v) { setFloat(powerShedLevel6,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel7"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel7</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel7
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel7
   */
  public static final Property powerShedLevel7 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel7</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel7
   */
  public float getPowerShedLevel7() { return getFloat(powerShedLevel7); }
  
  /**
   * Set the <code>powerShedLevel7</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel7
   */
  public void setPowerShedLevel7(float v) { setFloat(powerShedLevel7,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel8"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel8</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel8
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel8
   */
  public static final Property powerShedLevel8 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel8</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel8
   */
  public float getPowerShedLevel8() { return getFloat(powerShedLevel8); }
  
  /**
   * Set the <code>powerShedLevel8</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel8
   */
  public void setPowerShedLevel8(float v) { setFloat(powerShedLevel8,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel9"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel9</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel9
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel9
   */
  public static final Property powerShedLevel9 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel9</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel9
   */
  public float getPowerShedLevel9() { return getFloat(powerShedLevel9); }
  
  /**
   * Set the <code>powerShedLevel9</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel9
   */
  public void setPowerShedLevel9(float v) { setFloat(powerShedLevel9,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel10"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel10</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel10
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel10
   */
  public static final Property powerShedLevel10 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel10</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel10
   */
  public float getPowerShedLevel10() { return getFloat(powerShedLevel10); }
  
  /**
   * Set the <code>powerShedLevel10</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel10
   */
  public void setPowerShedLevel10(float v) { setFloat(powerShedLevel10,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel11"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel11</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel11
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel11
   */
  public static final Property powerShedLevel11 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel11</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel11
   */
  public float getPowerShedLevel11() { return getFloat(powerShedLevel11); }
  
  /**
   * Set the <code>powerShedLevel11</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel11
   */
  public void setPowerShedLevel11(float v) { setFloat(powerShedLevel11,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel12"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel12</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel12
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel12
   */
  public static final Property powerShedLevel12 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel12</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel12
   */
  public float getPowerShedLevel12() { return getFloat(powerShedLevel12); }
  
  /**
   * Set the <code>powerShedLevel12</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel12
   */
  public void setPowerShedLevel12(float v) { setFloat(powerShedLevel12,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel13"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel13</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel13
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel13
   */
  public static final Property powerShedLevel13 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel13</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel13
   */
  public float getPowerShedLevel13() { return getFloat(powerShedLevel13); }
  
  /**
   * Set the <code>powerShedLevel13</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel13
   */
  public void setPowerShedLevel13(float v) { setFloat(powerShedLevel13,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel14"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel14</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel14
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel14
   */
  public static final Property powerShedLevel14 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel14</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel14
   */
  public float getPowerShedLevel14() { return getFloat(powerShedLevel14); }
  
  /**
   * Set the <code>powerShedLevel14</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel14
   */
  public void setPowerShedLevel14(float v) { setFloat(powerShedLevel14,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel15"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel15</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel15
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel15
   */
  public static final Property powerShedLevel15 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel15</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel15
   */
  public float getPowerShedLevel15() { return getFloat(powerShedLevel15); }
  
  /**
   * Set the <code>powerShedLevel15</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel15
   */
  public void setPowerShedLevel15(float v) { setFloat(powerShedLevel15,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel16"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel16</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel16
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel16
   */
  public static final Property powerShedLevel16 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel16</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel16
   */
  public float getPowerShedLevel16() { return getFloat(powerShedLevel16); }
  
  /**
   * Set the <code>powerShedLevel16</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel16
   */
  public void setPowerShedLevel16(float v) { setFloat(powerShedLevel16,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel17"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel17</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel17
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel17
   */
  public static final Property powerShedLevel17 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel17</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel17
   */
  public float getPowerShedLevel17() { return getFloat(powerShedLevel17); }
  
  /**
   * Set the <code>powerShedLevel17</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel17
   */
  public void setPowerShedLevel17(float v) { setFloat(powerShedLevel17,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel18"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel18</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel18
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel18
   */
  public static final Property powerShedLevel18 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel18</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel18
   */
  public float getPowerShedLevel18() { return getFloat(powerShedLevel18); }
  
  /**
   * Set the <code>powerShedLevel18</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel18
   */
  public void setPowerShedLevel18(float v) { setFloat(powerShedLevel18,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel19"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel19</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel19
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel19
   */
  public static final Property powerShedLevel19 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel19</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel19
   */
  public float getPowerShedLevel19() { return getFloat(powerShedLevel19); }
  
  /**
   * Set the <code>powerShedLevel19</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel19
   */
  public void setPowerShedLevel19(float v) { setFloat(powerShedLevel19,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel20"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel20</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel20
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel20
   */
  public static final Property powerShedLevel20 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel20</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel20
   */
  public float getPowerShedLevel20() { return getFloat(powerShedLevel20); }
  
  /**
   * Set the <code>powerShedLevel20</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel20
   */
  public void setPowerShedLevel20(float v) { setFloat(powerShedLevel20,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel21"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel21</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel21
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel21
   */
  public static final Property powerShedLevel21 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel21</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel21
   */
  public float getPowerShedLevel21() { return getFloat(powerShedLevel21); }
  
  /**
   * Set the <code>powerShedLevel21</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel21
   */
  public void setPowerShedLevel21(float v) { setFloat(powerShedLevel21,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel22"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel22</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel22
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel22
   */
  public static final Property powerShedLevel22 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel22</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel22
   */
  public float getPowerShedLevel22() { return getFloat(powerShedLevel22); }
  
  /**
   * Set the <code>powerShedLevel22</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel22
   */
  public void setPowerShedLevel22(float v) { setFloat(powerShedLevel22,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel23"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel23</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel23
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel23
   */
  public static final Property powerShedLevel23 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel23</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel23
   */
  public float getPowerShedLevel23() { return getFloat(powerShedLevel23); }
  
  /**
   * Set the <code>powerShedLevel23</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel23
   */
  public void setPowerShedLevel23(float v) { setFloat(powerShedLevel23,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel24"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel24</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel24
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel24
   */
  public static final Property powerShedLevel24 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel24</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel24
   */
  public float getPowerShedLevel24() { return getFloat(powerShedLevel24); }
  
  /**
   * Set the <code>powerShedLevel24</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel24
   */
  public void setPowerShedLevel24(float v) { setFloat(powerShedLevel24,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel25"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel25</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel25
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel25
   */
  public static final Property powerShedLevel25 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel25</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel25
   */
  public float getPowerShedLevel25() { return getFloat(powerShedLevel25); }
  
  /**
   * Set the <code>powerShedLevel25</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel25
   */
  public void setPowerShedLevel25(float v) { setFloat(powerShedLevel25,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel26"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel26</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel26
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel26
   */
  public static final Property powerShedLevel26 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel26</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel26
   */
  public float getPowerShedLevel26() { return getFloat(powerShedLevel26); }
  
  /**
   * Set the <code>powerShedLevel26</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel26
   */
  public void setPowerShedLevel26(float v) { setFloat(powerShedLevel26,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel27"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel27</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel27
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel27
   */
  public static final Property powerShedLevel27 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel27</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel27
   */
  public float getPowerShedLevel27() { return getFloat(powerShedLevel27); }
  
  /**
   * Set the <code>powerShedLevel27</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel27
   */
  public void setPowerShedLevel27(float v) { setFloat(powerShedLevel27,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel28"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel28</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel28
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel28
   */
  public static final Property powerShedLevel28 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel28</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel28
   */
  public float getPowerShedLevel28() { return getFloat(powerShedLevel28); }
  
  /**
   * Set the <code>powerShedLevel28</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel28
   */
  public void setPowerShedLevel28(float v) { setFloat(powerShedLevel28,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel29"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel29</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel29
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel29
   */
  public static final Property powerShedLevel29 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel29</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel29
   */
  public float getPowerShedLevel29() { return getFloat(powerShedLevel29); }
  
  /**
   * Set the <code>powerShedLevel29</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel29
   */
  public void setPowerShedLevel29(float v) { setFloat(powerShedLevel29,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel30"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel30</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel30
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel30
   */
  public static final Property powerShedLevel30 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel30</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel30
   */
  public float getPowerShedLevel30() { return getFloat(powerShedLevel30); }
  
  /**
   * Set the <code>powerShedLevel30</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel30
   */
  public void setPowerShedLevel30(float v) { setFloat(powerShedLevel30,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel31"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel31</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel31
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel31
   */
  public static final Property powerShedLevel31 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel31</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel31
   */
  public float getPowerShedLevel31() { return getFloat(powerShedLevel31); }
  
  /**
   * Set the <code>powerShedLevel31</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel31
   */
  public void setPowerShedLevel31(float v) { setFloat(powerShedLevel31,v,null); }

////////////////////////////////////////////////////////////////
// Property "powerShedLevel32"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>powerShedLevel32</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPowerShedLevel32
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPowerShedLevel32
   */
  public static final Property powerShedLevel32 = newProperty(0, 0.0f,null);
  
  /**
   * Get the <code>powerShedLevel32</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel32
   */
  public float getPowerShedLevel32() { return getFloat(powerShedLevel32); }
  
  /**
   * Set the <code>powerShedLevel32</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#powerShedLevel32
   */
  public void setPowerShedLevel32(float v) { setFloat(powerShedLevel32,v,null); }

////////////////////////////////////////////////////////////////
// Property "thisMonthDemandPeriod1Peak"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>thisMonthDemandPeriod1Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getThisMonthDemandPeriod1Peak
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setThisMonthDemandPeriod1Peak
   */
  public static final Property thisMonthDemandPeriod1Peak = newProperty(Flags.READONLY, 0.0f,null);
  
  /**
   * Get the <code>thisMonthDemandPeriod1Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod1Peak
   */
  public float getThisMonthDemandPeriod1Peak() { return getFloat(thisMonthDemandPeriod1Peak); }
  
  /**
   * Set the <code>thisMonthDemandPeriod1Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod1Peak
   */
  public void setThisMonthDemandPeriod1Peak(float v) { setFloat(thisMonthDemandPeriod1Peak,v,null); }

////////////////////////////////////////////////////////////////
// Property "thisMonthDemandPeriod1PeakTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>thisMonthDemandPeriod1PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getThisMonthDemandPeriod1PeakTime
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setThisMonthDemandPeriod1PeakTime
   */
  public static final Property thisMonthDemandPeriod1PeakTime = newProperty(Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>thisMonthDemandPeriod1PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod1PeakTime
   */
  public BAbsTime getThisMonthDemandPeriod1PeakTime() { return (BAbsTime)get(thisMonthDemandPeriod1PeakTime); }
  
  /**
   * Set the <code>thisMonthDemandPeriod1PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod1PeakTime
   */
  public void setThisMonthDemandPeriod1PeakTime(BAbsTime v) { set(thisMonthDemandPeriod1PeakTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "thisMonthDemandPeriod2Peak"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>thisMonthDemandPeriod2Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getThisMonthDemandPeriod2Peak
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setThisMonthDemandPeriod2Peak
   */
  public static final Property thisMonthDemandPeriod2Peak = newProperty(Flags.READONLY, 0.0f,null);
  
  /**
   * Get the <code>thisMonthDemandPeriod2Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod2Peak
   */
  public float getThisMonthDemandPeriod2Peak() { return getFloat(thisMonthDemandPeriod2Peak); }
  
  /**
   * Set the <code>thisMonthDemandPeriod2Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod2Peak
   */
  public void setThisMonthDemandPeriod2Peak(float v) { setFloat(thisMonthDemandPeriod2Peak,v,null); }

////////////////////////////////////////////////////////////////
// Property "thisMonthDemandPeriod2PeakTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>thisMonthDemandPeriod2PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getThisMonthDemandPeriod2PeakTime
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setThisMonthDemandPeriod2PeakTime
   */
  public static final Property thisMonthDemandPeriod2PeakTime = newProperty(Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>thisMonthDemandPeriod2PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod2PeakTime
   */
  public BAbsTime getThisMonthDemandPeriod2PeakTime() { return (BAbsTime)get(thisMonthDemandPeriod2PeakTime); }
  
  /**
   * Set the <code>thisMonthDemandPeriod2PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod2PeakTime
   */
  public void setThisMonthDemandPeriod2PeakTime(BAbsTime v) { set(thisMonthDemandPeriod2PeakTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "thisMonthDemandPeriod3Peak"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>thisMonthDemandPeriod3Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getThisMonthDemandPeriod3Peak
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setThisMonthDemandPeriod3Peak
   */
  public static final Property thisMonthDemandPeriod3Peak = newProperty(Flags.READONLY, 0.0f,null);
  
  /**
   * Get the <code>thisMonthDemandPeriod3Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod3Peak
   */
  public float getThisMonthDemandPeriod3Peak() { return getFloat(thisMonthDemandPeriod3Peak); }
  
  /**
   * Set the <code>thisMonthDemandPeriod3Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod3Peak
   */
  public void setThisMonthDemandPeriod3Peak(float v) { setFloat(thisMonthDemandPeriod3Peak,v,null); }

////////////////////////////////////////////////////////////////
// Property "thisMonthDemandPeriod3PeakTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>thisMonthDemandPeriod3PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getThisMonthDemandPeriod3PeakTime
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setThisMonthDemandPeriod3PeakTime
   */
  public static final Property thisMonthDemandPeriod3PeakTime = newProperty(Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>thisMonthDemandPeriod3PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod3PeakTime
   */
  public BAbsTime getThisMonthDemandPeriod3PeakTime() { return (BAbsTime)get(thisMonthDemandPeriod3PeakTime); }
  
  /**
   * Set the <code>thisMonthDemandPeriod3PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#thisMonthDemandPeriod3PeakTime
   */
  public void setThisMonthDemandPeriod3PeakTime(BAbsTime v) { set(thisMonthDemandPeriod3PeakTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "previousMonthDemandPeriod1Peak"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>previousMonthDemandPeriod1Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPreviousMonthDemandPeriod1Peak
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPreviousMonthDemandPeriod1Peak
   */
  public static final Property previousMonthDemandPeriod1Peak = newProperty(Flags.READONLY, 0.0f,null);
  
  /**
   * Get the <code>previousMonthDemandPeriod1Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod1Peak
   */
  public float getPreviousMonthDemandPeriod1Peak() { return getFloat(previousMonthDemandPeriod1Peak); }
  
  /**
   * Set the <code>previousMonthDemandPeriod1Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod1Peak
   */
  public void setPreviousMonthDemandPeriod1Peak(float v) { setFloat(previousMonthDemandPeriod1Peak,v,null); }

////////////////////////////////////////////////////////////////
// Property "previousMonthDemandPeriod1PeakTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>previousMonthDemandPeriod1PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPreviousMonthDemandPeriod1PeakTime
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPreviousMonthDemandPeriod1PeakTime
   */
  public static final Property previousMonthDemandPeriod1PeakTime = newProperty(Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>previousMonthDemandPeriod1PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod1PeakTime
   */
  public BAbsTime getPreviousMonthDemandPeriod1PeakTime() { return (BAbsTime)get(previousMonthDemandPeriod1PeakTime); }
  
  /**
   * Set the <code>previousMonthDemandPeriod1PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod1PeakTime
   */
  public void setPreviousMonthDemandPeriod1PeakTime(BAbsTime v) { set(previousMonthDemandPeriod1PeakTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "previousMonthDemandPeriod2Peak"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>previousMonthDemandPeriod2Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPreviousMonthDemandPeriod2Peak
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPreviousMonthDemandPeriod2Peak
   */
  public static final Property previousMonthDemandPeriod2Peak = newProperty(Flags.READONLY, 0.0f,null);
  
  /**
   * Get the <code>previousMonthDemandPeriod2Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod2Peak
   */
  public float getPreviousMonthDemandPeriod2Peak() { return getFloat(previousMonthDemandPeriod2Peak); }
  
  /**
   * Set the <code>previousMonthDemandPeriod2Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod2Peak
   */
  public void setPreviousMonthDemandPeriod2Peak(float v) { setFloat(previousMonthDemandPeriod2Peak,v,null); }

////////////////////////////////////////////////////////////////
// Property "previousMonthDemandPeriod2PeakTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>previousMonthDemandPeriod2PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPreviousMonthDemandPeriod2PeakTime
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPreviousMonthDemandPeriod2PeakTime
   */
  public static final Property previousMonthDemandPeriod2PeakTime = newProperty(Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>previousMonthDemandPeriod2PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod2PeakTime
   */
  public BAbsTime getPreviousMonthDemandPeriod2PeakTime() { return (BAbsTime)get(previousMonthDemandPeriod2PeakTime); }
  
  /**
   * Set the <code>previousMonthDemandPeriod2PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod2PeakTime
   */
  public void setPreviousMonthDemandPeriod2PeakTime(BAbsTime v) { set(previousMonthDemandPeriod2PeakTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "previousMonthDemandPeriod3Peak"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>previousMonthDemandPeriod3Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPreviousMonthDemandPeriod3Peak
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPreviousMonthDemandPeriod3Peak
   */
  public static final Property previousMonthDemandPeriod3Peak = newProperty(Flags.READONLY, 0.0f,null);
  
  /**
   * Get the <code>previousMonthDemandPeriod3Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod3Peak
   */
  public float getPreviousMonthDemandPeriod3Peak() { return getFloat(previousMonthDemandPeriod3Peak); }
  
  /**
   * Set the <code>previousMonthDemandPeriod3Peak</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod3Peak
   */
  public void setPreviousMonthDemandPeriod3Peak(float v) { setFloat(previousMonthDemandPeriod3Peak,v,null); }

////////////////////////////////////////////////////////////////
// Property "previousMonthDemandPeriod3PeakTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>previousMonthDemandPeriod3PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getPreviousMonthDemandPeriod3PeakTime
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setPreviousMonthDemandPeriod3PeakTime
   */
  public static final Property previousMonthDemandPeriod3PeakTime = newProperty(Flags.READONLY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>previousMonthDemandPeriod3PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod3PeakTime
   */
  public BAbsTime getPreviousMonthDemandPeriod3PeakTime() { return (BAbsTime)get(previousMonthDemandPeriod3PeakTime); }
  
  /**
   * Set the <code>previousMonthDemandPeriod3PeakTime</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#previousMonthDemandPeriod3PeakTime
   */
  public void setPreviousMonthDemandPeriod3PeakTime(BAbsTime v) { set(previousMonthDemandPeriod3PeakTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "projectedDemandAverage"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>projectedDemandAverage</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getProjectedDemandAverage
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setProjectedDemandAverage
   */
  public static final Property projectedDemandAverage = newProperty(Flags.TRANSIENT|Flags.READONLY, 0.0f,null);
  
  /**
   * Get the <code>projectedDemandAverage</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#projectedDemandAverage
   */
  public float getProjectedDemandAverage() { return getFloat(projectedDemandAverage); }
  
  /**
   * Set the <code>projectedDemandAverage</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#projectedDemandAverage
   */
  public void setProjectedDemandAverage(float v) { setFloat(projectedDemandAverage,v,null); }

////////////////////////////////////////////////////////////////
// Property "maxShedLevel"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>maxShedLevel</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#getMaxShedLevel
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#setMaxShedLevel
   */
  public static final Property maxShedLevel = newProperty(Flags.TRANSIENT|Flags.READONLY, 32,null);
  
  /**
   * Get the <code>maxShedLevel</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#maxShedLevel
   */
  public int getMaxShedLevel() { return getInt(maxShedLevel); }
  
  /**
   * Set the <code>maxShedLevel</code> property.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#maxShedLevel
   */
  public void setMaxShedLevel(int v) { setInt(maxShedLevel,v,null); }

////////////////////////////////////////////////////////////////
// Action "calculate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#calculate()
   */
  public static final Action calculate = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BElectricalDemandLimit#calculate
   */
  public void calculate() { invoke(calculate,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BElectricalDemandLimit.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Initialization  /  Cleanup
////////////////////////////////////////////////////////////////

  public void started()
    throws Exception
  {

    if(ticket != null)
      ticket.cancel();
    ticket = Clock.schedule(this, BRelTime.makeMinutes(1), calculate, null);

    super.started();
	  if( !Sys.atSteadyState() )
		  return;


  }

  public void stopped()
    throws Exception
  {
    if(ticket != null)
      ticket.cancel();
    super.stopped();
  }


  public void changed(Property property, Context context) 
  {
  	super.changed(property, context);
    if( !Sys.atSteadyState() || !isRunning() )
	    return;
    if(property.equals(demandInterval))
    {
    	if(getDemandInterval() != 15 && getDemandInterval() != 30)
    		setDemandInterval(15);
    }
    doCalculate();
  }

  public BFacets getSlotFacets(Slot slot)
  {
    return super.getSlotFacets(slot);
  }

  public void doCalculate()
  {
    if(ticket != null)
      ticket.cancel();
    ticket = Clock.schedule(this, BRelTime.makeMinutes(1), calculate, null);
    
    BStatusNumeric powerValue = getPowerInput();
    BAbsTime now = null;
    try { now = (BAbsTime)get("clockIn"); } catch(Exception e){ now = null; }
    if(now == null)
    	now = Clock.time();
    
    //BAbsTime now = getTimeIn();
    //
    // Perform Demand Monitoring function
    //
    if( !powerValue.getStatus().isAlarm() )	// is demand input in alarm?
    {
      // What to do, if anything?  Value is outside limits, but input is probably reliable.
    }
    
    //
    // Try to be a little more accurate than just using minutely readings
    //
    if (!powerValue.getStatus().isValid())	// only use reliable input
    {
      mode = 2;
      numberOfReadings = 0;
      sumOfReadings = 0;
    }
    else
    {
    	if(mode == 2)
    		mode = 0;
      numberOfReadings = numberOfReadings + 1;
      sumOfReadings = sumOfReadings + powerValue.getValue();
    }
    
    //
    // Check for synch input
    //
    //if (syncInput.status.fault == true) and (syncInput.status.outOfService != true)
    //  syncPulseReceived = true
      // What else should be done?
    //endif
    
    //
    // Perform Demand Monitoring function
    //
    if (getPredictionEnabled().getValue() != true)	// process only if prediction is enabled
    {
      shedLevels = 0 ;
      mode = 1 ;
    }
    else if (now.getMinute() != lastMinute)	// evaluate shed/restore only once per minute
    {
      lastMinute = now.getMinute();
      if( mode != 2 )			// skip calculations if input is unreliable as determined above
      {
        mode = 0;
        //
        // Roll out oldest demand reading, insert newest
        //
        for(int i = 29; i >= 1; i-- )		// work from bottom to top of table
          demandMinute[i] = demandMinute[i-1];
        
        demandMinute[0] = (float)(sumOfReadings / numberOfReadings);
        //
        // Determine position within demand interval
        //
        if ((getPercentIntervalElapsed() > 0) && (getPercentIntervalElapsed() < 100))	// percentIntervalElapsed represents the percentage of demand period that is assumed to have elapsed 
          percentElapsed = getPercentIntervalElapsed();
        else
          percentElapsed = 75;		// default is 75% of interval has elapsed
        if ((getDemandInterval() == 15) || (getDemandInterval() == 30))	// interval must be 15 or 30 minutes
        {
          minutesElapsed = (getDemandInterval() * percentElapsed) / 100;
          minutesRemaining = getDemandInterval() - minutesElapsed;
        }
        else
        {
          minutesElapsed = (15 * percentElapsed) / 100;		// default interval length is 15 minutes
          minutesRemaining = 15 - minutesElapsed;
        }
        //
        // Calculate demand projection
        //

        projectedIntervalTotal = demandMinute[0] * minutesRemaining;
        for(int i = 1; i <= minutesElapsed; i++)
          projectedIntervalTotal = projectedIntervalTotal + demandMinute[i];
        demandAverage = (float)(projectedIntervalTotal / (minutesElapsed + minutesRemaining));	// can't use demandInterval because it may not be set
        setProjectedDemandAverage(demandAverage);
        //
        // Determine period of day (1,2 or 3) and select control limit
        //
        long nowMillis = now.getTimeOfDayMillis();
        periodOfDay = 1;
        if ( ( (nowMillis >= getDemandPeriod1Start().getMillis()) && 
               (nowMillis <  getDemandPeriod2Start().getMillis())    ) || 
             (getDemandPeriod2Start().getMillis() == 0l)                  )
        {
          periodOfDay = 1;
        }
        else if ( ( (nowMillis >= getDemandPeriod2Start().getMillis()) && 
                    (nowMillis <  getDemandPeriod3Start().getMillis())    ) || 
                  (getDemandPeriod3Start().getMillis() == 0l)                  )
        {
        	periodOfDay = 2;
        }
        else
        {
        	periodOfDay = 3;
        }
//        System.out.println(now + ": edl periodOfDay = " + periodOfDay);
        //if this is this billing day & it is 12 noon or after roll peaks from this to previous month;
        if (getBillingStartDay() == now.getDay() )
        {
//        	System.out.println("today is the billing start day");
        	if(  now.getHour() >= 12 && !rollOverComplete )
      	  {
//          	System.out.println("it's after 12 so rollover");
          	setPreviousMonthDemandPeriod1Peak(getThisMonthDemandPeriod1Peak());
	          setPreviousMonthDemandPeriod1PeakTime(getThisMonthDemandPeriod1PeakTime());
	          setThisMonthDemandPeriod1Peak(0.0f);
	          setThisMonthDemandPeriod1PeakTime(BAbsTime.NULL);
	          
	          setPreviousMonthDemandPeriod2Peak(getThisMonthDemandPeriod2Peak());
	          setPreviousMonthDemandPeriod2PeakTime(getThisMonthDemandPeriod2PeakTime());
	          setThisMonthDemandPeriod2Peak(0.0f);
	          setThisMonthDemandPeriod2PeakTime(BAbsTime.NULL);
	          
	          setPreviousMonthDemandPeriod3Peak(getThisMonthDemandPeriod3Peak());
	          setPreviousMonthDemandPeriod3PeakTime(getThisMonthDemandPeriod3PeakTime());
	          setThisMonthDemandPeriod3Peak(0.0f);
	          setThisMonthDemandPeriod3PeakTime(BAbsTime.NULL);
	          
	          rollOverComplete = true;
      	  }
        }
        else
        	rollOverComplete = false;
        
        switch(periodOfDay)
        {
        case 1:
          demandLimit = getDemandLimitPeriod1();
          if( demandAverage > getThisMonthDemandPeriod1Peak() )
          {
            setThisMonthDemandPeriod1Peak(demandAverage);
            setThisMonthDemandPeriod1PeakTime(now);
          }
        	break;
        case 2:
          demandLimit = getDemandLimitPeriod2();
          if( demandAverage > getThisMonthDemandPeriod2Peak() )
          {
            setThisMonthDemandPeriod2Peak(demandAverage);
            setThisMonthDemandPeriod2PeakTime(now);
          }
        	break;
        case 3:
          demandLimit = getDemandLimitPeriod3();
          if( demandAverage > getThisMonthDemandPeriod3Peak() )
          {
            setThisMonthDemandPeriod3Peak(demandAverage);
            setThisMonthDemandPeriod3PeakTime(now);
          }
        	break;
        }
        
        
    
        if (demandLimit > 0)	// check to make sure the control limit has been entered
        {
          //
          // Initialize local power table for potential shed or restore iteration
          //
          if (demandAverage > demandLimit || shedLevels > 0)
          {
            powerTable[0]  = 0; 		// zero always returned when shedding not active
            powerTable[1]  = getPowerShedLevel1 ();
            powerTable[2]  = getPowerShedLevel2 ();
            powerTable[3]  = getPowerShedLevel3 ();
            powerTable[4]  = getPowerShedLevel4 ();
            powerTable[5]  = getPowerShedLevel5 ();
            powerTable[6]  = getPowerShedLevel6 ();
            powerTable[7]  = getPowerShedLevel7 ();
            powerTable[8]  = getPowerShedLevel8 ();
            powerTable[9]  = getPowerShedLevel9 ();
            powerTable[10] = getPowerShedLevel10();
            powerTable[11] = getPowerShedLevel11();
            powerTable[12] = getPowerShedLevel12();
            powerTable[13] = getPowerShedLevel13();
            powerTable[14] = getPowerShedLevel14();
            powerTable[15] = getPowerShedLevel15();
            powerTable[16] = getPowerShedLevel16();
            powerTable[17] = getPowerShedLevel17();
            powerTable[18] = getPowerShedLevel18();
            powerTable[19] = getPowerShedLevel19();
            powerTable[20] = getPowerShedLevel20();
            powerTable[21] = getPowerShedLevel21();
            powerTable[22] = getPowerShedLevel22();
            powerTable[23] = getPowerShedLevel23();
            powerTable[24] = getPowerShedLevel24();
            powerTable[25] = getPowerShedLevel25();
            powerTable[26] = getPowerShedLevel26();
            powerTable[27] = getPowerShedLevel27();
            powerTable[28] = getPowerShedLevel28();
            powerTable[29] = getPowerShedLevel29();
            powerTable[30] = getPowerShedLevel30();
            powerTable[31] = getPowerShedLevel31();
            powerTable[32] = getPowerShedLevel32();
          }
          
          //
          // Shed or restore determination
          //
          if (demandAverage > demandLimit)
          {
            if (getRotateLevel() <= 0 || getRotateLevel() >= getMaxShedLevel())
              numberOfFixedLevels = getMaxShedLevel();
            else
              numberOfFixedLevels = getRotateLevel() - 1;
      
            //
            // Determine how many levels to shed
            //
            targetIntervalTotal = demandLimit * (minutesElapsed + minutesRemaining);
            powerChange = (projectedIntervalTotal - targetIntervalTotal) / minutesRemaining;
            while ((powerChange > 0) && (shedLevels < numberOfFixedLevels))
            {
              shedLevels = shedLevels + 1;
              powerChange = powerChange - powerTable[shedLevels];
            }
            if (shedLevels < numberOfFixedLevels)
              mode = 3;
            else
              mode = 4;
          }
          else if ( demandAverage <= demandLimit && shedLevels > 0 )
          {
            if (demandAverage < (demandLimit - getDemandLimitingDeadband()))
            {
              mode = 5;
              targetIntervalTotal = (demandLimit - getDemandLimitingDeadband()) * (minutesElapsed + minutesRemaining);
              powerChange = (targetIntervalTotal - projectedIntervalTotal) / minutesRemaining;
              while (shedLevels > 0)
              {
                powerChange = powerChange - powerTable[shedLevels];
                if( powerChange < 0 )
                  break;
                shedLevels = shedLevels - 1;
              }
              if (shedLevels == 0)
    	          mode = 7;
    	      }
            else
    	        mode = 6;
          }
        }
        else
          shedLevels = 0;
        
      }
      numberOfReadings = 0;
      sumOfReadings = 0;
    }

    //
    // Inform operator of what is happening
    //
    switch(mode)
    {
    case 1: setMessage(PREDICTION_NOT_ENABLED_MSG); break;
    case 2: setMessage(DEMAND_UNAVAILABLE_MSG); break;
    case 3: setMessage(SHEDDING_REQUIRED_MSG + ' ' + PROJECTED_DEMAND_MSG + ' ' + demandAverage); break;
    case 4: setMessage(MANUAL_INTERVENTION_MSG + ' ' + PROJECTED_DEMAND_MSG + ' ' + demandAverage); break;
    case 5: setMessage(RESTORATION_MSG + ' ' + PROJECTED_DEMAND_MSG + ' ' + demandAverage); break;
    case 6: setMessage(NOT_ENOUGH_POWER_MSG); break;
    case 7: setMessage(ALL_RESTORED_MSG + ' ' + PROJECTED_DEMAND_MSG + ' ' + demandAverage); break;
    default: setMessage(PROJECTED_DEMAND_MSG + ' ' + demandAverage);
    }
    
    //
    // Set level and priority
    //
    getShedOut().setValue(shedLevels);
    getShedOut().setStatus(getPowerInput().getStatus());
  }

////////////////////////////////////////////////////////////////
// local variables
////////////////////////////////////////////////////////////////

  boolean syncPulseReceived;		// flag for indicating beginning of next fixed interval window
  
  double powerChange;			// energy that needs to be shed or can be restored this minute
  double demandLimit;			// contains demand limit for control comparison
  float[] demandMinute = new float[30];			// readings for last thirty minutes
                              // demandMinute[0] is most recent, demandMinute[29] is oldest
  double numberOfReadings;			// number of power readings taken during the last minute
  float[] powerTable = new float[33];	// copy of the power level properties that is used for shed/restore iteration
  double projectedIntervalTotal;	      // sum of elapsed minutes' power readings + (this * minutesRemaining)
  double sumOfReadings;			          // sum of power readings taken during the last minute
  double targetIntervalTotal;		      // result of (demandLImit * demandInterval) or (demandLimit-demandDeadband * demandInterval)
  float demandAverage;		      // projected demand average working variable
  
  int i;					                    // loop counter
  int shedLevels;					            // calculated shed level
  int numberOfFixedLevels;			// number of fixed priority levels (set to maxShedLevels or getRotateLevel()-1)
  int lastMinute;				// controls processing frequency
  int minutesElapsed;			// minutes of demand interval elapsed based on percent
  int minutesRemaining;			// minutes of demand interval remaining
  int mode;				// message control
  int percentElapsed;			// working percentage penetration into interval (default is 75%)
  int periodOfDay;				// index into period of day (1-3)

  boolean rollOverComplete = false;
  //
  // Messages
  //

  protected static String PROJECTED_DEMAND_MSG       = Lexicon.make("kitControl").getText("electricalDemandLimit.projectedDemand");
  protected static String PREDICTION_NOT_ENABLED_MSG = Lexicon.make("kitControl").getText("electricalDemandLimit.predictionNotEnabled");
  protected static String DEMAND_UNAVAILABLE_MSG     = Lexicon.make("kitControl").getText("electricalDemandLimit.demandInputUnavailable");
  protected static String SHEDDING_REQUIRED_MSG      = Lexicon.make("kitControl").getText("electricalDemandLimit.sheddingRequired");
  protected static String MANUAL_INTERVENTION_MSG    = Lexicon.make("kitControl").getText("electricalDemandLimit.manualInterventionRequired");
  protected static String RESTORATION_MSG            = Lexicon.make("kitControl").getText("electricalDemandLimit.restorationInProgress");
  protected static String NOT_ENOUGH_POWER_MSG       = Lexicon.make("kitControl").getText("electricalDemandLimit.notEnoughPowerForRestoration");
  protected static String ALL_RESTORED_MSG           = Lexicon.make("kitControl").getText("electricalDemandLimit.allRestored");

  Clock.Ticket ticket = null;

  static long NOON_MILLIS = 1000 * 60 * 60 * 12;

}