/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.energy;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.units.*;


/** Degree Day Calculation object
 *
 * 
 * @author    Andy Saunders
 * @creation  11 Jan 2005
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public class BDegreeDays
  extends BComponent
{ 
  /*-
  
  class BDegreeDays
  {
    properties
    {
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1) ]}

      baseTemperature: float
        default {[ 65.0f ]}
    
      tempIn: BStatusNumeric
        flags { summary, transient }
        default {[ new BStatusNumeric() ]}
        
      minTemp: BStatusNumeric
        flags { readonly, summary }
        default {[ new BStatusNumeric() ]}
        
      maxTemp: BStatusNumeric
        flags { readonly, summary }
        default {[ new BStatusNumeric() ]}

      meanTemp: BStatusNumeric
        flags { readonly, summary }
        default {[ new BStatusNumeric() ]}
    
      clgDegDays: BStatusNumeric
        flags { readonly, summary }
        default {[ new BStatusNumeric() ]}
        
      clgDegDaysTotal: BStatusNumeric
        flags { readonly, summary }
        default {[ new BStatusNumeric() ]}
        
      htgDegDays: BStatusNumeric
        flags { readonly, summary }
        default {[ new BStatusNumeric() ]}
    
      htgDegDaysTotal: BStatusNumeric
        flags { readonly, summary }
        default {[ new BStatusNumeric() ]}
    
    }
    
    actions
    {
      resetTotals()
      calculate()
        flags { hidden }
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.energy.BDegreeDays(2229960447)1.0$ @*/
/* Generated Thu Jun 18 10:39:15 EDT 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.energy.BDegreeDays#getFacets
   * @see com.tridium.kitControl.energy.BDegreeDays#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeNumeric(UnitDatabase.getUnit("fahrenheit"), 1),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "baseTemperature"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>baseTemperature</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#getBaseTemperature
   * @see com.tridium.kitControl.energy.BDegreeDays#setBaseTemperature
   */
  public static final Property baseTemperature = newProperty(0, 65.0f,null);
  
  /**
   * Get the <code>baseTemperature</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#baseTemperature
   */
  public float getBaseTemperature() { return getFloat(baseTemperature); }
  
  /**
   * Set the <code>baseTemperature</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#baseTemperature
   */
  public void setBaseTemperature(float v) { setFloat(baseTemperature,v,null); }

////////////////////////////////////////////////////////////////
// Property "tempIn"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>tempIn</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#getTempIn
   * @see com.tridium.kitControl.energy.BDegreeDays#setTempIn
   */
  public static final Property tempIn = newProperty(Flags.SUMMARY|Flags.TRANSIENT, new BStatusNumeric(),null);
  
  /**
   * Get the <code>tempIn</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#tempIn
   */
  public BStatusNumeric getTempIn() { return (BStatusNumeric)get(tempIn); }
  
  /**
   * Set the <code>tempIn</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#tempIn
   */
  public void setTempIn(BStatusNumeric v) { set(tempIn,v,null); }

////////////////////////////////////////////////////////////////
// Property "minTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>minTemp</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#getMinTemp
   * @see com.tridium.kitControl.energy.BDegreeDays#setMinTemp
   */
  public static final Property minTemp = newProperty(Flags.READONLY|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>minTemp</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#minTemp
   */
  public BStatusNumeric getMinTemp() { return (BStatusNumeric)get(minTemp); }
  
  /**
   * Set the <code>minTemp</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#minTemp
   */
  public void setMinTemp(BStatusNumeric v) { set(minTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "maxTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>maxTemp</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#getMaxTemp
   * @see com.tridium.kitControl.energy.BDegreeDays#setMaxTemp
   */
  public static final Property maxTemp = newProperty(Flags.READONLY|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>maxTemp</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#maxTemp
   */
  public BStatusNumeric getMaxTemp() { return (BStatusNumeric)get(maxTemp); }
  
  /**
   * Set the <code>maxTemp</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#maxTemp
   */
  public void setMaxTemp(BStatusNumeric v) { set(maxTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "meanTemp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>meanTemp</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#getMeanTemp
   * @see com.tridium.kitControl.energy.BDegreeDays#setMeanTemp
   */
  public static final Property meanTemp = newProperty(Flags.READONLY|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>meanTemp</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#meanTemp
   */
  public BStatusNumeric getMeanTemp() { return (BStatusNumeric)get(meanTemp); }
  
  /**
   * Set the <code>meanTemp</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#meanTemp
   */
  public void setMeanTemp(BStatusNumeric v) { set(meanTemp,v,null); }

////////////////////////////////////////////////////////////////
// Property "clgDegDays"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>clgDegDays</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#getClgDegDays
   * @see com.tridium.kitControl.energy.BDegreeDays#setClgDegDays
   */
  public static final Property clgDegDays = newProperty(Flags.READONLY|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>clgDegDays</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#clgDegDays
   */
  public BStatusNumeric getClgDegDays() { return (BStatusNumeric)get(clgDegDays); }
  
  /**
   * Set the <code>clgDegDays</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#clgDegDays
   */
  public void setClgDegDays(BStatusNumeric v) { set(clgDegDays,v,null); }

////////////////////////////////////////////////////////////////
// Property "clgDegDaysTotal"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>clgDegDaysTotal</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#getClgDegDaysTotal
   * @see com.tridium.kitControl.energy.BDegreeDays#setClgDegDaysTotal
   */
  public static final Property clgDegDaysTotal = newProperty(Flags.READONLY|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>clgDegDaysTotal</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#clgDegDaysTotal
   */
  public BStatusNumeric getClgDegDaysTotal() { return (BStatusNumeric)get(clgDegDaysTotal); }
  
  /**
   * Set the <code>clgDegDaysTotal</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#clgDegDaysTotal
   */
  public void setClgDegDaysTotal(BStatusNumeric v) { set(clgDegDaysTotal,v,null); }

////////////////////////////////////////////////////////////////
// Property "htgDegDays"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>htgDegDays</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#getHtgDegDays
   * @see com.tridium.kitControl.energy.BDegreeDays#setHtgDegDays
   */
  public static final Property htgDegDays = newProperty(Flags.READONLY|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>htgDegDays</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#htgDegDays
   */
  public BStatusNumeric getHtgDegDays() { return (BStatusNumeric)get(htgDegDays); }
  
  /**
   * Set the <code>htgDegDays</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#htgDegDays
   */
  public void setHtgDegDays(BStatusNumeric v) { set(htgDegDays,v,null); }

////////////////////////////////////////////////////////////////
// Property "htgDegDaysTotal"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>htgDegDaysTotal</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#getHtgDegDaysTotal
   * @see com.tridium.kitControl.energy.BDegreeDays#setHtgDegDaysTotal
   */
  public static final Property htgDegDaysTotal = newProperty(Flags.READONLY|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>htgDegDaysTotal</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#htgDegDaysTotal
   */
  public BStatusNumeric getHtgDegDaysTotal() { return (BStatusNumeric)get(htgDegDaysTotal); }
  
  /**
   * Set the <code>htgDegDaysTotal</code> property.
   * @see com.tridium.kitControl.energy.BDegreeDays#htgDegDaysTotal
   */
  public void setHtgDegDaysTotal(BStatusNumeric v) { set(htgDegDaysTotal,v,null); }

////////////////////////////////////////////////////////////////
// Action "resetTotals"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>resetTotals</code> action.
   * @see com.tridium.kitControl.energy.BDegreeDays#resetTotals()
   */
  public static final Action resetTotals = newAction(0,null);
  
  /**
   * Invoke the <code>resetTotals</code> action.
   * @see com.tridium.kitControl.energy.BDegreeDays#resetTotals
   */
  public void resetTotals() { invoke(resetTotals,null,null); }

////////////////////////////////////////////////////////////////
// Action "calculate"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BDegreeDays#calculate()
   */
  public static final Action calculate = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>calculate</code> action.
   * @see com.tridium.kitControl.energy.BDegreeDays#calculate
   */
  public void calculate() { invoke(calculate,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDegreeDays.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Initialization  /  Cleanup
////////////////////////////////////////////////////////////////

  public void started()
    throws Exception
  {
    super.started();
	  if( !Sys.atSteadyState() )
		  return;

  }

  public void stopped()
    throws Exception
  {
    if(ticket != null)
      ticket.cancel();
    super.stopped();
  }


  public void changed(Property property, Context context) 
  {
  	super.changed(property, context);
    if( !Sys.atSteadyState() || !isRunning() )
	    return;
    if( property.equals(tempIn))
    {
      doCalculate();
    }
  }

  public BFacets getSlotFacets(Slot slot)
  {
    if( slot.equals(tempIn) ||
        slot.equals(meanTemp) ||
        slot.equals(maxTemp)  ||
        slot.equals(minTemp)  ||
        slot.equals(baseTemperature) )
      return getFacets();
    return super.getSlotFacets(slot);
  }

  public void doResetTotals()
  {
    getHtgDegDaysTotal().setValue(0.0);
    getClgDegDaysTotal().setValue(0.0);
  }
  public void doCalculate()
  {
    if(ticket != null)
      ticket.cancel();
    ticket = Clock.schedule(this, BRelTime.makeMinutes(1), calculate, null);
    currentDay = Clock.time().getDayOfYear();
    //currentDay = getTime().getDayOfYear();
    BStatusNumeric currentTemp = getTempIn();
    if(!currentTemp.getStatus().isValid())
    {
      return;
    }
    if ( firstTime == true )	//Initialization
    {
      firstTime = false;
      previousDay = currentDay;
      setMinTemp( (BStatusNumeric)currentTemp.newCopy() );
      setMaxTemp( (BStatusNumeric)currentTemp.newCopy() );
      return;
    }
    if ( currentTemp.getValue() < getMinTemp().getValue() )	//Trap min temp
      setMinTemp((BStatusNumeric)currentTemp.newCopy());
    
    if ( currentTemp.getValue() > getMaxTemp().getValue() )	//Trap max temp
      setMaxTemp((BStatusNumeric)currentTemp.newCopy());
    
    if ( currentDay != previousDay )	//Calculate degree days once per day
    {
      previousDay = currentDay;
      getMeanTemp().setValue( (getMinTemp().getValue() + getMaxTemp().getValue())  / 2.0 );
      tempDiff = getMeanTemp().getValue() - getBaseTemperature();
      if ( tempDiff > 0.0 )  //Cooling Degree Days
      {
        getClgDegDays().setValue( Math.abs(tempDiff));
        getHtgDegDays().setValue( 0.0 );
      }

      else
      {
        getHtgDegDays().setValue( Math.abs(tempDiff));
        getClgDegDays().setValue( 0.0 );
      }
      getHtgDegDaysTotal().setValue(getHtgDegDaysTotal().getValue() + getHtgDegDays().getValue());
      getClgDegDaysTotal().setValue(getClgDegDaysTotal().getValue() + getClgDegDays().getValue());
      setMinTemp( (BStatusNumeric)currentTemp.newCopy() );
      setMaxTemp( (BStatusNumeric)currentTemp.newCopy() );
    }
  }

////////////////////////////////////////////////////////////////
// local variables
////////////////////////////////////////////////////////////////
  boolean firstTime = true;
  double tempDiff;
  int currentDay;
  int previousDay;

  Clock.Ticket ticket = null;



}