/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import java.text.*;
import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;
import javax.baja.units.*;

/**
 * BStatusEnumToStatusNumeric is a component that converts a StatusEnum to a StatusNumeric.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStatusEnumToStatusNumeric
  extends BComponent
  implements BIStatus
{
  /*-
  
  class BStatusEnumToStatusNumeric
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.make(BFacets.UNITS, BUnit.NULL, BFacets.PRECISION, BInteger.make(1) ) ]}
        
      out: BStatusNumeric
        flags { transient, readonly, summary }
        default {[ new BStatusNumeric() ]}

      in: BStatusEnum
        flags { transient, summary }
        default {[ new BStatusEnum() ]}

    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric(1237818548)1.0$ @*/
/* Generated Wed Apr 27 10:29:33 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#getFacets
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.make(BFacets.UNITS, BUnit.NULL, BFacets.PRECISION, BInteger.make(1) ),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#getOut
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#out
   */
  public BStatusNumeric getOut() { return (BStatusNumeric)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#out
   */
  public void setOut(BStatusNumeric v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#getIn
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#in
   */
  public BStatusEnum getIn() { return (BStatusEnum)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusNumeric#in
   */
  public void setIn(BStatusEnum v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusEnumToStatusNumeric.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStatusEnumToStatusNumeric()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    calculate();
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == in )
    {
      calculate();
    }
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }

  void calculate()
  {
    int enumValue =  getIn().getValue().getOrdinal();
    getOut().setValue((double)enumValue);
    getOut().setStatus(BStatus.make(getIn().getStatus().getBits()));
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }


////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
}
