/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import java.text.*;
import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;
import javax.baja.units.*;
import com.tridium.bql.filter.*;
/**
 * BStatusEnumToStatusBoolean is a component that converts a StatusEnum to a StatusBoolean.
 *
 * @author    Andy Saunders
 * @creation  18 May 2005
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStatusEnumToStatusBoolean
  extends BComponent
  implements BIStatus
{
  /*-
  
  class BStatusEnumToStatusBoolean
  {
    properties
    {
      
      outFacets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeBoolean() ]}
        
      inFacets: BFacets
        -- These facets are applied against the in property.
        default {[ BFacets.makeEnum() ]}
        
      out: BStatusBoolean
        flags { transient, readonly, summary }
        default {[ new BStatusBoolean() ]}

      in: BStatusEnum
        flags { transient, summary }
        default {[ new BStatusEnum() ]}
        
      activeValues:  BEnumRange
      -- Set of all offnormal states
        default {[ BEnumRange.DEFAULT ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, BString.make("alarm:EnumAlarmRangeFE")) ]}

    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean(2919054856)1.0$ @*/
/* Generated Wed May 18 15:15:03 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "outFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outFacets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#getOutFacets
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#setOutFacets
   */
  public static final Property outFacets = newProperty(0, BFacets.makeBoolean(),null);
  
  /**
   * Get the <code>outFacets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#outFacets
   */
  public BFacets getOutFacets() { return (BFacets)get(outFacets); }
  
  /**
   * Set the <code>outFacets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#outFacets
   */
  public void setOutFacets(BFacets v) { set(outFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "inFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inFacets</code> property.
   * These facets are applied against the in property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#getInFacets
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#setInFacets
   */
  public static final Property inFacets = newProperty(0, BFacets.makeEnum(),null);
  
  /**
   * Get the <code>inFacets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#inFacets
   */
  public BFacets getInFacets() { return (BFacets)get(inFacets); }
  
  /**
   * Set the <code>inFacets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#inFacets
   */
  public void setInFacets(BFacets v) { set(inFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#getOut
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#out
   */
  public BStatusBoolean getOut() { return (BStatusBoolean)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#out
   */
  public void setOut(BStatusBoolean v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#getIn
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#in
   */
  public BStatusEnum getIn() { return (BStatusEnum)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#in
   */
  public void setIn(BStatusEnum v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "activeValues"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>activeValues</code> property.
   * Set of all offnormal states
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#getActiveValues
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#setActiveValues
   */
  public static final Property activeValues = newProperty(0, BEnumRange.DEFAULT,BFacets.make(BFacets.FIELD_EDITOR, BString.make("alarm:EnumAlarmRangeFE")) );
  
  /**
   * Get the <code>activeValues</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#activeValues
   */
  public BEnumRange getActiveValues() { return (BEnumRange)get(activeValues); }
  
  /**
   * Set the <code>activeValues</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToStatusBoolean#activeValues
   */
  public void setActiveValues(BEnumRange v) { set(activeValues,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusEnumToStatusBoolean.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStatusEnumToStatusBoolean()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    calculate();
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if ( p.equals(in) || p.equals(inFacets) || p.equals(activeValues) )
    {
      calculate();
    }
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getOutFacets();
    if (slot == in) return getInFacets();
    if (slot == activeValues) return BFacets.make(getInFacets(), super.getSlotFacets(slot));
    return super.getSlotFacets(slot);
  }


  void calculate()
  {
    //BEnum enumValue =  getIn().getValue();
    int currentOrdinal = getIn().getValue().getOrdinal();
    int[] activeOrdinals = getActiveValues().getOrdinals();
    boolean setValue = false;
    for( int i = 0; i < activeOrdinals.length; i++)
    {
      if( currentOrdinal == activeOrdinals[i] )
      {
        setValue = true;
        break;
      }
    }
    getOut().setValue( setValue );
    getOut().setStatus(BStatus.make(getIn().getStatus().getBits()));
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }


////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
}
