/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.constants;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.status.*;


/** String constant object
 *
 * 
 * @author    Andy Saunders
 * @creation  14 Sept 2004
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public class BStringConst
  extends BComponent
  implements BIStatusValue
{ 
  /*-
  
  class BStringConst
  {
    properties
    {
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.DEFAULT ]}
    
      out: BStatusString
        flags { summary }
        default {[ new BStatusString() ]}
        
    }
    
    actions
    {
      set(arg: BString)
        -- To set the output .
        flags { operator }
        default {[ BString.make("") ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.constants.BStringConst(3008861794)1.0$ @*/
/* Generated Tue Sep 14 09:38:42 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.constants.BStringConst#getFacets
   * @see com.tridium.kitControl.constants.BStringConst#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.DEFAULT,null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.constants.BStringConst#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.constants.BStringConst#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BStringConst#getOut
   * @see com.tridium.kitControl.constants.BStringConst#setOut
   */
  public static final Property out = newProperty(Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BStringConst#out
   */
  public BStatusString getOut() { return (BStatusString)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BStringConst#out
   */
  public void setOut(BStatusString v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Action "set"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>set</code> action.
   * To set the output .
   * @see com.tridium.kitControl.constants.BStringConst#set()
   */
  public static final Action set = newAction(Flags.OPERATOR,BString.make(""),null);
  
  /**
   * Invoke the <code>set</code> action.
   * @see com.tridium.kitControl.constants.BStringConst#set
   */
  public void set(BString arg) { invoke(set,arg,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStringConst.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().equals("out") || slot == set)
    {
      return getFacets();
    }
    else return super.getSlotFacets(slot);
  }

  public BValue getActionParameterDefault(Action action)
  {
    if (action == set) 
      return getOut().getValueValue();
    return super.getActionParameterDefault(action);
  }

  public void doSet(BString value)
  {
    getOut().setValue(value.getString());
  }

  public String toString(Context cx)
  {
    return propertyValueToString(out, cx);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  
////////////////////////////////////////////////////////////////
// BIStatusValue interface
////////////////////////////////////////////////////////////////

  public BStatusValue getStatusValue() { return getOut(); }

  public BFacets getStatusValueFacets() { return getOut().getStatusValueFacets(); }

}
