/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.constants;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.status.*;


/** Numeric constant object
 *
 * 
 * @author    Andy Saunders
 * @creation  14 Sept 2004
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public class BNumericConst
  extends BComponent
  implements BIStatus, BINumeric
{ 
  /*-
  
  class BNumericConst
  {
    properties
    {
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeNumeric() ]}
    
      out: BStatusNumeric
        flags { summary }
        default {[ new BStatusNumeric() ]}
        
    }
    
    actions
    {
      set(arg: BDouble)
        -- To set the output .
        flags { operator }
        default {[ BDouble.make(0d) ]}
        
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.constants.BNumericConst(2681527649)1.0$ @*/
/* Generated Tue Sep 14 09:29:52 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.constants.BNumericConst#getFacets
   * @see com.tridium.kitControl.constants.BNumericConst#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeNumeric(),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.constants.BNumericConst#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.constants.BNumericConst#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BNumericConst#getOut
   * @see com.tridium.kitControl.constants.BNumericConst#setOut
   */
  public static final Property out = newProperty(Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BNumericConst#out
   */
  public BStatusNumeric getOut() { return (BStatusNumeric)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BNumericConst#out
   */
  public void setOut(BStatusNumeric v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Action "set"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>set</code> action.
   * To set the output .
   * @see com.tridium.kitControl.constants.BNumericConst#set()
   */
  public static final Action set = newAction(Flags.OPERATOR,BDouble.make(0d),null);
  
  /**
   * Invoke the <code>set</code> action.
   * @see com.tridium.kitControl.constants.BNumericConst#set
   */
  public void set(BDouble arg) { invoke(set,arg,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNumericConst.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().equals("out") || slot == set)
    {
      return getFacets();
    }
    else return super.getSlotFacets(slot);
  }

  public BValue getActionParameterDefault(Action action)
  {
    if (action == set) 
      return getOut().getValueValue();
    return super.getActionParameterDefault(action);
  }

  public void doSet(BDouble value)
  {
    getOut().setValue(value.getDouble());
  }

  public String toString(Context cx)
  {
    return propertyValueToString(out, cx);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BINumeric interface
////////////////////////////////////////////////////////////////

  public double getNumeric() { return getOut().getValue(); }

  public final BFacets getNumericFacets() { return getFacets(); }



}