/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.constants;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.status.*;


/** Enum constant object
 *
 * 
 * @author    Andy Saunders
 * @creation  14 Sept 2004
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public class BEnumConst
  extends BComponent
  implements BIStatus, BIEnum
{ 
  /*-
  
  class BEnumConst
  {
    properties
    {
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeEnum() ]}
    
      out: BStatusEnum
        flags { summary }
        default {[ new BStatusEnum() ]}
        
    }
    
    actions
    {
      set(arg: BDynamicEnum)
        -- To set the output .
        flags { operator }
        default {[ BDynamicEnum.DEFAULT ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.constants.BEnumConst(1951699953)1.0$ @*/
/* Generated Tue Sep 14 09:36:40 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.constants.BEnumConst#getFacets
   * @see com.tridium.kitControl.constants.BEnumConst#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeEnum(),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.constants.BEnumConst#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.constants.BEnumConst#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BEnumConst#getOut
   * @see com.tridium.kitControl.constants.BEnumConst#setOut
   */
  public static final Property out = newProperty(Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BEnumConst#out
   */
  public BStatusEnum getOut() { return (BStatusEnum)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BEnumConst#out
   */
  public void setOut(BStatusEnum v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Action "set"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>set</code> action.
   * To set the output .
   * @see com.tridium.kitControl.constants.BEnumConst#set()
   */
  public static final Action set = newAction(Flags.OPERATOR,BDynamicEnum.DEFAULT,null);
  
  /**
   * Invoke the <code>set</code> action.
   * @see com.tridium.kitControl.constants.BEnumConst#set
   */
  public void set(BDynamicEnum arg) { invoke(set,arg,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEnumConst.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().equals("out") || slot == set)
    {
      return getFacets();
    }
    else return super.getSlotFacets(slot);
  }

  public BValue getActionParameterDefault(Action action)
  {
    if (action == set) 
      return getOut().getValueValue();
    return super.getActionParameterDefault(action);
  }

  public void doSet(BDynamicEnum value)
  {
    getOut().setValue(value);
  }

  public String toString(Context cx)
  {
    return propertyValueToString(out, cx);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  
////////////////////////////////////////////////////////////////
// BIBoolean interface
////////////////////////////////////////////////////////////////

  /**
   * Return the vaule as a enum.
   */
  public final BEnum getEnum() { return getOut().getEnum(); }

  /**
   * Return getFacets().
   */
  public final BFacets getEnumFacets() { return getFacets(); }


}