/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.constants;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.status.*;


/** Boolean constant object
 *
 * 
 * @author    Andy Saunders
 * @creation  14 Sept 2004
 * @version   $Revision: 21$ $Date: 11/5/2003 5:12:11 PM$
 * @since     Baja 1.0
 */
 
public class BBooleanConst
  extends BComponent
  implements BIStatus, BIBoolean
{ 
  /*-
  
  class BBooleanConst
  {
    properties
    {
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeBoolean() ]}
    
      out: BStatusBoolean
        flags { summary }
        default {[ new BStatusBoolean() ]}
        
    }
    
    actions
    {
      active()
        -- To set an active output.
        flags { operator }
        
      inactive()
        -- To set an inactive output.
        flags { operator }
        
      set(arg: BBoolean)
        -- To set the output.
        flags { operator }
        default {[ BBoolean.FALSE ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.constants.BBooleanConst(2935522447)1.0$ @*/
/* Generated Sat May 14 10:18:18 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.constants.BBooleanConst#getFacets
   * @see com.tridium.kitControl.constants.BBooleanConst#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeBoolean(),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.constants.BBooleanConst#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.constants.BBooleanConst#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BBooleanConst#getOut
   * @see com.tridium.kitControl.constants.BBooleanConst#setOut
   */
  public static final Property out = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BBooleanConst#out
   */
  public BStatusBoolean getOut() { return (BStatusBoolean)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.constants.BBooleanConst#out
   */
  public void setOut(BStatusBoolean v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Action "active"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>active</code> action.
   * To set an active output.
   * @see com.tridium.kitControl.constants.BBooleanConst#active()
   */
  public static final Action active = newAction(Flags.OPERATOR,null);
  
  /**
   * Invoke the <code>active</code> action.
   * @see com.tridium.kitControl.constants.BBooleanConst#active
   */
  public void active() { invoke(active,null,null); }

////////////////////////////////////////////////////////////////
// Action "inactive"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inactive</code> action.
   * To set an inactive output.
   * @see com.tridium.kitControl.constants.BBooleanConst#inactive()
   */
  public static final Action inactive = newAction(Flags.OPERATOR,null);
  
  /**
   * Invoke the <code>inactive</code> action.
   * @see com.tridium.kitControl.constants.BBooleanConst#inactive
   */
  public void inactive() { invoke(inactive,null,null); }

////////////////////////////////////////////////////////////////
// Action "set"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>set</code> action.
   * To set the output.
   * @see com.tridium.kitControl.constants.BBooleanConst#set()
   */
  public static final Action set = newAction(Flags.OPERATOR,BBoolean.FALSE,null);
  
  /**
   * Invoke the <code>set</code> action.
   * @see com.tridium.kitControl.constants.BBooleanConst#set
   */
  public void set(BBoolean arg) { invoke(set,arg,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBooleanConst.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().equals("out") || slot == set)
    {
      return getFacets();
    }
    else return super.getSlotFacets(slot);
  }

  public BValue getActionParameterDefault(Action action)
  {
    if (action == set) 
      return getOut().getValueValue();
    return super.getActionParameterDefault(action);
  }

  public void doActive()
  {
    getOut().setValue(true);
  }

  public void doInactive()
  {
    getOut().setValue(false);
  }

  public void doSet(BBoolean value)
  {
    getOut().setValue(value.getBoolean());
  }

  public String toString(Context cx)
  {
    return propertyValueToString(out, cx);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  
////////////////////////////////////////////////////////////////
// BIBoolean interface
////////////////////////////////////////////////////////////////

  public boolean getBoolean() { return getOut().getValue(); }

  public final BFacets getBooleanFacets() { return getFacets(); }

  /**
   * Return the vaule as a enum.
   */
  public final BEnum getEnum() { return getOut().getEnum(); }

  /**
   * Return getFacets().
   */
  public final BFacets getEnumFacets() { return getFacets(); }



}