/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl;

import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;

/**
 * BKitNumericPoint is the abstract superclass of all kitControl
 * numeric points.
 *
 * @author    Andy Saunders
 * @creation  5 Aug 04
 * @version   $Revision: 17$ $Date: 3/30/2004 3:42:02 PM$
 * @since     Baja 1.0
 */
public abstract class BKitNumericPoint
  extends BNumericPoint
{ 
  /*-
  
  class BKitNumericPoint
  {
    properties
    {
      propagateFlags: BStatus
      -- defines which input status flags will be propagated from
      -- input to output.
        default{[ BStatus.nullStatus ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.BKitNumericPoint(1402486918)1.0$ @*/
/* Generated Wed Aug 11 11:12:51 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "propagateFlags"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>propagateFlags</code> property.
   * defines which input status flags will be propagated
   * from input to output.
   * @see com.tridium.kitControl.BKitNumericPoint#getPropagateFlags
   * @see com.tridium.kitControl.BKitNumericPoint#setPropagateFlags
   */
  public static final Property propagateFlags = newProperty(0, BStatus.nullStatus,null);
  
  /**
   * Get the <code>propagateFlags</code> property.
   * @see com.tridium.kitControl.BKitNumericPoint#propagateFlags
   */
  public BStatus getPropagateFlags() { return (BStatus)get(propagateFlags); }
  
  /**
   * Set the <code>propagateFlags</code> property.
   * @see com.tridium.kitControl.BKitNumericPoint#propagateFlags
   */
  public void setPropagateFlags(BStatus v) { set(propagateFlags,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BKitNumericPoint.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
/*
  private static final BFacets PROPAGATE_FACETS = 
    BFacets.make(BFacets.FIELD_EDITOR, BString.make("kitControl:PropagateFlagsFE"));

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().equals("propagateFlags"))
    {
      return PROPAGATE_FACETS;
    }
    else return super.getSlotFacets(slot);
  }
*/

  /**
   * Create a new status by masking out only the standard
   * flags which should be propagated from inputs to outputs.
   * See PROPOGATE_MASK for the flags which are propagated.
   *
   * @return <code>make(s.getBits() & PROPOGATE_MASK)</code>
   */
  public BStatus propagate(BStatus s)
  {
    return BStatus.make(s.getBits() & getPropagateFlags().getBits());
  }

}