/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl;

import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;

/**
 * BKitEnumPoint is the abstract superclass of all kitControl
 * enum points.
 *
 * @author    Andy Saunders
 * @creation  5 Aug 04
 * @version   $Revision: 17$ $Date: 3/30/2004 3:42:02 PM$
 * @since     Baja 1.0
 */
public abstract class BKitEnumPoint
  extends BEnumPoint
{ 
  /*-
  
  class BKitEnumPoint
  {
    properties
    {
      propagateFlags: BStatus
      -- defines which input status flags will be propagated from
      -- input to output.
        default{[ BStatus.nullStatus ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.BKitEnumPoint(757295069)1.0$ @*/
/* Generated Thu May 05 07:10:45 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "propagateFlags"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>propagateFlags</code> property.
   * defines which input status flags will be propagated
   * from input to output.
   * @see com.tridium.kitControl.BKitEnumPoint#getPropagateFlags
   * @see com.tridium.kitControl.BKitEnumPoint#setPropagateFlags
   */
  public static final Property propagateFlags = newProperty(0, BStatus.nullStatus,null);
  
  /**
   * Get the <code>propagateFlags</code> property.
   * @see com.tridium.kitControl.BKitEnumPoint#propagateFlags
   */
  public BStatus getPropagateFlags() { return (BStatus)get(propagateFlags); }
  
  /**
   * Set the <code>propagateFlags</code> property.
   * @see com.tridium.kitControl.BKitEnumPoint#propagateFlags
   */
  public void setPropagateFlags(BStatus v) { set(propagateFlags,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BKitEnumPoint.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
/*
  private static final BFacets PROPAGATE_FACETS = 
    BFacets.make(BFacets.FIELD_EDITOR, BString.make("kitControl:PropagateFlagsFE"));

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().equals("propagateFlags"))
    {
      return PROPAGATE_FACETS;
    }
    else return super.getSlotFacets(slot);
  }
*/

  /**
   * Create a new status by masking out only the standard
   * flags which should be propagated from inputs to outputs.
   * See PROPOGATE_MASK for the flags which are propagated.
   *
   * @return <code>make(s.getBits() & PROPOGATE_MASK)</code>
   */
  public BStatus propagate(BStatus s)
  {
    return BStatus.make(s.getBits() & getPropagateFlags().getBits());
  }

}