/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl;

import javax.baja.sys.*;
import javax.baja.status.*;

import javax.baja.control.*;

/**
 * BKitNumericPoint is the abstract superclass of all kitControl
 * numeric points.
 *
 * @author    Lee Adcock
 * @creation  18 June 09
 * @version   $Revision: 17$ $Date: 3/30/2004 3:42:02 PM$
 * @since     Baja 1.0
 */
public abstract class BKitBooleanPoint
  extends BBooleanPoint
{ 
  /*-
  
  class BKitBooleanPoint
  {
    properties
    {
      propagateFlags: BStatus
      -- defines which input status flags will be propagated from
      -- input to output.
        default{[ BStatus.nullStatus ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.BKitBooleanPoint(3072914183)1.0$ @*/
/* Generated Thu Jun 18 09:26:48 EDT 2009 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "propagateFlags"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>propagateFlags</code> property.
   * defines which input status flags will be propagated
   * from input to output.
   * @see com.tridium.kitControl.BKitBooleanPoint#getPropagateFlags
   * @see com.tridium.kitControl.BKitBooleanPoint#setPropagateFlags
   */
  public static final Property propagateFlags = newProperty(0, BStatus.nullStatus,null);
  
  /**
   * Get the <code>propagateFlags</code> property.
   * @see com.tridium.kitControl.BKitBooleanPoint#propagateFlags
   */
  public BStatus getPropagateFlags() { return (BStatus)get(propagateFlags); }
  
  /**
   * Set the <code>propagateFlags</code> property.
   * @see com.tridium.kitControl.BKitBooleanPoint#propagateFlags
   */
  public void setPropagateFlags(BStatus v) { set(propagateFlags,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BKitBooleanPoint.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
/*
  private static final BFacets PROPAGATE_FACETS = 
    BFacets.make(BFacets.FIELD_EDITOR, BString.make("kitControl:PropagateFlagsFE"));

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.getName().equals("propagateFlags"))
    {
      return PROPAGATE_FACETS;
    }
    else return super.getSlotFacets(slot);
  }
*/

  /**
   * Create a new status by masking out only the standard
   * flags which should be propagated from inputs to outputs.
   * See PROPOGATE_MASK for the flags which are propagated.
   *
   * @return <code>make(s.getBits() & PROPOGATE_MASK)</code>
   */
  public BStatus propagate(BStatus s)
  {
    return BStatus.make(s.getBits() & getPropagateFlags().getBits());
  }

}