/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl;

import java.io.*;
import java.util.*;


import javax.baja.sys.*;
import javax.baja.naming.*;

import javax.baja.control.*;

/**
 * BInterstartDelayMaster
 *
 * @author    Dan Giorgis
 * @creation  17 Nov 00
 * @version   $Revision: 10$ $Date: 10/30/2002 5:24:11 PM$
 * @since     Baja 1.0
 */

//  This class is just a rough first hack to test the
//  extension mechanism.  It needs some polishing..
//  FIXX:  add a property display list of BComponents in
//    the wait list
//  FIXX:  this object relies on checkInterstartDelay()
//    from the delay ext to start timers and manage the
//    list.  It needs to be modified to execute periodically
//    If an object in the list were to have its ext
//    removed or no longer need to start, the
//    checkInterstartDelay() will never be made and the
//    list will not be re-evaluated.
//  FIXX:  Is a vector the best way to manage list of
//    waiting objects?  How to handle object deletion?
//  FIXX: dispose of schedules when done?
public class BInterstartDelayMaster
  extends BComponent
{

  /*-

  class BInterstartDelayMaster
  {
    properties
    {
      slaveLink: BOrd
        --  This Ord.  Used to link to slave BInterstartDelayExt
        --  It will automatically be initialized this Ord.
        flags { transient, readonly }
        default {[ BOrd.NULL ]}

      defaultDelay: BRelTime
        --  Default delay time to use per
        --  start request.  Only used
        --  if the object request start
        --  permission does not specify
        --  at delay time.
        default {[ BRelTime.DEFAULT ]}
      activeDelay: boolean
        -- true if the interstart delay is
        -- active
        flags { transient, readonly }
        default {[ false  ]}
      delayTime: BRelTime
        -- length of current delay
        flags { transient, readonly }
        default {[ BRelTime.DEFAULT  ]}
      delayStartTime: BAbsTime
        -- time at which current delay
        -- started
        flags { transient, readonly }
        default {[ BAbsTime.DEFAULT  ]}
      numObjectsWaiting: int
        --  number of objects currently waiting
        --  to start
        flags { transient, readonly }
        default {[ 0 ]}
    }

    actions
    {
      delayTimerExpired()
      -- delayTimerExpired
    }


  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.BInterstartDelayMaster(2381648056)1.0$ @*/
/* Generated Thu Feb 14 09:31:33 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "slaveLink"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>slaveLink</code> property.
   * This Ord.  Used to link to slave BInterstartDelayExt
   * It will automatically be initialized this Ord.
   * @see com.tridium.kitControl.BInterstartDelayMaster#getSlaveLink
   * @see com.tridium.kitControl.BInterstartDelayMaster#setSlaveLink
   */
  public static final Property slaveLink = newProperty(Flags.TRANSIENT|Flags.READONLY, BOrd.NULL,null);
  
  /**
   * Get the <code>slaveLink</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#slaveLink
   */
  public BOrd getSlaveLink() { return (BOrd)get(slaveLink); }
  
  /**
   * Set the <code>slaveLink</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#slaveLink
   */
  public void setSlaveLink(BOrd v) { set(slaveLink,v,null); }

////////////////////////////////////////////////////////////////
// Property "defaultDelay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>defaultDelay</code> property.
   * Default delay time to use per start request.  Only
   * used if the object request start permission does not
   * specify at delay time.
   * @see com.tridium.kitControl.BInterstartDelayMaster#getDefaultDelay
   * @see com.tridium.kitControl.BInterstartDelayMaster#setDefaultDelay
   */
  public static final Property defaultDelay = newProperty(0, BRelTime.DEFAULT,null);
  
  /**
   * Get the <code>defaultDelay</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#defaultDelay
   */
  public BRelTime getDefaultDelay() { return (BRelTime)get(defaultDelay); }
  
  /**
   * Set the <code>defaultDelay</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#defaultDelay
   */
  public void setDefaultDelay(BRelTime v) { set(defaultDelay,v,null); }

////////////////////////////////////////////////////////////////
// Property "activeDelay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>activeDelay</code> property.
   * true if the interstart delay is active
   * @see com.tridium.kitControl.BInterstartDelayMaster#getActiveDelay
   * @see com.tridium.kitControl.BInterstartDelayMaster#setActiveDelay
   */
  public static final Property activeDelay = newProperty(Flags.TRANSIENT|Flags.READONLY, false,null);
  
  /**
   * Get the <code>activeDelay</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#activeDelay
   */
  public boolean getActiveDelay() { return getBoolean(activeDelay); }
  
  /**
   * Set the <code>activeDelay</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#activeDelay
   */
  public void setActiveDelay(boolean v) { setBoolean(activeDelay,v,null); }

////////////////////////////////////////////////////////////////
// Property "delayTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>delayTime</code> property.
   * length of current delay
   * @see com.tridium.kitControl.BInterstartDelayMaster#getDelayTime
   * @see com.tridium.kitControl.BInterstartDelayMaster#setDelayTime
   */
  public static final Property delayTime = newProperty(Flags.TRANSIENT|Flags.READONLY, BRelTime.DEFAULT,null);
  
  /**
   * Get the <code>delayTime</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#delayTime
   */
  public BRelTime getDelayTime() { return (BRelTime)get(delayTime); }
  
  /**
   * Set the <code>delayTime</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#delayTime
   */
  public void setDelayTime(BRelTime v) { set(delayTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "delayStartTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>delayStartTime</code> property.
   * time at which current delay started
   * @see com.tridium.kitControl.BInterstartDelayMaster#getDelayStartTime
   * @see com.tridium.kitControl.BInterstartDelayMaster#setDelayStartTime
   */
  public static final Property delayStartTime = newProperty(Flags.TRANSIENT|Flags.READONLY, BAbsTime.DEFAULT,null);
  
  /**
   * Get the <code>delayStartTime</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#delayStartTime
   */
  public BAbsTime getDelayStartTime() { return (BAbsTime)get(delayStartTime); }
  
  /**
   * Set the <code>delayStartTime</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#delayStartTime
   */
  public void setDelayStartTime(BAbsTime v) { set(delayStartTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "numObjectsWaiting"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>numObjectsWaiting</code> property.
   * number of objects currently waiting to start
   * @see com.tridium.kitControl.BInterstartDelayMaster#getNumObjectsWaiting
   * @see com.tridium.kitControl.BInterstartDelayMaster#setNumObjectsWaiting
   */
  public static final Property numObjectsWaiting = newProperty(Flags.TRANSIENT|Flags.READONLY, 0,null);
  
  /**
   * Get the <code>numObjectsWaiting</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#numObjectsWaiting
   */
  public int getNumObjectsWaiting() { return getInt(numObjectsWaiting); }
  
  /**
   * Set the <code>numObjectsWaiting</code> property.
   * @see com.tridium.kitControl.BInterstartDelayMaster#numObjectsWaiting
   */
  public void setNumObjectsWaiting(int v) { setInt(numObjectsWaiting,v,null); }

////////////////////////////////////////////////////////////////
// Action "delayTimerExpired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>delayTimerExpired</code> action.
   * delayTimerExpired
   * @see com.tridium.kitControl.BInterstartDelayMaster#delayTimerExpired()
   */
  public static final Action delayTimerExpired = newAction(0,null);
  
  /**
   * Invoke the <code>delayTimerExpired</code> action.
   * @see com.tridium.kitControl.BInterstartDelayMaster#delayTimerExpired
   */
  public void delayTimerExpired() { invoke(delayTimerExpired,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BInterstartDelayMaster.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  public void started()
  {
    setSlaveLink(getAbsoluteOrd());
  }

  long activeDelayEndTime = 0;
  int activeDelayTime = 0;

  Vector<BComponent> waitList = new Vector<>();

  /**
   *  Returns true if it's OK to start.
 */
  //  FIXX - synchronization???
  public boolean checkInterstartDelay(BComponent output, BRelTime delayTime)
  {

//System.out.println("BInterstartDelayMaster::checkInterstartDelay "  + getActiveDelay());
    if (!getActiveDelay() )
    {
      //  Nothing starting right now, so go ahead


      //  Check for unspecified delay time
      long dtime = delayTime.getMillis();
      if (dtime == 0)
        dtime = getDefaultDelay().getMillis();

      //  If delay time is still 0, just return
      if (dtime == 0)
      {
        return true;
      }

      activeDelayEndTime = Clock.ticks() + dtime;

      setDelayStartTime(Clock.time());
      setActiveDelay(true);
      setDelayTime(BRelTime.make(dtime));
//FIXX      setDelayObject(output);

//System.out.println("interstart delay begin: " + getDelayStartTime() + " requestor " + output.getName());

      // Schedule ourselves to run when the delay expires
      Clock.schedule(this, BRelTime.make(dtime), delayTimerExpired, null);

      return true;
    }
    else
    {
      //  Add object to pending queue
      if (!waitList.contains(output))
      {
        waitList.addElement(output);
        setNumObjectsWaiting(waitList.size());
        //System.out.println("active delay, cannot start object, adding to queue...");
      }
      //else
        //System.out.println("already in queue...");

      return false;
    }
  }


  public void doDelayTimerExpired()
  {
System.out.println("*************** doDelayTimeExpired");

    setDelayStartTime(BAbsTime.DEFAULT);
    setActiveDelay(false);

    // Are other objects waiting to start?
    if (!waitList.isEmpty())
    {
      //  Get next object in wait list
      BControlPoint next = (BControlPoint)waitList.elementAt(0);
      waitList.removeElementAt(0);

      //System.out.println("~~~~~~ Updating: " + next.getName());

      next.execute();
    }

    setNumObjectsWaiting(waitList.size());
  }

}