/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl;

import java.io.*;

import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.status.*;

import javax.baja.control.*;
import javax.baja.control.enums.*;

/**
 * BInterstartDelayControl - No other object using the same delay master 
 * can start for delay time after this object starts
 * If delay is not defined, the default delay on the master will be used.     
 *
 * @author    Andy Saunders
 * @creation   17 Nov 04
 * @version   $Revision: 23$ $Date: 1/20/2004 9:32:24 AM$
 * @since     Baja 1.0
 */

public class BInterstartDelayControl
  extends BBooleanWritable
{ 

  /*-
  
  class BInterstartDelayControl
  {
    properties
    {
      delay: BRelTime    
        --  Delay time for use with this object.  
        --  No other object using the same 
        --  delay master can start for delay
        --  time after this object starts
        --  If delay is not defined, the
        --  default delay on the master will
        --  be used.     
        default {[ BRelTime.DEFAULT ]}
      master: BOrd
        --  Reference to the master interstart
        --  delay object to use
        default {[ BOrd.NULL ]}
      startPending: boolean
        -- true if this object wants to start, but
        -- cannot
        flags { transient, readonly }
        default {[ false  ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.BInterstartDelayControl(3578257790)1.0$ @*/
/* Generated Wed Nov 17 10:50:52 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "delay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>delay</code> property.
   * Delay time for use with this object.  No other object
   * using the same  delay master can start for delay  time after this object starts  If delay is not defined, the  default delay on the master will  be used.
   * @see com.tridium.kitControl.BInterstartDelayControl#getDelay
   * @see com.tridium.kitControl.BInterstartDelayControl#setDelay
   */
  public static final Property delay = newProperty(0, BRelTime.DEFAULT,null);
  
  /**
   * Get the <code>delay</code> property.
   * @see com.tridium.kitControl.BInterstartDelayControl#delay
   */
  public BRelTime getDelay() { return (BRelTime)get(delay); }
  
  /**
   * Set the <code>delay</code> property.
   * @see com.tridium.kitControl.BInterstartDelayControl#delay
   */
  public void setDelay(BRelTime v) { set(delay,v,null); }

////////////////////////////////////////////////////////////////
// Property "master"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>master</code> property.
   * Reference to the master interstart  delay object to
   * use
   * @see com.tridium.kitControl.BInterstartDelayControl#getMaster
   * @see com.tridium.kitControl.BInterstartDelayControl#setMaster
   */
  public static final Property master = newProperty(0, BOrd.NULL,null);
  
  /**
   * Get the <code>master</code> property.
   * @see com.tridium.kitControl.BInterstartDelayControl#master
   */
  public BOrd getMaster() { return (BOrd)get(master); }
  
  /**
   * Set the <code>master</code> property.
   * @see com.tridium.kitControl.BInterstartDelayControl#master
   */
  public void setMaster(BOrd v) { set(master,v,null); }

////////////////////////////////////////////////////////////////
// Property "startPending"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>startPending</code> property.
   * true if this object wants to start, but cannot
   * @see com.tridium.kitControl.BInterstartDelayControl#getStartPending
   * @see com.tridium.kitControl.BInterstartDelayControl#setStartPending
   */
  public static final Property startPending = newProperty(Flags.TRANSIENT|Flags.READONLY, false,null);
  
  /**
   * Get the <code>startPending</code> property.
   * @see com.tridium.kitControl.BInterstartDelayControl#startPending
   */
  public boolean getStartPending() { return getBoolean(startPending); }
  
  /**
   * Set the <code>startPending</code> property.
   * @see com.tridium.kitControl.BInterstartDelayControl#startPending
   */
  public void setStartPending(boolean v) { setBoolean(startPending,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BInterstartDelayControl.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Update
////////////////////////////////////////////////////////////////

  /** 
   * Called when either me or my parent control 
   * point is updated.
   */ 
  public void onExecute(BStatusValue o, Context cx)
  {
    super.onExecute(o, cx);

    BBooleanPoint boolPt = this;
    BStatusBoolean out = (BStatusBoolean)o;

    //  FIXX - handle polarity???

    //  Don't care about transitions to inactive state
    if (out.getValue() == false)    
    {
      wasActive = false;
      return;
    }    

    //  If command level is manual life safety or
    //  manual, it's not subject to interstart delay  
    //  FIXX - desired behavior?
    if (boolPt instanceof BBooleanWritable)
    {
      BPriorityLevel active = getActiveLevel(out);
      if ((active == BPriorityLevel.level_1) ||
          (active == BPriorityLevel.level_8))
        return;
    }

    //  If we were already active, no need to check for
    //  delay
    if (!wasActive)
    {        
      //  Is it OK to start?
      if (checkInterstartDelay(boolPt))
        wasActive = true;
      else
      {
        out.setValue(false);
        out.setStatus(BStatus.make(out.getStatus(), "startPending", BBoolean.make(true)));
        wasActive = false;
      }
    }
    //System.out.println(" BInterstartDelayControl returning working varilabe: " + o);
  }

  BPriorityLevel getActiveLevel(BStatusValue value)
  {
    return BPriorityLevel.make( value.getStatus().geti(BStatus.ACTIVE_LEVEL, BPriorityLevel.FALLBACK) );
  }


  /**
   * Called when a change to active state is detected  
   * Returns true if COS should proceed, false
   * another object is already starting.
   */
  private boolean checkInterstartDelay(BBooleanPoint bootPt)
  {
    BOrd ord = getMaster();
    BInterstartDelayMaster delayMaster = null;

    try
    {
      delayMaster = (BInterstartDelayMaster)ord.resolve(this).get();
    }
    catch(Exception e)
    {
      e.printStackTrace();
      return false;
    }

    boolean okToStart = delayMaster.checkInterstartDelay((BComponent)bootPt, getDelay());

    if (okToStart)
      setStartPending(false);
    else
      setStartPending(true);
    
    return okToStart;      

  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private long interstartDelayStartTime;
  private boolean wasActive = false;

}