/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.util.*;

import javax.baja.alarm.*;

import javax.baja.control.*;
import javax.baja.alarm.ext.*;
import javax.baja.control.enums.*;
import javax.baja.control.ext.*;

/**
 * BElapsedActiveTimeAlarmAlgorithm implements a standard out-of-range
 * alarming algorithm
 *
 * @author    Andy Saunders
 * @creation  19 Nov 2004
 * @version   $Revision: 22$ $Date: 3/30/2004 3:31:03 PM$
 * @since     Baja 1.0
 */
public class BElapsedActiveTimeAlarmAlgorithm
  extends BDiscreteTotalizerAlarmAlgorithm
{
  /*-
  class BElapsedActiveTimeAlarmAlgorithm
  {
    properties
    {
      errorLimit: BRelTime
      -- This is the elapsedActiveTime required to generate an alarm.
        default {[ BRelTime.make(0l) ]}
    }
  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.BElapsedActiveTimeAlarmAlgorithm(913194808)1.0$ @*/
/* Generated Mon Nov 22 13:17:35 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "errorLimit"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>errorLimit</code> property.
   * This is the elapsedActiveTime required to generate
   * an alarm.
   * @see com.tridium.kitControl.BElapsedActiveTimeAlarmAlgorithm#getErrorLimit
   * @see com.tridium.kitControl.BElapsedActiveTimeAlarmAlgorithm#setErrorLimit
   */
  public static final Property errorLimit = newProperty(0, BRelTime.make(0l),null);
  
  /**
   * Get the <code>errorLimit</code> property.
   * @see com.tridium.kitControl.BElapsedActiveTimeAlarmAlgorithm#errorLimit
   */
  public BRelTime getErrorLimit() { return (BRelTime)get(errorLimit); }
  
  /**
   * Set the <code>errorLimit</code> property.
   * @see com.tridium.kitControl.BElapsedActiveTimeAlarmAlgorithm#errorLimit
   */
  public void setErrorLimit(BRelTime v) { set(errorLimit,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BElapsedActiveTimeAlarmAlgorithm.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Parent checking
////////////////////////////////////////////////////////////////

  public void changed(Property p, Context c)
  {
    if(isRunning())
    {
      if( p.equals(errorLimit))
      {
        BBooleanPoint point = (BBooleanPoint)getParentPoint();
        if(point != null)
          point.execute();
      }
    }
  }

////////////////////////////////////////////////////////////////
//  property facet checking
////////////////////////////////////////////////////////////////

  public BFacets getSlotFacets(Slot slot)
  {
    if (slot.equals(errorLimit)   )
    {
      return timeFacet;
    }
    return super.getSlotFacets(slot);
  }

////////////////////////////////////////////////////////////////
//  Algorithm implementation
////////////////////////////////////////////////////////////////

  /**
   * Return true if the present value is normal
   */
  protected boolean isNormal(BDiscreteTotalizerExt totalExt)
  {
    return ( getErrorLimit().getMillis() > totalExt.getElapsedActiveTime().getMillis() );
  }


  protected String getAlarmPresentValueString(BDiscreteTotalizerExt totalizerExt)
  {
    return totalizerExt.getElapsedActiveTime().toString(timeContext);
  }

  protected String getAlarmErrorLimitString()
  {
    return getErrorLimit().toString(timeContext);
  }


  private static BFacets timeFacet = BFacets.make(BFacets.SHOW_DATE, BBoolean.make(false), BFacets.SHOW_MILLISECONDS, BBoolean.make(false));
  private static Context timeContext = new BasicContext(new BasicContext(), timeFacet);
}