/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.util.*;

import javax.baja.alarm.*;

import javax.baja.control.*;
import javax.baja.alarm.ext.*;
import javax.baja.control.enums.*;
import javax.baja.control.ext.*;

/**
 * BChangeOfStateCountAlarmAlgorithm implements a standard out-of-range
 * alarming algorithm
 *
 * @author    Andy Saunders
 * @creation  19 Nov 2004
 * @version   $Revision: 22$ $Date: 3/30/2004 3:31:03 PM$
 * @since     Baja 1.0
 */
public class BChangeOfStateCountAlarmAlgorithm
  extends BDiscreteTotalizerAlarmAlgorithm
{
  /*-
  class BChangeOfStateCountAlarmAlgorithm
  {
    properties
    {
      errorLimit: int
      -- This is the change of state count required to generate an alarm.
        default {[ 0 ]}
    }
  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.BChangeOfStateCountAlarmAlgorithm(342099615)1.0$ @*/
/* Generated Mon Nov 22 17:15:26 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "errorLimit"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>errorLimit</code> property.
   * This is the change of state count required to generate
   * an alarm.
   * @see com.tridium.kitControl.BChangeOfStateCountAlarmAlgorithm#getErrorLimit
   * @see com.tridium.kitControl.BChangeOfStateCountAlarmAlgorithm#setErrorLimit
   */
  public static final Property errorLimit = newProperty(0, 0,null);
  
  /**
   * Get the <code>errorLimit</code> property.
   * @see com.tridium.kitControl.BChangeOfStateCountAlarmAlgorithm#errorLimit
   */
  public int getErrorLimit() { return getInt(errorLimit); }
  
  /**
   * Set the <code>errorLimit</code> property.
   * @see com.tridium.kitControl.BChangeOfStateCountAlarmAlgorithm#errorLimit
   */
  public void setErrorLimit(int v) { setInt(errorLimit,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BChangeOfStateCountAlarmAlgorithm.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Parent checking
////////////////////////////////////////////////////////////////

  public void changed(Property p, Context c)
  {
    if(isRunning())
    {
      if( p.equals(errorLimit))
      {
        BBooleanPoint point = (BBooleanPoint)getParentPoint();
        if(point != null)
          point.execute();
        return;
      }
    }
    super.changed(p, c);
  }

////////////////////////////////////////////////////////////////
//  property facet checking
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
//  Algorithm implementation
////////////////////////////////////////////////////////////////

  /**
   * Return true if the present value is normal
   */
  protected boolean isNormal(BDiscreteTotalizerExt totalExt)
  {
    return ( getErrorLimit() > totalExt.getChangeOfStateCount() );
  }


  protected String getAlarmPresentValueString(BDiscreteTotalizerExt totalizerExt)
  {
    return Integer.toString(totalizerExt.getChangeOfStateCount());
  }

  protected String getAlarmErrorLimitString()
  {
    return Integer.toString(getErrorLimit());
  }


}