/*
 * Copyright 2004, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.history.ext;

import java.io.IOException;
import javax.baja.control.BBooleanPoint;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * This is an extension for collecting boolean values on a fixed interval.
 *
 * @author    John Sublett
 * @creation  23 Nov 2004
 * @version   $Revision: 2$ $Date: 12/7/04 2:48:05 PM EST$
 * @since     Baja 1.0
 */
public class BBooleanIntervalHistoryExt
  extends BIntervalHistoryExt
{
  /*-

  class BBooleanIntervalHistoryExt
  {
    properties
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.history.ext.BBooleanIntervalHistoryExt(711272978)1.0$ @*/
/* Generated Mon Nov 29 10:27:28 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBooleanIntervalHistoryExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Extensions may only be placed in BControlPoints.
   */
  @Override
  public boolean isParentLegal(BComponent parent)
  {
    return parent instanceof BBooleanPoint;
  }

  /**
   * This extension writes boolean trend records. (history:BooleanTrendRecord)
   */
  @Override
  public Type getRecordType()
  {
    return BBooleanTrendRecord.TYPE;
  }

  /**
   * Init on start.
   */
  @Override
  public void started()
    throws Exception
  {
    super.started();
    rec = new BBooleanTrendRecord();
  }

  /**
   * Write a record for the specified timestamp and value.
   */
  @Override
  protected void writeRecord(BAbsTime timestamp, BStatusValue out)
    throws IOException
  {
    append(rec.set(timestamp,
                   ((BStatusBoolean)out).getValue(),
                   out.getStatus()));
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private BBooleanTrendRecord rec;



}
