/*
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.history;

import javax.baja.agent.BIAgent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BITrendHistoryAgent is a marker interface implemented by agents
 * (ie. views) on BIHistory instances that have a record type of
 * BTrendRecord.  It is used to help filter and sort the registered
 * agents (views) on a BIHistory instance.  It should be implemented
 * by agents (views) that only support histories that contain trend
 * records.
 *
 * @see javax.baja.agent.BIAgent
 * @see javax.baja.history.BTrendRecord
 *
 * @author Scott Hoye
 * @author JJ Frankovich
 * @creation  1/27/2014
 * @since Niagara 4.0
 *
 */
public interface BITrendHistoryAgent
  extends BIAgent
{
  public static final Type TYPE = Sys.loadType(BITrendHistoryAgent.class);
}