/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.history;

import javax.baja.sys.BInterface;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIHistorySource is an interface implemented by objects that 
 * create a history.  It is used to receive notification
 * that a BHistoryConfig property has changed.  When
 * a BHistoryConfig property changes, the config instance
 * checks to see if its parent is a BIHistorySource.  If so,
 * it notifies the parent that the config has changed.
 *
 * @author    John Sublett
 * @creation  17 Apr 2003
 * @version   $Revision: 1$ $Date: 4/17/03 11:50:53 AM EDT$
 * @since     Baja 1.0
 */
public interface BIHistorySource
  extends BInterface
{
  public static final Type TYPE = Sys.loadType(BIHistorySource.class);
  
  /**
   * Receive notification that a history configuration has
   * changed.
   */
  public void historyConfigChanged(BHistoryConfig config, Property p);
}