/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.history;

import javax.baja.security.BIProtected;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

/**
 * BIHistory is the interface for accessing the historical data of a
 * Baja history.
 *
 * @author John Sublett
 */
public interface BIHistory
  extends BISpaceNode, BIProtected, BIPropertyContainer
{
  Type TYPE = Sys.loadType(BIHistory.class);

  /**
   * Get the unique identifier for this history.
   */
  BHistoryId getId();

  /**
   * Get the record type for this history.  The record type
   * is also available as part of the history config, but if
   * the record type is all you need, it is often more efficient
   * to get it with this method than through the config.
   */
  BTypeSpec getRecordType();

  /**
   * Get the configuration for this history.
   */
  BHistoryConfig getConfig();

  /**
   * Close this history and release any associated resources.
   */
  void close();
  
}
