/*
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.history;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIChartableHistoryAgent is a marker interface implemented by agents
 * (ie. views) on BIHistory instances that have a record type of
 * BTrendRecord and which also support charting (ie. numeric, boolean,
 * or enumerated trend record types typically support charting).  It is
 * used to help filter and sort the registered agents (views) on a
 * BIHistory instance.  It should be implemented by agents (views) that
 * only support histories that contain chartable trend records.
 *
 * @see javax.baja.history.BITrendHistoryAgent
 * @see javax.baja.history.BTrendRecord
 *
 * @author Scott Hoye
 * @creation  1/27/2014
 * @since Niagara 4.0
 *
 */
public interface BIChartableHistoryAgent
  extends BITrendHistoryAgent
{
  public static final Type TYPE = Sys.loadType(BIChartableHistoryAgent.class);
}
